/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import com.google.common.collect.Sets;
import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHelper;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BaseBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.util.ApexUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public final class FacingBlockComponent
extends BaseBlockComponent {
    public static final ComponentType<BlockComponent, FacingBlockComponent, Block, Builder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("facing"), Builder::new, FacingBlockComponent::new);
    private final EnumProperty<Direction> property;
    private final Direction defaultFacing;
    private final Function<BlockPlaceContext, Direction> facingForPlacement;
    private final Set<Property<Direction>> compatibilities;

    private FacingBlockComponent(ComponentHolder<BlockComponent, Block> holder, Builder builder) {
        super(holder);
        this.property = EnumProperty.create((String)"facing_component", Direction.class, (Enum[])((Direction[])builder.directions.toArray(Direction[]::new)));
        this.defaultFacing = Objects.requireNonNullElseGet(builder.defaultFacing, () -> (Direction)this.property.getPossibleValues().getFirst());
        this.facingForPlacement = Objects.requireNonNullElseGet(builder.facingForPlacement, () -> context -> this.getDefaultFacing());
        this.compatibilities = Set.copyOf(builder.compatibilities);
        ComponentHelper.validateCompatibilities(this.property, this.compatibilities);
    }

    public EnumProperty<Direction> getProperty() {
        return this.property;
    }

    public Direction getDefaultFacing() {
        return this.defaultFacing;
    }

    public Direction get(BlockState blockState) {
        return (Direction)blockState.getValue(this.property);
    }

    public BlockState set(BlockState blockState, Direction facing) {
        for (Property<Direction> compatibility : this.compatibilities) {
            blockState = (BlockState)blockState.setValue(compatibility, (Comparable)facing);
        }
        return (BlockState)blockState.setValue(this.property, (Comparable)facing);
    }

    public BlockState setFor(BlockPlaceContext context, BlockState blockState) {
        Direction facing = this.facingForPlacement.apply(context);
        return this.set(blockState, facing);
    }

    @Override
    public BlockState registerDefaultBlockState(BlockState blockState) {
        for (Property<Direction> compatibility : this.compatibilities) {
            blockState = (BlockState)blockState.setValue(compatibility, (Comparable)this.defaultFacing);
        }
        return this.set(blockState, this.defaultFacing);
    }

    @Override
    public void createBlockStateDefinition(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)this.property);
        this.compatibilities.forEach(consumer);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context, BlockState blockState) {
        return this.setFor(context, blockState);
    }

    @Override
    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return this.set(blockState, rotation.rotate(this.get(blockState)));
    }

    @Override
    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation(this.get(blockState)));
    }

    public static void registerHorizontal(ComponentRegistrar<BlockComponent, Block> registrar, UnaryOperator<Builder> additional) {
        registrar.register(COMPONENT_TYPE, builder -> (Builder)additional.apply(builder.allowing(Direction.Plane.HORIZONTAL).defaultFacing(Direction.NORTH).facingForPlacement(context -> context.getHorizontalDirection().getOpposite()).supporting((Property<Direction>)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public static void registerHorizontal(ComponentRegistrar<BlockComponent, Block> registrar) {
        FacingBlockComponent.registerHorizontal(registrar, UnaryOperator.identity());
    }

    public static final class Builder
    implements ComponentBuilder {
        private final Set<Direction> directions = EnumSet.noneOf(Direction.class);
        @Nullable
        private Direction defaultFacing = null;
        @Nullable
        private Function<BlockPlaceContext, Direction> facingForPlacement;
        private final Set<Property<Direction>> compatibilities = Sets.newHashSet();

        public Builder allowing(Direction ... directions) {
            Collections.addAll(this.directions, directions);
            return this;
        }

        public Builder allowing(Direction.Plane plane) {
            ApexUtil.addAll(this.directions, plane);
            return this;
        }

        public Builder disallowing(Direction ... directions) {
            ApexUtil.removeAll(this.directions, directions);
            return this;
        }

        public Builder disallowing(Direction plane) {
            ApexUtil.removeAll(this.directions, plane);
            return this;
        }

        public Builder defaultFacing(Direction defaultFacing) {
            this.defaultFacing = defaultFacing;
            return this.allowing(defaultFacing);
        }

        public Builder facingForPlacement(Function<BlockPlaceContext, Direction> facingForPlacement) {
            this.facingForPlacement = facingForPlacement;
            return this;
        }

        public Builder supporting(Property<Direction> property, Property<Direction> ... properties) {
            Collections.addAll(this.compatibilities, properties);
            return this.supporting(property);
        }

        public Builder supporting(Property<Direction> property) {
            this.compatibilities.add(property);
            return this;
        }
    }
}

