/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BaseBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public final class FluidLoggedBlockComponent
extends BaseBlockComponent
implements BucketPickup,
LiquidBlockContainer {
    public static final ComponentType<BlockComponent, FluidLoggedBlockComponent, Block, Builder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("fluid_logged"), Builder::new, FluidLoggedBlockComponent::new);
    private final BooleanProperty property;
    private final Fluid fluid;
    private final UnaryOperator<ItemStack> bucketModifier;
    private final Predicate<FluidState> isMatchingFluid;

    private FluidLoggedBlockComponent(ComponentHolder<BlockComponent, Block> holder, Builder builder) {
        super(holder);
        Fluid fluid;
        Fluid fluid2 = builder.fluid;
        if (fluid2 instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid2;
            fluid = flowing.getSource();
        } else {
            fluid = builder.fluid;
        }
        this.fluid = fluid;
        this.bucketModifier = builder.bucketModifier;
        this.isMatchingFluid = Objects.requireNonNullElseGet(builder.isMatchingFluid, () -> fluidState -> fluidState.is(this.fluid));
        this.property = (BooleanProperty)Util.make(() -> {
            if (this.fluid.isSame((Fluid)Fluids.WATER)) {
                return BlockStateProperties.WATERLOGGED;
            }
            ResourceLocation fluidName = Objects.requireNonNull(BuiltInRegistries.FLUID.getKey((Object)this.fluid));
            String propertyName = fluidName.getPath() + "_logged";
            String namespace = fluidName.getNamespace();
            if (!namespace.equals("minecraft")) {
                propertyName = namespace + "_";
            }
            return BooleanProperty.create((String)propertyName);
        });
    }

    public boolean get(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)this.property);
    }

    public BlockState set(BlockState blockState, boolean fluidLogged) {
        return (BlockState)blockState.setValue((Property)this.property, (Comparable)Boolean.valueOf(fluidLogged));
    }

    public BlockState setFor(BlockPlaceContext context, BlockState blockState) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return this.set(blockState, this.matches(fluidState));
    }

    public boolean matches(FluidState fluidState) {
        return fluidState.isSourceOfType(this.fluid) && this.isMatchingFluid.test(fluidState);
    }

    public boolean matches(Fluid fluid) {
        return this.matches(fluid.defaultFluidState());
    }

    public ItemStack pickupBlock(@Nullable LivingEntity player, LevelAccessor level, BlockPos pos, BlockState blockState) {
        if (this.get(blockState)) {
            level.setBlock(pos, this.set(blockState, false), 3);
            if (!blockState.canSurvive((LevelReader)level, pos)) {
                level.destroyBlock(pos, true);
            }
            ItemStack bucket = this.fluid.getBucket().getDefaultInstance();
            return (ItemStack)this.bucketModifier.apply(bucket);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return this.fluid.getPickupSound();
    }

    public boolean canPlaceLiquid(@Nullable LivingEntity player, BlockGetter level, BlockPos pos, BlockState blockState, Fluid fluid) {
        return this.matches(fluid);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState blockState, FluidState fluidState) {
        if (!this.get(blockState) && this.isMatchingFluid.test(fluidState)) {
            if (!level.isClientSide()) {
                Fluid fluid = fluidState.getType();
                level.setBlock(pos, this.set(blockState, true), 3);
                level.scheduleTick(pos, fluid, fluid.getTickDelay((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    @Override
    public BlockState registerDefaultBlockState(BlockState blockState) {
        return this.set(blockState, false);
    }

    @Override
    public void createBlockStateDefinition(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)this.property);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context, BlockState blockState) {
        return this.setFor(context, blockState);
    }

    @Override
    public FluidState getFluidState(BlockState blockState, FluidState fluidState) {
        FluidState fluidState2;
        if (!this.get(blockState)) {
            return fluidState;
        }
        Fluid fluid = this.fluid;
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            fluidState2 = flowing.getSource(false);
        } else {
            fluidState2 = this.fluid.defaultFluidState();
        }
        return fluidState2;
    }

    @Override
    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        if (this.get(blockState)) {
            tickAccess.scheduleTick(pos, this.fluid, this.fluid.getTickDelay(level));
        }
        return super.updateShape(blockState, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }

    public static void registerWater(ComponentRegistrar<BlockComponent, Block> registrar) {
        registrar.register(COMPONENT_TYPE, builder -> builder.fluid((Fluid)Fluids.WATER).matchingFluid(fluidState -> fluidState.is(FluidTags.WATER)));
    }

    public static void registerLava(ComponentRegistrar<BlockComponent, Block> registrar) {
        registrar.register(COMPONENT_TYPE, builder -> builder.fluid((Fluid)Fluids.LAVA).matchingFluid(fluidState -> fluidState.is(FluidTags.LAVA)));
    }

    public static final class Builder
    implements ComponentBuilder {
        private Fluid fluid = Fluids.WATER;
        private UnaryOperator<ItemStack> bucketModifier = UnaryOperator.identity();
        @Nullable
        private Predicate<FluidState> isMatchingFluid;

        public Builder fluid(Fluid fluid) {
            this.fluid = fluid;
            return this;
        }

        public Builder bucketModifier(UnaryOperator<ItemStack> bucketModifier) {
            this.bucketModifier = bucketModifier;
            return this;
        }

        public Builder matchingFluid(Predicate<FluidState> isMatchingFluid) {
            this.isMatchingFluid = isMatchingFluid;
            return this;
        }
    }
}

