/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import com.google.common.collect.Lists;
import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BaseBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.util.ApexUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public final class MultiBlockComponent
extends BaseBlockComponent {
    public static final ComponentType<BlockComponent, MultiBlockComponent, Block, Builder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("multi_block"), Builder::new, MultiBlockComponent::new);
    public static final int ORIGIN_INDEX = 0;
    private static final Int2ObjectMap<IntegerProperty> PROPERTIES = new Int2ObjectOpenHashMap();
    private final List<Vector3ic> localPositions;
    private final IntegerProperty property;
    private final BiFunction<BlockState, Vector3ic, Vector3ic> rotationFunction;

    private MultiBlockComponent(ComponentHolder<BlockComponent, Block> holder, Builder builder) {
        super(holder);
        this.localPositions = List.copyOf(builder.positions);
        this.property = (IntegerProperty)PROPERTIES.computeIfAbsent(this.localPositions.size(), size -> IntegerProperty.create((String)"multi_block_index", (int)0, (int)(size - 1)));
        this.rotationFunction = Objects.requireNonNullElseGet(builder.rotationFunction, () -> (blockState, pos) -> pos);
    }

    public int size() {
        return this.localPositions.size();
    }

    public IntegerProperty property() {
        return this.property;
    }

    public List<Vector3ic> localPositions() {
        return this.localPositions;
    }

    public int indexOf(BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.property);
    }

    public BlockState withIndex(BlockState blockState, int index) {
        return (BlockState)blockState.setValue((Property)this.property, (Comparable)Integer.valueOf(index));
    }

    public BlockPos getOrigin(BlockPos pos, BlockState blockState) {
        Vector3ic rotatedLocalPosition = this.getRotatedLocalPosition(blockState);
        return pos.offset(-rotatedLocalPosition.x(), -rotatedLocalPosition.y(), -rotatedLocalPosition.z());
    }

    public BlockPos getPos(BlockPos origin, BlockState blockState) {
        Vector3ic rotatedLocalPosition = this.getRotatedLocalPosition(blockState);
        return origin.offset(rotatedLocalPosition.x(), rotatedLocalPosition.y(), rotatedLocalPosition.z());
    }

    public Vector3ic getRotatedLocalPosition(BlockState blockState) {
        int index = this.indexOf(blockState);
        Vector3ic localPosition = this.localPositions.get(index);
        return this.rotate(blockState, localPosition);
    }

    Vector3ic rotate(BlockState blockState, Vector3ic pos) {
        return this.rotationFunction.apply(blockState, pos);
    }

    @Override
    public BlockState registerDefaultBlockState(BlockState blockState) {
        return (BlockState)blockState.setValue((Property)this.property, (Comparable)Integer.valueOf(0));
    }

    @Override
    public void createBlockStateDefinition(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)this.property);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context, BlockState blockState) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player placer = context.getPlayer();
        BlockState placementBlockState = this.withIndex(blockState, 0);
        int index = this.indexOf(placementBlockState);
        BlockPos origin = this.getOrigin(pos, placementBlockState);
        for (int i = 0; i < this.localPositions.size(); ++i) {
            if (i == index) continue;
            BlockState otherBlockState = this.withIndex(placementBlockState, i);
            BlockPos otherPos = this.getPos(origin, otherBlockState);
            if (!ApexUtil.isInBounds(level, otherPos)) {
                return null;
            }
            if (ApexUtil.canPlace((LevelReader)level, otherPos, otherBlockState, (LivingEntity)placer)) continue;
            return null;
        }
        return placementBlockState;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        int index = this.indexOf(blockState);
        BlockPos origin = this.getOrigin(pos, blockState);
        for (int i = 0; i < this.localPositions.size(); ++i) {
            if (i == index) continue;
            BlockState otherBlockState = this.withIndex(blockState, i);
            BlockPos otherPos = this.getPos(origin, otherBlockState);
            level.setBlock(otherPos, otherBlockState, 3);
        }
    }

    @Override
    public void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        int index = this.indexOf(blockState);
        BlockPos origin = this.getOrigin(pos, blockState);
        for (int i = 0; i < this.localPositions.size(); ++i) {
            BlockPos otherPos;
            BlockState otherBlockState;
            if (i == index || !(otherBlockState = level.getBlockState(otherPos = this.getPos(origin, this.withIndex(blockState, i)))).is(blockState.getBlock())) continue;
            level.destroyBlock(otherPos, false);
        }
    }

    public static BlockPos getBlockEntityPos(BlockPos pos, BlockState blockState) {
        MultiBlockComponent multiBlock = BlockComponentHelper.getComponent(blockState, BlockComponentTypes.MULTI_BLOCK);
        if (multiBlock != null && multiBlock.indexOf(blockState) != 0) {
            return multiBlock.getOrigin(pos, blockState);
        }
        return pos;
    }

    public static BlockPos getBlockEntityPos(BlockGetter level, BlockPos pos) {
        return MultiBlockComponent.getBlockEntityPos(pos, level.getBlockState(pos));
    }

    public static VoxelShape fixVoxelShape(VoxelShape shape, MultiBlockComponent multiBlock, BlockState blockState, BlockPos pos) {
        BlockPos origin = multiBlock.getOrigin(pos, blockState);
        BlockPos offset = pos.subtract((Vec3i)origin);
        return shape.move((double)(-offset.getX()), (double)(-offset.getY()), (double)(-offset.getZ()));
    }

    public static final class Builder
    implements ComponentBuilder {
        private final List<Vector3ic> positions = Lists.newArrayList();
        @Nullable
        private BiFunction<BlockState, Vector3ic, Vector3ic> rotationFunction = null;

        private Builder() {
            this.with(0, 0, 0);
        }

        public Builder with(Vector3ic position) {
            this.positions.add(position);
            return this;
        }

        public Builder with(int x, int y, int z) {
            return this.with((Vector3ic)new Vector3i(x, y, z));
        }

        public Builder rotating(BiFunction<BlockState, Vector3ic, Vector3ic> rotationFunction) {
            this.rotationFunction = rotationFunction;
            return this;
        }

        public Builder rotating(Function<BlockState, Property<Direction>> propertyLookup) {
            return this.rotating((BlockState blockState, Vector3ic pos) -> {
                Property property = (Property)propertyLookup.apply((BlockState)blockState);
                Direction facing = (Direction)blockState.getValue(property);
                return Builder.rotate(pos, switch (facing) {
                    case Direction.NORTH -> Rotation.CLOCKWISE_90;
                    case Direction.SOUTH -> Rotation.COUNTERCLOCKWISE_90;
                    case Direction.EAST -> Rotation.CLOCKWISE_180;
                    default -> Rotation.NONE;
                });
            });
        }

        public Builder rotating(Property<Direction> property) {
            return this.rotating((BlockState blockState) -> property);
        }

        public Builder rotatingFromComponent() {
            return this.rotating((BlockState blockState) -> BlockComponentHelper.getComponentOrThrow(blockState, BlockComponentTypes.FACING).getProperty());
        }

        private static Vector3ic rotate(Vector3ic pos, Rotation rotation) {
            return switch (rotation) {
                default -> throw new MatchException(null, null);
                case Rotation.CLOCKWISE_90 -> new Vector3i(-pos.z(), pos.y(), pos.x());
                case Rotation.CLOCKWISE_180 -> new Vector3i(-pos.x(), pos.y(), -pos.z());
                case Rotation.COUNTERCLOCKWISE_90 -> new Vector3i(pos.z(), pos.y(), -pos.x());
                case Rotation.NONE -> pos;
            };
        }
    }
}

