/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BaseBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.jetbrains.annotations.Nullable;

public final class RotationBlockComponent
extends BaseBlockComponent {
    public static final ComponentType<BlockComponent, RotationBlockComponent, Block, Builder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("rotation"), Builder::new, RotationBlockComponent::new);
    public static final int DEFAULT_SEGMENT = 0;
    private final int segments;
    private final ToIntFunction<BlockPlaceContext> segmentForPlacement;
    private final IntegerProperty property;

    private RotationBlockComponent(ComponentHolder<BlockComponent, Block> holder, Builder builder) {
        super(holder);
        if (builder.segments <= 0) {
            throw new IllegalStateException("RotationComponent Segments must be > 0");
        }
        this.segments = builder.segments;
        this.segmentForPlacement = Objects.requireNonNullElseGet(builder.segmentForPlacement, () -> context -> 0);
        this.property = IntegerProperty.create((String)"rotation", (int)0, (int)this.segments);
    }

    public IntegerProperty getProperty() {
        return this.property;
    }

    public int getSegments() {
        return this.segments;
    }

    public int get(BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.property);
    }

    public BlockState set(BlockState blockState, int segment) {
        return (BlockState)blockState.setValue((Property)this.property, (Comparable)Integer.valueOf(segment));
    }

    public BlockState setFor(BlockPlaceContext context, BlockState blockState) {
        int segment = this.segmentForPlacement.applyAsInt(context);
        return this.set(blockState, segment);
    }

    @Override
    public BlockState registerDefaultBlockState(BlockState blockState) {
        return this.set(blockState, 0);
    }

    @Override
    public void createBlockStateDefinition(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)this.property);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context, BlockState blockState) {
        return this.setFor(context, blockState);
    }

    @Override
    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return this.set(blockState, rotation.rotate(this.get(blockState), this.segments));
    }

    @Override
    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return this.set(blockState, mirror.mirror(this.get(blockState), this.segments));
    }

    public static void register16(ComponentRegistrar<BlockComponent, Block> registrar, UnaryOperator<Builder> additional) {
        registrar.register(COMPONENT_TYPE, builder -> (Builder)additional.apply(builder.segments(16).facingForPlacement(context -> RotationSegment.convertToSegment((float)(context.getRotation() + 180.0f)))));
    }

    public static void register16(ComponentRegistrar<BlockComponent, Block> registrar) {
        RotationBlockComponent.register16(registrar, UnaryOperator.identity());
    }

    public static final class Builder
    implements ComponentBuilder {
        private int segments = -1;
        @Nullable
        private ToIntFunction<BlockPlaceContext> segmentForPlacement;

        public Builder segments(int segments) {
            this.segments = segments;
            return this;
        }

        public Builder facingForPlacement(ToIntFunction<BlockPlaceContext> segmentForPlacement) {
            this.segmentForPlacement = segmentForPlacement;
            return this;
        }
    }
}

