/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.core.seat.SeatEntity;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BaseBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.util.ApexTags;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;

public final class SeatBlockComponent
extends BaseBlockComponent {
    public static final ComponentType<BlockComponent, SeatBlockComponent, Block, ComponentBuilder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("seat"), SeatBlockComponent::new);
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    public static final EntityCapability<Runnable, @NotNull CapabilityContext> SEATED_CAPABILITY = EntityCapability.create((ResourceLocation)ApexCore.identifier("seated"), Runnable.class, CapabilityContext.class);
    public static final EntityCapability<Runnable, @NotNull CapabilityContext> UNSEATED_CAPABILITY = EntityCapability.create((ResourceLocation)ApexCore.identifier("unseated"), Runnable.class, CapabilityContext.class);
    public static final EntityCapability<BooleanSupplier, @NotNull CapabilityContext> MAY_SIT_CAPABILITY = EntityCapability.create((ResourceLocation)ApexCore.identifier("may_sit"), BooleanSupplier.class, CapabilityContext.class);

    private SeatBlockComponent(ComponentHolder<BlockComponent, Block> holder) {
        super(holder);
    }

    @Override
    public BlockState registerDefaultBlockState(BlockState blockState) {
        return (BlockState)blockState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void createBlockStateDefinition(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)OCCUPIED);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        InteractionResult result = this.trySit(level, pos, (LivingEntity)player);
        if (!result.consumesAction()) {
            result = this.tryUnsit(level, pos);
        }
        return result;
    }

    @Override
    public void stepOn(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        if (!(entity instanceof Player) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.trySit(level, pos, living);
        }
    }

    private InteractionResult trySit(Level level, BlockPos pos, LivingEntity sitter) {
        return SeatEntity.sit(level, pos, sitter) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private InteractionResult tryUnsit(Level level, BlockPos pos) {
        return SeatEntity.unsit(level, pos) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static boolean isSeat(BlockState blockState) {
        return BlockComponentHelper.hasComponent(blockState, COMPONENT_TYPE);
    }

    public static boolean isOccupied(BlockState blockState) {
        return SeatBlockComponent.isSeat(blockState) ? (Boolean)blockState.getValue((Property)OCCUPIED) : false;
    }

    public static void setOccupied(LevelWriter level, BlockPos pos, BlockState blockState, boolean occupied) {
        if (!SeatBlockComponent.isSeat(blockState)) {
            return;
        }
        BlockState newBlockState = (BlockState)blockState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied));
        if (newBlockState != blockState) {
            level.setBlock(pos, newBlockState, 3);
        }
        BlockComponentHelper.runForComponent(newBlockState, BlockComponentTypes.MULTI_BLOCK, multiBlock -> {
            int index = multiBlock.indexOf(newBlockState);
            if (newBlockState.is(ApexTags.Blocks.SEAT_ORIGIN_ONLY)) {
                BlockPos origin = multiBlock.getOrigin(pos, newBlockState);
                for (int i = 0; i < multiBlock.size(); ++i) {
                    if (i == index) continue;
                    BlockState otherBlockState = multiBlock.withIndex(newBlockState, i);
                    level.setBlock(multiBlock.getPos(origin, otherBlockState), (BlockState)otherBlockState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
                }
            }
        });
    }

    public static void setOccupied(Level level, BlockPos pos, boolean occupied) {
        SeatBlockComponent.setOccupied((LevelWriter)level, pos, level.getBlockState(pos), occupied);
    }

    public static boolean maySit(EntityType<?> entityType) {
        return !entityType.is(ApexTags.EntityTypes.SEAT_BLACKLIST);
    }

    public static boolean maySit(Entity entity) {
        if (!SeatBlockComponent.maySit(entity.getType())) {
            return false;
        }
        if (entity.hasControllingPassenger()) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        BooleanSupplier maySit = (BooleanSupplier)entity.getCapability(MAY_SIT_CAPABILITY, (Object)new CapabilityContext(entity.getOnPos(), entity.getBlockStateOn()));
        return maySit == null || maySit.getAsBoolean();
    }

    public static void notifyCapabilityListeners(Entity entity, BlockPos pos, BlockState blockState, boolean seated) {
        Runnable capability = (Runnable)entity.getCapability(seated ? SEATED_CAPABILITY : UNSEATED_CAPABILITY, (Object)new CapabilityContext(pos, blockState));
        if (capability != null) {
            capability.run();
        }
    }

    public static <TEntity extends Entity> void registerCapabilities(RegisterCapabilitiesEvent event, EntityType<TEntity> entityType, TriConsumer<TEntity, BlockPos, BlockState> seated, TriConsumer<TEntity, BlockPos, BlockState> unseated) {
        event.registerEntity(SEATED_CAPABILITY, entityType, (entity, context) -> () -> seated.accept(entity, (Object)context.pos(), (Object)context.blockState()));
        event.registerEntity(UNSEATED_CAPABILITY, entityType, (entity, context) -> () -> unseated.accept(entity, (Object)context.pos(), (Object)context.blockState()));
    }

    @SafeVarargs
    public static <TEntity extends Entity> void registerCapabilities(RegisterCapabilitiesEvent event, TriConsumer<TEntity, BlockPos, BlockState> seated, TriConsumer<TEntity, BlockPos, BlockState> unseated, EntityType<? extends TEntity> ... entityTypes) {
        for (EntityType<? extends TEntity> entityType : entityTypes) {
            SeatBlockComponent.registerCapabilities(event, entityType, (arg_0, arg_1, arg_2) -> seated.accept(arg_0, arg_1, arg_2), (arg_0, arg_1, arg_2) -> unseated.accept(arg_0, arg_1, arg_2));
        }
    }

    public record CapabilityContext(BlockPos pos, BlockState blockState) {
    }
}

