/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.context;

import java.util.function.Function;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;

public interface ProviderContext {
    public String modId();

    public ResourceManager getResourceManager(PackType var1);

    public FeatureFlagSet enabledFeatures();

    public static ProviderContext of(final String modId, final Function<PackType, ResourceManager> resourceManagerGetter, final FeatureFlagSet enabledFeatures) {
        return new ProviderContext(){

            @Override
            public String modId() {
                return modId;
            }

            @Override
            public ResourceManager getResourceManager(PackType packType) {
                return (ResourceManager)resourceManagerGetter.apply(packType);
            }

            @Override
            public FeatureFlagSet enabledFeatures() {
                return enabledFeatures;
            }
        };
    }
}

