/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.context;

import dev.apexstudios.apexcore.lib.data.provider.context.ProviderListenerContext;
import java.nio.file.Path;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;

public interface ProviderOutputContext
extends ProviderListenerContext {
    public PackOutput output();

    default public PackOutput.PathProvider pathProvider(PackOutput.Target packType, String kind) {
        return this.output().createPathProvider(packType, kind);
    }

    default public PackOutput.PathProvider pathProvider(PackType packType, String kind) {
        return this.pathProvider(ProviderOutputContext.packType(packType), kind);
    }

    default public PackOutput.PathProvider tagPathProvider(ResourceKey<? extends Registry<?>> registryKey) {
        return this.output().createRegistryTagsPathProvider(registryKey);
    }

    default public PackOutput.PathProvider elementPathProvider(ResourceKey<? extends Registry<?>> registryKey) {
        return this.output().createRegistryElementsPathProvider(registryKey);
    }

    default public Path outputPath(PackOutput.Target packType, ResourceLocation resourcePath) {
        return this.output().getOutputFolder(packType).resolve(resourcePath.getNamespace()).resolve(resourcePath.getPath());
    }

    default public Path outputPath(PackOutput.Target packType, String ... path) {
        return this.outputPath(packType, ResourceLocation.fromNamespaceAndPath((String)this.modId(), (String)String.join((CharSequence)"/", path)));
    }

    default public Path outputPath(PackType packType, ResourceLocation resourcePath) {
        return this.outputPath(ProviderOutputContext.packType(packType), resourcePath);
    }

    default public Path outputPath(PackType packType, String ... path) {
        return this.outputPath(ProviderOutputContext.packType(packType), path);
    }

    public static ProviderOutputContext of(final ProviderListenerContext context, final PackOutput output) {
        return new ProviderOutputContext(){

            @Override
            public PackOutput output() {
                return output;
            }

            @Override
            public String modId() {
                return context.modId();
            }

            @Override
            public ResourceManager getResourceManager(PackType packType) {
                return context.getResourceManager(packType);
            }

            @Override
            public FeatureFlagSet enabledFeatures() {
                return context.enabledFeatures();
            }

            @Override
            public HolderLookup.Provider registries() {
                return context.registries();
            }
        };
    }

    public static PackOutput.Target packType(PackType packType) {
        return switch (packType) {
            default -> throw new MatchException(null, null);
            case PackType.CLIENT_RESOURCES -> PackOutput.Target.RESOURCE_PACK;
            case PackType.SERVER_DATA -> PackOutput.Target.DATA_PACK;
        };
    }
}

