/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.loot;

import dev.apexstudios.apexcore.lib.data.provider.loot.LootTableSubProvider;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public interface BlockLootSubProvider
extends LootTableSubProvider {
    public static final float[] NORMAL_LEAVES_SAPLING_CHANCES = net.minecraft.data.loot.BlockLootSubProvider.NORMAL_LEAVES_SAPLING_CHANCES;
    public static final float[] NORMAL_LEAVES_STICK_CHANCES = net.minecraft.data.loot.BlockLootSubProvider.NORMAL_LEAVES_STICK_CHANCES;
    public static final float[] JUNGLE_LEAVES_SAPLING_CHANGES = VanillaBlockLoot.JUNGLE_LEAVES_SAPLING_CHANGES;
    public static final Set<Item> VANILLA_EXPLOSION_RESISTANT = VanillaBlockLoot.EXPLOSION_RESISTANT;

    default public void accept(Holder<Block> block, Supplier<LootTable.Builder> lootTable) {
        this.accept((Block)block.value(), lootTable);
    }

    default public void accept(Holder<Block> block, LootTable.Builder lootTable) {
        this.accept(block, () -> lootTable);
    }

    default public void accept(Block block, Supplier<LootTable.Builder> lootTable) {
        this.accept((ResourceKey<LootTable>)((ResourceKey)block.getLootTable().orElseThrow(() -> new IllegalStateException("Block " + String.valueOf(block.builtInRegistryHolder().key().location()) + " does not have loot table"))), lootTable);
    }

    default public void accept(Block block, LootTable.Builder lootTable) {
        this.accept(block, () -> lootTable);
    }

    public void explosionResistant(ItemLike var1);

    public boolean isExplosionResistant(ItemLike var1);

    default public LootItemCondition.Builder hasSilkTouch(HolderLookup.Provider registries) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, (DataComponentPredicate)EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantments.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))).build()));
    }

    default public LootItemCondition.Builder doesNotHaveSilkTouch(HolderLookup.Provider registries) {
        return this.hasSilkTouch(registries).invert();
    }

    default public LootItemCondition.Builder hasShears(HolderLookup.Provider registries) {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)registries.lookupOrThrow(Registries.ITEM), new ItemLike[]{Items.SHEARS}));
    }

    default public LootItemCondition.Builder hasShearsOrSilkTouch(HolderLookup.Provider registries) {
        return this.hasShears(registries).or(this.hasSilkTouch(registries));
    }

    default public LootItemCondition.Builder doesNotHaveShearsOrSilkTouch(HolderLookup.Provider registries) {
        return this.hasShearsOrSilkTouch(registries).invert();
    }

    default public <T extends FunctionUserBuilder<T>> T applyExplosionDecay(ItemLike item, FunctionUserBuilder<T> functionBuilder) {
        return (T)(!this.isExplosionResistant((ItemLike)item.asItem()) ? functionBuilder.apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()) : functionBuilder.unwrap());
    }

    default public <T extends ConditionUserBuilder<T>> T applyExplosionCondition(ItemLike item, ConditionUserBuilder<T> conditionBuilder) {
        return (T)(!this.isExplosionResistant((ItemLike)item.asItem()) ? conditionBuilder.when(ExplosionCondition.survivesExplosion()) : conditionBuilder.unwrap());
    }

    default public LootTable.Builder createSingleItemTable(ItemLike item) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition(item, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item))));
    }

    default public LootTable.Builder createSilkTouchDispatchTable(HolderLookup.Provider registries, Block block, LootPoolEntryContainer.Builder<?> builder) {
        return BlockLootSubProvider.createSelfDropDispatchTable(block, this.hasSilkTouch(registries), builder);
    }

    default public LootTable.Builder createShearsDispatchTable(HolderLookup.Provider registries, Block block, LootPoolEntryContainer.Builder<?> builder) {
        return BlockLootSubProvider.createSelfDropDispatchTable(block, this.hasShears(registries), builder);
    }

    default public LootTable.Builder createSilkTouchOrShearsDispatchTable(HolderLookup.Provider registries, Block block, LootPoolEntryContainer.Builder<?> builder) {
        return BlockLootSubProvider.createSelfDropDispatchTable(block, this.hasShearsOrSilkTouch(registries), builder);
    }

    default public LootTable.Builder createSingleItemTableWithSilkTouch(HolderLookup.Provider registries, Block block, ItemLike item) {
        return this.createSilkTouchDispatchTable(registries, block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)item)));
    }

    default public LootTable.Builder createSingleItemTable(ItemLike item, NumberProvider count) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay(item, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)count)))));
    }

    default public LootTable.Builder createSingleItemTableWithSilkTouch(HolderLookup.Provider registries, Block block, ItemLike item, NumberProvider count) {
        return this.createSilkTouchDispatchTable(registries, block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)count))));
    }

    default public LootTable.Builder createSilkTouchOnlyTable(HolderLookup.Provider registries, ItemLike item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(this.hasSilkTouch(registries)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
    }

    default public LootTable.Builder createPotFlowerItemTable(ItemLike item) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)Blocks.FLOWER_POT, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.FLOWER_POT)))).withPool((LootPool.Builder)this.applyExplosionCondition(item, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item))));
    }

    default public LootTable.Builder createSlabItemTable(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))))));
    }

    default public <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(Block block, Property<T> property, T value) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder<T>)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, value))))));
    }

    default public LootTable.Builder createNameableBlockEntityTable(Block block) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME)))));
    }

    default public LootTable.Builder createShulkerBoxDrop(Block block) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME).include(DataComponents.CONTAINER).include(DataComponents.LOCK).include(DataComponents.CONTAINER_LOOT)))));
    }

    default public LootTable.Builder createCopperOreDrops(HolderLookup.Provider registries, Block block) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(registries, block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.RAW_COPPER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE)))));
    }

    default public LootTable.Builder createLapisOreDrops(HolderLookup.Provider registries, Block block) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(registries, block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.LAPIS_LAZULI).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)9.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE)))));
    }

    default public LootTable.Builder createRedstoneOreDrops(HolderLookup.Provider registries, Block block) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(registries, block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE)))));
    }

    default public LootTable.Builder createBeeNestDrop(HolderLookup.Provider registries, Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(this.hasSilkTouch(registries)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.BEES)).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy((Property)BeehiveBlock.HONEY_LEVEL))));
    }

    default public LootTable.Builder createBeeHiveDrop(HolderLookup.Provider registries, Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch(registries))).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.BEES)).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy((Property)BeehiveBlock.HONEY_LEVEL)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
    }

    default public LootTable.Builder createCaveVinesDrop(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOW_BERRIES)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CaveVines.BERRIES, true))));
    }

    default public LootTable.Builder createOreDrop(HolderLookup.Provider registries, Block block, Item item) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(registries, block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE)))));
    }

    default public LootTable.Builder createMushroomBlockDrop(HolderLookup.Provider registries, Block block, ItemLike item) {
        return this.createSilkTouchDispatchTable(registries, block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)-6.0f, (float)2.0f))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.lowerBound((int)0)))));
    }

    default public LootTable.Builder createGrassDrops(HolderLookup.Provider registries, Block block) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createShearsDispatchTable(registries, block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (int)2))));
    }

    default public LootTable.Builder createStemDrops(Block block, Item item) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((Iterable)StemBlock.AGE.getPossibleValues(), p_249795_ -> SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)((float)(p_249795_ + 1) / 15.0f))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)StemBlock.AGE, p_249795_.intValue())))))));
    }

    default public LootTable.Builder createAttachedStemDrops(Block block, Item item) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.53333336f))))));
    }

    default public LootTable.Builder createShearsOnlyDrop(HolderLookup.Provider registries, ItemLike item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.hasShears(registries)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
    }

    default public LootTable.Builder createShearsOrSilkTouchOnlyDrop(HolderLookup.Provider registries, ItemLike item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.hasShearsOrSilkTouch(registries)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
    }

    default public LootTable.Builder createMultifaceBlockDrops(Block block, LootItemCondition.Builder builder) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(builder)).apply((Object[])Direction.values(), p_251536_ -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MultifaceBlock.getFaceProperty((Direction)p_251536_), true))))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)-1.0f), (boolean)true)))));
    }

    default public LootTable.Builder createMultifaceBlockDrops(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((Object[])Direction.values(), p_382562_ -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MultifaceBlock.getFaceProperty((Direction)p_382562_), true))))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)-1.0f), (boolean)true)))));
    }

    default public LootTable.Builder createMossyCarpetBlockDrops(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MossyCarpetBlock.BASE, true))))));
    }

    default public LootTable.Builder createLeavesDrops(HolderLookup.Provider registries, Block leavesBlock, Block saplingBlock, float ... chances) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(registries, leavesBlock, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leavesBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)saplingBlock))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])chances))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch(registries)).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leavesBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES))));
    }

    default public LootTable.Builder createOakLeavesDrops(HolderLookup.Provider registries, Block oakLeavesBlock, Block saplingBlock, float ... chances) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(registries, oakLeavesBlock, saplingBlock, chances).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch(registries)).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)oakLeavesBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.APPLE))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    default public LootTable.Builder createMangroveLeavesDrops(HolderLookup.Provider registries, Block block) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(registries, block, ((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)Blocks.MANGROVE_LEAVES, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES)));
    }

    default public LootTable.Builder createCropDrops(HolderLookup.Provider registries, Block cropBlock, Item grownCropItem, Item seedsItem, LootItemCondition.Builder dropGrownCropCondition) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)cropBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)grownCropItem).when(dropGrownCropCondition)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem)))).withPool(LootPool.lootPool().when(dropGrownCropCondition).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)seedsItem).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3)))));
    }

    default public LootTable.Builder createDoublePlantShearsDrop(HolderLookup.Provider registries, Block sheared) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(this.hasShears(registries)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)sheared).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))));
    }

    default public LootTable.Builder createDoublePlantWithSeedDrops(HolderLookup.Provider registries, Block block, Block sheared) {
        HolderLookup.RegistryLookup blocks = registries.lookupOrThrow(Registries.BLOCK);
        AlternativesEntry.Builder lootTable = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)sheared).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).when(this.hasShears(registries))).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS))).when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)lootTable).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of((HolderGetter)blocks, new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)lootTable).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of((HolderGetter)blocks, new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }

    default public LootTable.Builder createCandleDrops(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, LootItem.lootTableItem((ItemLike)block).apply(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), amount -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)amount.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CandleBlock.CANDLES, amount.intValue())))))));
    }

    default public void addNetherVinesDropTable(HolderLookup.Provider registries, Block vines, Block plant) {
        HolderLookup.RegistryLookup enchantments = registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootTable.Builder lootTable = this.createSilkTouchOrShearsDispatchTable(registries, vines, LootItem.lootTableItem((ItemLike)vines).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)enchantments.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f})));
        this.accept(vines, lootTable);
        this.accept(plant, lootTable);
    }

    default public LootTable.Builder createDoorTable(Block doorBlock) {
        return this.createSinglePropConditionTable(doorBlock, (Property)DoorBlock.HALF, (Comparable<T> & StringRepresentable)DoubleBlockHalf.LOWER);
    }

    default public void dropPottedContents(FlowerPotBlock block) {
        this.accept((Block)block, this.createPotFlowerItemTable((ItemLike)block.getPotted()));
    }

    default public void otherWhenSilkTouch(HolderLookup.Provider registries, Block block, Block other) {
        this.accept(block, this.createSilkTouchOnlyTable(registries, (ItemLike)other));
    }

    default public void dropOther(Block block, ItemLike item) {
        this.accept(block, this.createSingleItemTable(item));
    }

    default public void dropWhenSilkTouch(HolderLookup.Provider registries, Block block) {
        this.otherWhenSilkTouch(registries, block, block);
    }

    default public void dropSelf(Block block) {
        this.dropOther(block, (ItemLike)block);
    }

    public static LootTable.Builder createSelfDropDispatchTable(Block block, LootItemCondition.Builder conditionBuilder, LootPoolEntryContainer.Builder<?> alternativeBuilder) {
        return net.minecraft.data.loot.BlockLootSubProvider.createSelfDropDispatchTable((Block)block, (LootItemCondition.Builder)conditionBuilder, alternativeBuilder);
    }

    public static LootTable.Builder createCandleCakeDrops(Block block) {
        return net.minecraft.data.loot.BlockLootSubProvider.createCandleCakeDrops((Block)block);
    }

    public static LootTable.Builder noDrop() {
        return net.minecraft.data.loot.BlockLootSubProvider.noDrop();
    }
}

