/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.loot;

import dev.apexstudios.apexcore.core.data.provider.loot.LootTableProviderImpl;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.provider.loot.BlockLootSubProvider;
import dev.apexstudios.apexcore.lib.data.provider.loot.EntityLootSubProvider;
import dev.apexstudios.apexcore.lib.data.provider.loot.LootTableSubProvider;
import dev.apexstudios.apexcore.lib.registree.Registree;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.commons.lang3.Validate;

public interface LootTableProvider {
    public static final ProviderType<LootTableProvider> PROVIDER_TYPE = LootTableProviderImpl.PROVIDER_TYPE;

    public LootTableProvider forContext(ContextKeySet var1, Consumer<? extends LootTableSubProvider> var2);

    default public LootTableProvider block(Consumer<BlockLootSubProvider> consumer) {
        return this.forContext(LootContextParamSets.BLOCK, consumer);
    }

    default public LootTableProvider entity(Consumer<EntityLootSubProvider> consumer) {
        return this.forContext(LootContextParamSets.BLOCK, consumer);
    }

    public LootTableProvider requiredLootTable(ResourceKey<LootTable> var1);

    public <TRegistry> LootTableProvider knownElements(ResourceKey<? extends Registry<TRegistry>> var1, Supplier<Stream<? extends Holder<TRegistry>>> var2);

    public <TRegistry> LootTableProvider elementFilter(ResourceKey<? extends Registry<TRegistry>> var1, Predicate<Holder<TRegistry>> var2);

    default public <TRegistry> LootTableProvider fromRegistree(Registree registree, ResourceKey<? extends Registry<TRegistry>> registryType) {
        return this.knownElements(registryType, () -> registree.listElements(registryType));
    }

    default public LootTableProvider fromRegistree(Registree registree) {
        registree.listRegistries().forEach(registryType -> this.fromRegistree(registree, (ResourceKey)registryType));
        return this;
    }

    default public <TRegistry> LootTableProvider knownElements(DeferredHolder<TRegistry, ?> ... elements) {
        Objects.checkIndex(0, elements.length);
        ResourceKey registryType = elements[0].getKey().registryKey();
        return this.knownElements(registryType, () -> Stream.of(elements).peek(holder -> Validate.isTrue((registryType == holder.getKey().registryKey() ? 1 : 0) != 0)));
    }
}

