/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.model;

import dev.apexstudios.apexcore.lib.registree.Registree;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;

public interface ModelProvider {
    public ModelProvider knownItems(Supplier<Stream<? extends Holder<Item>>> var1);

    public ModelProvider knownBlocks(Supplier<Stream<? extends Holder<Block>>> var1);

    public ModelProvider itemFilter(Predicate<Holder<Item>> var1);

    public ModelProvider blockFilter(Predicate<Holder<Block>> var1);

    default public ModelProvider noItems() {
        return this.knownItems(Stream::empty);
    }

    default public ModelProvider blockItems() {
        return this.itemFilter(holder -> holder.value() instanceof BlockItem);
    }

    default public ModelProvider noBlocks() {
        return this.knownBlocks(Stream::empty);
    }

    default public ModelProvider fromRegistree(Registree registree) {
        return this.itemsFromRegistree(registree).blocksFromRegistree(registree);
    }

    default public ModelProvider itemsFromRegistree(Registree registree) {
        return this.knownItems(() -> registree.listElements(Registries.ITEM));
    }

    default public ModelProvider blocksFromRegistree(Registree registree) {
        return this.knownBlocks(() -> registree.listElements(Registries.BLOCK));
    }

    default public ModelProvider knownItems(DeferredHolder<Item, ?> ... items) {
        return this.knownItems(() -> Stream.of(items));
    }

    default public ModelProvider knownBlocks(DeferredHolder<Block, ?> ... blocks) {
        return this.knownBlocks(() -> Stream.of(blocks));
    }

    public BlockModelGenerators blockModels();

    public ItemModelGenerators itemModels();
}

