/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.model;

import com.mojang.math.Quadrant;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface ModelUtil {
    public static void horizontalFacingBlock(Block block, Property<Direction> property, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block))).with(ModelUtil.createHorizontalFacingDispatch(property)));
    }

    public static <TBlock extends Block> void horizontalFacingBlock(TBlock block, BlockModelGenerators blockModels) {
        EnumProperty<Direction> facingProperty = ((ComponentHolder)block).getComponentOrThrow(BlockComponentTypes.FACING).getProperty();
        ModelUtil.horizontalFacingBlock(block, facingProperty, blockModels);
    }

    public static PropertyDispatch<VariantMutator> createHorizontalFacingDispatch(Property<Direction> property) {
        return PropertyDispatch.modify(property).select((Comparable)Direction.EAST, (Object)BlockModelGenerators.Y_ROT_90).select((Comparable)Direction.SOUTH, (Object)BlockModelGenerators.Y_ROT_180).select((Comparable)Direction.WEST, (Object)BlockModelGenerators.Y_ROT_270).select((Comparable)Direction.NORTH, (Object)BlockModelGenerators.NOP);
    }

    public static <TBlock extends Block> PropertyDispatch<VariantMutator> createHorizontalFacingDispatch(TBlock block) {
        return ModelUtil.createHorizontalFacingDispatch(((ComponentHolder)block).getComponentOrThrow(BlockComponentTypes.FACING).getProperty());
    }

    public static <TBlock extends Block> PropertyDispatch<MultiVariant> createMultiBlockDispatch(TBlock block, IntFunction<ResourceLocation> modelGetter) {
        return PropertyDispatch.initial((Property)((ComponentHolder)block).getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK).property()).generate(index -> BlockModelGenerators.plainVariant((ResourceLocation)((ResourceLocation)modelGetter.apply((int)index))));
    }

    public static <TBlock extends Block> void multiBlockModel(TBlock block, BlockModelGenerators blockModels, IntFunction<ResourceLocation> modelGetter) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch(block).with(ModelUtil.createMultiBlockDispatch(block, modelGetter)).with(ModelUtil.createHorizontalFacingDispatch(block)));
    }

    public static <TBlock extends Block> void multiBlockModelSuffix(TBlock block, BlockModelGenerators blockModels, IntFunction<String> suffixGetter) {
        ModelUtil.multiBlockModel(block, blockModels, index -> ModelLocationUtils.getModelLocation((Block)block, (String)((String)suffixGetter.apply(index))));
    }

    public static void registerBlockItemModel(Block block, BlockModelGenerators blockModels) {
        Item item = block.asItem();
        blockModels.registerSimpleItemModel(item, ModelLocationUtils.getModelLocation((Item)item));
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> void facingPropertyModel(TBlock block, BlockModelGenerators blockModels, Function<TBlock, Property<TValue>> propertyGetter, Function<TValue, ResourceLocation> modelGetter) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch(block).with(PropertyDispatch.initial(propertyGetter.apply(block)).generate(value -> BlockModelGenerators.plainVariant((ResourceLocation)((ResourceLocation)modelGetter.apply(value))))).with(ModelUtil.createHorizontalFacingDispatch(block)));
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> void facingPropertyModel(TBlock block, BlockModelGenerators blockModels, Property<TValue> property, Function<TValue, ResourceLocation> modelGetter) {
        ModelUtil.facingPropertyModel(block, blockModels, (TBlock $) -> property, modelGetter);
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> void facingPropertyModelSuffix(TBlock block, BlockModelGenerators blockModels, Function<TBlock, Property<TValue>> propertyGetter, Function<TValue, String> suffixGetter) {
        ModelUtil.facingPropertyModel(block, blockModels, propertyGetter, (TValue value) -> ModelLocationUtils.getModelLocation((Block)block, (String)((String)suffixGetter.apply(value))));
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> void facingPropertyModelSuffix(TBlock block, BlockModelGenerators blockModels, Property<TValue> property, Function<TValue, String> suffixGetter) {
        ModelUtil.facingPropertyModelSuffix(block, blockModels, (TBlock $) -> property, suffixGetter);
    }

    public static <TBlock extends Block> void registerMultiBlockItemModel(TBlock block, IntFunction<ResourceLocation> modelGetter, BlockModelGenerators blockModels) {
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.composite((ItemModel.Unbaked[])((ItemModel.Unbaked[])IntStream.range(0, ((ComponentHolder)block).getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK).size()).mapToObj(modelGetter).map(ItemModelUtils::plainModel).toArray(ItemModel.Unbaked[]::new))));
    }

    public static <TBlock extends Block> void registerMultiBlockItemModelSuffix(TBlock block, IntFunction<String> suffixGetter, BlockModelGenerators blockModels) {
        ModelUtil.registerMultiBlockItemModel(block, index -> ModelLocationUtils.getModelLocation((Block)block, (String)((String)suffixGetter.apply(index))), blockModels);
    }

    public static void registerCompositeBlockItemModel(Block block, BlockModelGenerators blockModels, ItemModel.Unbaked ... models) {
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.composite((ItemModel.Unbaked[])models));
    }

    public static void registerCompositeBlockItemModel(Block block, BlockModelGenerators blockModels, ResourceLocation ... models) {
        ModelUtil.registerCompositeBlockItemModel(block, blockModels, (ItemModel.Unbaked[])Stream.of(models).map(ItemModelUtils::plainModel).toArray(ItemModel.Unbaked[]::new));
    }

    public static void registerCompositeBlockItemModel(Block block, BlockModelGenerators blockModels, String ... suffixes) {
        ModelUtil.registerCompositeBlockItemModel(block, blockModels, (ResourceLocation[])Stream.of(suffixes).map(suffix -> ModelLocationUtils.getModelLocation((Block)block, (String)suffix)).toArray(ResourceLocation[]::new));
    }

    public static Quadrant facingToModelRotation(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> Quadrant.R90;
            case Direction.SOUTH -> Quadrant.R180;
            case Direction.WEST -> Quadrant.R270;
            default -> Quadrant.R0;
        };
    }

    public static Rotation facingToRotation(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    public static Quadrant rotation(Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> Quadrant.R90;
            case Rotation.CLOCKWISE_180 -> Quadrant.R180;
            case Rotation.COUNTERCLOCKWISE_90 -> Quadrant.R270;
            default -> Quadrant.R0;
        };
    }

    public static Rotation rotation(Quadrant rotation) {
        return switch (rotation) {
            case Quadrant.R90 -> Rotation.CLOCKWISE_90;
            case Quadrant.R180 -> Rotation.CLOCKWISE_180;
            case Quadrant.R270 -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }
}

