/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.registree;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import dev.apexstudios.apexcore.lib.registree.holder.ApexDeferredHolder;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredAttachment;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredBlock;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredBlockEntity;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredDataComponent;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredEntity;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredEntityDataSerializer;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredFluid;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredFluidType;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredItem;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredMenu;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredParticleType;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredRecipeSerializer;
import dev.apexstudios.apexcore.lib.registree.type.SimpleRecipeSerializer;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;

public class Registree {
    protected final String namespace;
    private final Table<ResourceKey<? extends Registry<?>>, String, Holder.Reference<?>> holders = HashBasedTable.create();
    private final Table<ResourceKey<? extends Registry<?>>, String, Function<ResourceLocation, ?>> factories = HashBasedTable.create();
    private final Table<ResourceKey<? extends Registry<?>>, String, Consumer<?>> listeners = HashBasedTable.create();
    private final Set<ResourceKey<? extends Registry<?>>> registered = Sets.newHashSet();
    private final Set<ResourceKey<? extends Registry<?>>> finalized = Sets.newHashSet();
    private boolean frozen = false;
    @Nullable
    private IEventBus modBus = null;
    private Consumer<IEventBus> delayedEventRegistration = Consumers.nop();

    public Registree(String namespace) {
        this.namespace = namespace;
    }

    public void registerEvents(IEventBus modBus) {
        if (this.modBus != null) {
            return;
        }
        modBus.addListener(RegisterEvent.class, event -> this.register(event.getRegistry()));
        modBus.addListener(EventPriority.LOW, RegisterEvent.class, event -> this.invokeListeners(event.getRegistry()));
        modBus.addListener(EventPriority.LOWEST, RegisterEvent.class, event -> {
            this.frozen = true;
        });
        this.delayedEventRegistration.accept(modBus);
        this.delayedEventRegistration = null;
        this.modBus = modBus;
    }

    private void withEventBus(Consumer<IEventBus> consumer) {
        if (this.modBus == null) {
            this.delayedEventRegistration = this.delayedEventRegistration.andThen(consumer);
        } else {
            consumer.accept(this.modBus);
        }
    }

    private <TRegistry> void register(Registry<TRegistry> registry) {
        ResourceKey registryType = registry.key();
        if (!this.registered.add(registryType)) {
            throw new IllegalStateException("Duplicate registry registration: " + this.namespace + "#" + String.valueOf(registryType.location()));
        }
        this.factories.row((Object)registryType).forEach((registryName, factory) -> {
            ResourceLocation fullName = this.registryName((String)registryName);
            Holder.Reference holder = Registry.registerForHolder((Registry)registry, (ResourceLocation)fullName, factory.apply(fullName));
            this.holders.put((Object)registryType, registryName, (Object)holder);
        });
    }

    private <TRegistry> void invokeListeners(Registry<TRegistry> registry) {
        ResourceKey registryType = registry.key();
        if (!this.registered.contains(registryType)) {
            throw new IllegalStateException("Can not finalize registry before elements are registered: " + this.namespace + "#" + String.valueOf(registryType.location()));
        }
        if (!this.finalized.add(registryType)) {
            throw new IllegalStateException("Duplicate registry finalization: " + this.namespace + "#" + String.valueOf(registryType.location()));
        }
        this.listeners.row((Object)registryType).forEach((registryName, listener) -> this.getOptional((ResourceKey)registryType, (String)registryName).ifPresent((Consumer)listener));
    }

    public final String namespace() {
        return this.namespace;
    }

    public final ResourceLocation registryName(String registryName) {
        return ResourceLocation.fromNamespaceAndPath((String)this.namespace(), (String)registryName);
    }

    public final <TRegistry> ResourceKey<TRegistry> registryKey(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName) {
        return ResourceKey.create(registryType, (ResourceLocation)this.registryName(registryName));
    }

    public final <TRegistry> TagKey<TRegistry> tag(ResourceKey<? extends Registry<TRegistry>> registryType, String tagPath) {
        return TagKey.create(registryType, (ResourceLocation)this.registryName(tagPath));
    }

    public final Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
        return this.holders.rowKeySet().stream();
    }

    public final <TRegistry> Optional<Holder.Reference<TRegistry>> get(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName) {
        return Optional.ofNullable((Holder.Reference)this.holders.get(registryType, (Object)registryName));
    }

    public final <TRegistry> Holder.Reference<TRegistry> getOrThrow(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName) {
        return this.get(registryType, registryName).orElseThrow(() -> new NoSuchElementException("Missing key in '" + String.valueOf(registryType.location()) + "': '" + this.namespace() + ":" + registryName + "'"));
    }

    @Nullable
    public final <TRegistry> TRegistry getValue(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName) {
        return this.get(registryType, registryName).map(Holder::value).orElse(null);
    }

    public final <TRegistry> Optional<TRegistry> getOptional(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName) {
        return this.get(registryType, registryName).map(Holder::value);
    }

    public final <TRegistry> TRegistry getValueOrThrow(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName) {
        return (TRegistry)this.getOrThrow(registryType, registryName).value();
    }

    public final <TRegistry> Stream<Holder.Reference<TRegistry>> listElements(ResourceKey<? extends Registry<TRegistry>> registryType) {
        return this.holders.row(registryType).values().stream().map(holder -> holder);
    }

    public final <TRegistry> Stream<TRegistry> stream(ResourceKey<? extends Registry<TRegistry>> registryType) {
        return this.listElements(registryType).map(Holder::value);
    }

    public final <TRegistry> boolean containsKey(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName) {
        return this.holders.contains(registryType, (Object)registryName) || this.factories.contains(registryType, (Object)registryName);
    }

    public final <TRegistry> void listenFor(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Consumer<? super TRegistry> listener) {
        if (this.finalized.contains(registryType)) {
            this.getOptional(registryType, registryName).ifPresent(listener);
        } else {
            this.listeners.put(registryType, (Object)registryName, listener);
        }
    }

    public final boolean isRegistered(ResourceKey<? extends Registry<?>> registryType) {
        return this.frozen || this.registered.contains(registryType) || this.finalized.contains(registryType);
    }

    public final boolean isRegistered() {
        return this.frozen;
    }

    public final <TRegistry> HolderLookup.RegistryLookup<TRegistry> asLookup(final ResourceKey<? extends Registry<TRegistry>> registryType) {
        return new HolderLookup.RegistryLookup<TRegistry>(){

            public ResourceKey<? extends Registry<? extends TRegistry>> key() {
                return registryType;
            }

            public Lifecycle registryLifecycle() {
                return Lifecycle.stable();
            }

            public Stream<Holder.Reference<TRegistry>> listElements() {
                return Registree.this.listElements(registryType);
            }

            public Stream<HolderSet.Named<TRegistry>> listTags() {
                return Stream.empty();
            }

            public Optional<Holder.Reference<TRegistry>> get(ResourceKey<TRegistry> registryKey) {
                return registryKey.isFor(registryType) && registryKey.location().getNamespace().equals(Registree.this.namespace) ? Registree.this.get(registryType, registryKey.location().getPath()) : Optional.empty();
            }

            public Optional<HolderSet.Named<TRegistry>> get(TagKey<TRegistry> tag) {
                return Optional.empty();
            }

            public boolean canSerializeIn(HolderOwner<TRegistry> owner) {
                return false;
            }
        };
    }

    public final <TRegistry> ResourceKey<TRegistry> register(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Function<ResourceLocation, ? extends TRegistry> factory) {
        if (this.registered.contains(registryType)) {
            throw new IllegalStateException("Registree is already frozen: " + this.namespace + "#" + String.valueOf(registryType.location()));
        }
        if (this.factories.put(registryType, (Object)registryName, factory) != null) {
            throw new IllegalStateException("Duplicate registration: " + registryName + " in registry: " + this.namespace + "#" + String.valueOf(registryType.location()));
        }
        return this.registryKey(registryType, registryName);
    }

    public final <TRegistry> ResourceKey<TRegistry> register(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Supplier<? extends TRegistry> factory) {
        return this.register(registryType, registryName, (ResourceLocation $) -> factory.get());
    }

    public final <TRegistry, TElement extends TRegistry> TElement registerElement(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Function<ResourceLocation, TElement> factory) {
        Object element = factory.apply(this.registryName(registryName));
        this.register(registryType, registryName, () -> element);
        return element;
    }

    public final <TRegistry, TElement extends TRegistry> TElement registerElement(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Supplier<TElement> factory) {
        return (TElement)this.registerElement(registryType, registryName, (ResourceLocation $) -> factory.get());
    }

    public final <TRegistry, THolder extends Holder<TRegistry>> THolder registerForHolder(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Function<ResourceLocation, ? extends TRegistry> elementFactory, Function<ResourceKey<TRegistry>, THolder> holderFactory) {
        ResourceKey<? extends TRegistry> registryKey = this.register(registryType, registryName, elementFactory);
        return (THolder)((Holder)holderFactory.apply(registryKey));
    }

    public final <TRegistry, THolder extends Holder<TRegistry>> THolder registerForHolder(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Supplier<? extends TRegistry> elementFactory, Function<ResourceKey<TRegistry>, THolder> holderFactory) {
        return this.registerForHolder(registryType, registryName, (ResourceLocation $) -> elementFactory.get(), holderFactory);
    }

    public final <TRegistry, TElement extends TRegistry> ApexDeferredHolder<TRegistry, TElement> registerForHolder(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Function<ResourceLocation, ? extends TRegistry> factory) {
        return this.registerForHolder(registryType, registryName, factory, ApexDeferredHolder::new);
    }

    public final <TRegistry, TElement extends TRegistry> ApexDeferredHolder<TRegistry, TElement> registerForHolder(ResourceKey<? extends Registry<TRegistry>> registryType, String registryName, Supplier<? extends TRegistry> factory) {
        return this.registerForHolder(registryType, registryName, (ResourceLocation $) -> factory.get());
    }

    public final <TItem extends Item> DeferredItem<TItem> registerItem(String registryName, Function<Item.Properties, TItem> factory, Supplier<Item.Properties> propertiesFactory) {
        return this.registerForHolder(Registries.ITEM, registryName, (ResourceLocation $) -> (Item)factory.apply(((Item.Properties)propertiesFactory.get()).setId(this.registryKey(Registries.ITEM, registryName))), DeferredItem::new);
    }

    public final <TItem extends Item> DeferredItem<TItem> registerItem(String registryName, Function<Item.Properties, TItem> factory, UnaryOperator<Item.Properties> propertiesMutator) {
        return this.registerItem(registryName, factory, () -> (Item.Properties)propertiesMutator.apply(new Item.Properties()));
    }

    public final <TItem extends Item> DeferredItem<TItem> registerItem(String registryName, Function<Item.Properties, TItem> factory, Item.Properties properties) {
        return this.registerItem(registryName, factory, () -> properties);
    }

    public final <TItem extends Item> DeferredItem<TItem> registerItem(String registryName, Function<Item.Properties, TItem> factory) {
        return this.registerItem(registryName, factory, Item.Properties::new);
    }

    public final DeferredItem<Item> registerSimpleItem(String registryName, Supplier<Item.Properties> propertiesFactory) {
        return this.registerItem(registryName, Item::new, propertiesFactory);
    }

    public final DeferredItem<Item> registerSimpleItem(String registryName, UnaryOperator<Item.Properties> propertiesMutator) {
        return this.registerSimpleItem(registryName, () -> (Item.Properties)propertiesMutator.apply(new Item.Properties()));
    }

    public final DeferredItem<Item> registerSimpleItem(String registryName, Item.Properties properties) {
        return this.registerSimpleItem(registryName, () -> properties);
    }

    public final DeferredItem<Item> registerSimpleItem(String registryName) {
        return this.registerSimpleItem(registryName, Item.Properties::new);
    }

    public final <TItem extends Item, TBlock extends Block> DeferredItem<TItem> registerBlockItem(String registryName, Supplier<TBlock> block, BiFunction<TBlock, Item.Properties, TItem> factory, Supplier<Item.Properties> propertiesFactory) {
        return this.registerItem(registryName, (Item.Properties properties) -> (Item)factory.apply((Block)block.get(), properties.useBlockDescriptionPrefix()), propertiesFactory);
    }

    public final <TItem extends Item, TBlock extends Block> DeferredItem<TItem> registerBlockItem(String registryName, Supplier<TBlock> block, BiFunction<TBlock, Item.Properties, TItem> factory, UnaryOperator<Item.Properties> propertiesMutator) {
        return this.registerBlockItem(registryName, block, factory, () -> (Item.Properties)propertiesMutator.apply(new Item.Properties()));
    }

    public final <TItem extends Item, TBlock extends Block> DeferredItem<TItem> registerBlockItem(String registryName, Supplier<TBlock> block, BiFunction<TBlock, Item.Properties, TItem> factory, Item.Properties properties) {
        return this.registerBlockItem(registryName, block, factory, () -> properties);
    }

    public final <TItem extends Item, TBlock extends Block> DeferredItem<TItem> registerBlockItem(String registryName, Supplier<TBlock> block, BiFunction<TBlock, Item.Properties, TItem> factory) {
        return this.registerBlockItem(registryName, block, factory, Item.Properties::new);
    }

    public final DeferredItem<BlockItem> registerSimpleBlockItem(String registryName, Supplier<? extends Block> block, Supplier<Item.Properties> propertiesFactory) {
        return this.registerBlockItem(registryName, block, BlockItem::new, propertiesFactory);
    }

    public final DeferredItem<BlockItem> registerSimpleBlockItem(String registryName, Supplier<? extends Block> block, UnaryOperator<Item.Properties> propertiesMutator) {
        return this.registerSimpleBlockItem(registryName, block, () -> (Item.Properties)propertiesMutator.apply(new Item.Properties()));
    }

    public final DeferredItem<BlockItem> registerSimpleBlockItem(String registryName, Supplier<? extends Block> block, Item.Properties properties) {
        return this.registerSimpleBlockItem(registryName, block, () -> properties);
    }

    public final DeferredItem<BlockItem> registerSimpleBlockItem(String registryName, Supplier<? extends Block> block) {
        return this.registerSimpleBlockItem(registryName, block, Item.Properties::new);
    }

    public final <TItem extends Item, TBlock extends Block> DeferredItem<TItem> registerBlockItem(DeferredHolder<Block, TBlock> block, BiFunction<TBlock, Item.Properties, TItem> factory, Supplier<Item.Properties> propertiesFactory) {
        return this.registerBlockItem(block.getId().getPath(), (Supplier<TBlock>)block, factory, propertiesFactory);
    }

    public final <TItem extends Item, TBlock extends Block> DeferredItem<TItem> registerBlockItem(DeferredHolder<Block, TBlock> block, BiFunction<TBlock, Item.Properties, TItem> factory, UnaryOperator<Item.Properties> propertiesMutator) {
        return this.registerBlockItem(block, factory, () -> (Item.Properties)propertiesMutator.apply(new Item.Properties()));
    }

    public final <TItem extends Item, TBlock extends Block> DeferredItem<TItem> registerBlockItem(DeferredHolder<Block, TBlock> block, BiFunction<TBlock, Item.Properties, TItem> factory, Item.Properties properties) {
        return this.registerBlockItem(block, factory, () -> properties);
    }

    public final <TItem extends Item, TBlock extends Block> DeferredItem<TItem> registerBlockItem(DeferredHolder<Block, TBlock> block, BiFunction<TBlock, Item.Properties, TItem> factory) {
        return this.registerBlockItem(block, factory, Item.Properties::new);
    }

    public final DeferredItem<BlockItem> registerSimpleBlockItem(DeferredHolder<Block, ? extends Block> block, Supplier<Item.Properties> propertiesFactory) {
        return this.registerSimpleBlockItem(block.getId().getPath(), (Supplier<? extends Block>)block, propertiesFactory);
    }

    public final DeferredItem<BlockItem> registerSimpleBlockItem(DeferredHolder<Block, ? extends Block> block, UnaryOperator<Item.Properties> propertiesMutator) {
        return this.registerSimpleBlockItem(block, () -> (Item.Properties)propertiesMutator.apply(new Item.Properties()));
    }

    public final DeferredItem<BlockItem> registerSimpleBlockItem(DeferredHolder<Block, ? extends Block> block, Item.Properties properties) {
        return this.registerSimpleBlockItem(block, () -> properties);
    }

    public final DeferredItem<BlockItem> registerSimpleBlockItem(DeferredHolder<Block, ? extends Block> block) {
        return this.registerSimpleBlockItem(block, Item.Properties::new);
    }

    public final <TBlock extends Block> DeferredBlock<TBlock> registerBlock(String registryName, Function<BlockBehaviour.Properties, TBlock> factory, Supplier<BlockBehaviour.Properties> propertiesFactory) {
        return this.registerForHolder(Registries.BLOCK, registryName, (ResourceLocation $) -> (Block)factory.apply(((BlockBehaviour.Properties)propertiesFactory.get()).setId(this.registryKey(Registries.BLOCK, registryName))), DeferredBlock::new);
    }

    public final <TBlock extends Block> DeferredBlock<TBlock> registerBlock(String registryName, Function<BlockBehaviour.Properties, TBlock> factory, BlockBehaviour.Properties properties) {
        return this.registerBlock(registryName, factory, () -> properties);
    }

    public final DeferredBlock<Block> registerSimpleBlock(String registryName, Supplier<BlockBehaviour.Properties> propertiesFactory) {
        return this.registerBlock(registryName, Block::new, propertiesFactory);
    }

    public final DeferredBlock<Block> registerSimpleBlock(String registryName, BlockBehaviour.Properties properties) {
        return this.registerSimpleBlock(registryName, () -> properties);
    }

    @SafeVarargs
    public final <TBlockEntity extends BlockEntity> DeferredBlockEntity<TBlockEntity> registerBlockEntity(String registryName, BlockEntityType.BlockEntitySupplier<TBlockEntity> factory, Supplier<? extends Block> ... validBlocks) {
        return this.registerForHolder(Registries.BLOCK_ENTITY_TYPE, registryName, () -> {
            Set blocks = Stream.of(validBlocks).map(Supplier::get).collect(Collectors.toSet());
            return new BlockEntityType(factory, blocks);
        }, DeferredBlockEntity::new);
    }

    public final <TBlockEntity extends BlockEntity> DeferredBlockEntity<TBlockEntity> registerBlockEntity(DeferredHolder<Block, ?> block, BlockEntityType.BlockEntitySupplier<TBlockEntity> factory, Supplier<? extends Block> ... validBlocks) {
        return this.registerBlockEntity(block.getId().getPath(), factory, (Supplier[])ArrayUtils.add((Object[])validBlocks, block));
    }

    public final <TBlockEntity extends BlockEntity> DeferredBlockEntity<TBlockEntity> registerBlockEntity(DeferredHolder<Block, ?> block, BlockEntityType.BlockEntitySupplier<TBlockEntity> factory) {
        return this.registerBlockEntity(block.getId().getPath(), factory, new Supplier[]{block});
    }

    public final <TEntity extends Entity> DeferredEntity<TEntity> registerEntity(String registryName, EntityType.EntityFactory<TEntity> factory, MobCategory category, UnaryOperator<EntityType.Builder<TEntity>> propertiesMutator) {
        return this.registerForHolder(Registries.ENTITY_TYPE, registryName, (ResourceLocation $) -> ((EntityType.Builder)propertiesMutator.apply(EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category))).build(this.registryKey(Registries.ENTITY_TYPE, registryName)), DeferredEntity::new);
    }

    public final <TEntity extends Entity> DeferredEntity<TEntity> registerEntity(String registryName, EntityType.EntityFactory<TEntity> factory, MobCategory category) {
        return this.registerEntity(registryName, factory, category, UnaryOperator.identity());
    }

    public final DeferredItem<SpawnEggItem> registerSpawnEggItem(DeferredHolder<EntityType<?>, EntityType<? extends Mob>> entityType, Supplier<Item.Properties> propertiesFactory) {
        return this.registerItem(entityType.getId().getPath() + "_spawn_egg", (Item.Properties properties) -> new SpawnEggItem((EntityType)entityType.value(), properties), propertiesFactory);
    }

    public final DeferredItem<SpawnEggItem> registerSpawnEggItem(DeferredHolder<EntityType<?>, EntityType<? extends Mob>> entityType, UnaryOperator<Item.Properties> propertiesMutator) {
        return this.registerSpawnEggItem(entityType, () -> (Item.Properties)propertiesMutator.apply(new Item.Properties()));
    }

    public final DeferredItem<SpawnEggItem> registerSpawnEggItem(DeferredHolder<EntityType<?>, EntityType<? extends Mob>> entityType, Item.Properties properties) {
        return this.registerSpawnEggItem(entityType, () -> properties);
    }

    public final DeferredItem<SpawnEggItem> registerSpawnEggItem(DeferredHolder<EntityType<?>, EntityType<? extends Mob>> entityType) {
        return this.registerSpawnEggItem(entityType, Item.Properties::new);
    }

    public final <TData> DeferredDataComponent<TData> registerDataComponent(String registryName, UnaryOperator<DataComponentType.Builder<TData>> builder) {
        return this.registerForHolder(Registries.DATA_COMPONENT_TYPE, registryName, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build(), DeferredDataComponent::new);
    }

    public final <TData> DeferredDataComponent<TData> registerDataComponent(String registryName, Codec<TData> codec, StreamCodec<RegistryFriendlyByteBuf, TData> streamCodec) {
        return this.registerDataComponent(registryName, builder -> builder.persistent(codec).networkSynchronized(streamCodec));
    }

    public final <TData> DeferredDataComponent<TData> registerDataComponent(String registryName, Codec<TData> codec, Codec<TData> networkCodec) {
        return this.registerDataComponent(registryName, builder -> builder.persistent(codec).networkSynchronized(ByteBufCodecs.fromCodecWithRegistries((Codec)networkCodec)));
    }

    public final <TData> DeferredDataComponent<TData> registerDataComponent(String registryName, Codec<TData> codec) {
        return this.registerDataComponent(registryName, builder -> builder.persistent(codec));
    }

    public final ResourceKey<CreativeModeTab> registerCreativeModeTab(String registryName, UnaryOperator<CreativeModeTab.Builder> builder) {
        return this.register(Registries.CREATIVE_MODE_TAB, registryName, () -> ((CreativeModeTab.Builder)builder.apply(CreativeModeTab.builder().title((Component)Component.translatable((String)Registree.creativeModeTabKey(this.registryName(registryName)))))).build());
    }

    public final ResourceKey<CreativeModeTab> registerCreativeModeTab(String registryName, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator itemsGenerator) {
        return this.registerCreativeModeTab(registryName, builder -> builder.icon(icon).displayItems(itemsGenerator));
    }

    public final <TData> DeferredAttachment<TData> registerAttachment(String registryName, UnaryOperator<AttachmentType.Builder<TData>> builder, Function<IAttachmentHolder, TData> defaultValueFactory) {
        return this.registerForHolder(NeoForgeRegistries.Keys.ATTACHMENT_TYPES, registryName, () -> ((AttachmentType.Builder)builder.apply(AttachmentType.builder((Function)defaultValueFactory))).build(), DeferredAttachment::new);
    }

    public final <TData> DeferredAttachment<TData> registerAttachment(String registryName, UnaryOperator<AttachmentType.Builder<TData>> builder, Supplier<TData> defaultValueFactory) {
        return this.registerAttachment(registryName, builder, (IAttachmentHolder holder) -> defaultValueFactory.get());
    }

    public final <TData> DeferredEntityDataSerializer<TData> registerEntityDataSerializer(String registryName, final StreamCodec<? super RegistryFriendlyByteBuf, TData> steamCodec, final UnaryOperator<TData> copier) {
        return this.registerForHolder(NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, registryName, () -> new EntityDataSerializer<TData>(){

            public StreamCodec<? super RegistryFriendlyByteBuf, TData> codec() {
                return steamCodec;
            }

            public TData copy(TData value) {
                return copier.apply(value);
            }
        }, DeferredEntityDataSerializer::new);
    }

    public final <TData> DeferredEntityDataSerializer<TData> registerEntityDataSerializer(String registryName, StreamCodec<? super RegistryFriendlyByteBuf, TData> steamCodec) {
        return this.registerEntityDataSerializer(registryName, steamCodec, UnaryOperator.identity());
    }

    public final <TMenu extends AbstractContainerMenu> DeferredMenu<TMenu> registerMenu(String registryName, MenuType.MenuSupplier<TMenu> factory, FeatureFlagSet requiredFeatures) {
        return this.registerForHolder(Registries.MENU, registryName, () -> new MenuType(factory, requiredFeatures), DeferredMenu::new);
    }

    public final <TMenu extends AbstractContainerMenu> DeferredMenu<TMenu> registerMenu(String registryName, MenuType.MenuSupplier<TMenu> factory, FeatureFlag requiredFeature, FeatureFlag ... requiredFeatures) {
        return this.registerMenu(registryName, factory, FeatureFlagSet.of((FeatureFlag)requiredFeature, (FeatureFlag[])requiredFeatures));
    }

    public final <TMenu extends AbstractContainerMenu> DeferredMenu<TMenu> registerMenu(String registryName, MenuType.MenuSupplier<TMenu> factory, FeatureFlag requiredFeature) {
        return this.registerMenu(registryName, factory, FeatureFlagSet.of((FeatureFlag)requiredFeature));
    }

    public final <TMenu extends AbstractContainerMenu> DeferredMenu<TMenu> registerMenu(String registryName, MenuType.MenuSupplier<TMenu> factory) {
        return this.registerMenu(registryName, factory, FeatureFlags.VANILLA_SET);
    }

    public final <TMenu extends AbstractContainerMenu> DeferredMenu<TMenu> registerMenu(String registryName, IContainerFactory<TMenu> factory, FeatureFlagSet requiredFeatures) {
        return this.registerMenu(registryName, (MenuType.MenuSupplier<TMenu>)factory, requiredFeatures);
    }

    public final <TMenu extends AbstractContainerMenu> DeferredMenu<TMenu> registerMenu(String registryName, IContainerFactory<TMenu> factory, FeatureFlag requiredFeature, FeatureFlag ... requiredFeatures) {
        return this.registerMenu(registryName, factory, FeatureFlagSet.of((FeatureFlag)requiredFeature, (FeatureFlag[])requiredFeatures));
    }

    public final <TMenu extends AbstractContainerMenu> DeferredMenu<TMenu> registerMenu(String registryName, IContainerFactory<TMenu> factory, FeatureFlag requiredFeature) {
        return this.registerMenu(registryName, factory, FeatureFlagSet.of((FeatureFlag)requiredFeature));
    }

    public final <TMenu extends AbstractContainerMenu> DeferredMenu<TMenu> registerMenu(String registryName, IContainerFactory<TMenu> factory) {
        return this.registerMenu(registryName, factory, FeatureFlags.VANILLA_SET);
    }

    public final <TMenu extends AbstractContainerMenu, TScreen extends Screen> DeferredMenu<TMenu> registerMenu(String registryName, MenuType.MenuSupplier<TMenu> factory, Supplier<MenuScreens.ScreenConstructor<TMenu, TScreen>> screenFactory, FeatureFlagSet requiredFeatures) {
        DeferredMenu holder = this.registerMenu(registryName, factory);
        this.withEventBus(modBus -> modBus.addListener(EventPriority.LOW, RegisterMenuScreensEvent.class, arg_0 -> Registree.lambda$registerMenu$44(holder, (Supplier)screenFactory, arg_0)));
        return holder;
    }

    public final <TMenu extends AbstractContainerMenu, TScreen extends Screen> DeferredMenu<TMenu> registerMenu(String registryName, MenuType.MenuSupplier<TMenu> factory, Supplier<MenuScreens.ScreenConstructor<TMenu, TScreen>> screenFactory, FeatureFlag requiredFeature, FeatureFlag ... requiredFeatures) {
        return this.registerMenu(registryName, factory, screenFactory, FeatureFlagSet.of((FeatureFlag)requiredFeature, (FeatureFlag[])requiredFeatures));
    }

    public final <TMenu extends AbstractContainerMenu, TScreen extends Screen> DeferredMenu<TMenu> registerMenu(String registryName, MenuType.MenuSupplier<TMenu> factory, Supplier<MenuScreens.ScreenConstructor<TMenu, TScreen>> screenFactory, FeatureFlag requiredFeature) {
        return this.registerMenu(registryName, factory, screenFactory, FeatureFlagSet.of((FeatureFlag)requiredFeature));
    }

    public final <TMenu extends AbstractContainerMenu, TScreen extends Screen> DeferredMenu<TMenu> registerMenu(String registryName, MenuType.MenuSupplier<TMenu> factory, Supplier<MenuScreens.ScreenConstructor<TMenu, TScreen>> screenFactory) {
        return this.registerMenu(registryName, factory, screenFactory, FeatureFlags.VANILLA_SET);
    }

    public final <TMenu extends AbstractContainerMenu, TScreen extends Screen> DeferredMenu<TMenu> registerMenu(String registryName, IContainerFactory<TMenu> factory, Supplier<MenuScreens.ScreenConstructor<TMenu, TScreen>> screenFactory, FeatureFlagSet requiredFeatures) {
        return this.registerMenu(registryName, (MenuType.MenuSupplier<TMenu>)factory, screenFactory, requiredFeatures);
    }

    public final <TMenu extends AbstractContainerMenu, TScreen extends Screen> DeferredMenu<TMenu> registerMenu(String registryName, IContainerFactory<TMenu> factory, Supplier<MenuScreens.ScreenConstructor<TMenu, TScreen>> screenFactory, FeatureFlag requiredFeature, FeatureFlag ... requiredFeatures) {
        return this.registerMenu(registryName, factory, screenFactory, FeatureFlagSet.of((FeatureFlag)requiredFeature, (FeatureFlag[])requiredFeatures));
    }

    public final <TMenu extends AbstractContainerMenu, TScreen extends Screen> DeferredMenu<TMenu> registerMenu(String registryName, IContainerFactory<TMenu> factory, Supplier<MenuScreens.ScreenConstructor<TMenu, TScreen>> screenFactory, FeatureFlag requiredFeature) {
        return this.registerMenu(registryName, factory, screenFactory, FeatureFlagSet.of((FeatureFlag)requiredFeature));
    }

    public final <TMenu extends AbstractContainerMenu, TScreen extends Screen> DeferredMenu<TMenu> registerMenu(String registryName, IContainerFactory<TMenu> factory, Supplier<MenuScreens.ScreenConstructor<TMenu, TScreen>> screenFactory) {
        return this.registerMenu(registryName, factory, screenFactory, FeatureFlags.VANILLA_SET);
    }

    public final <TFluidType extends FluidType> DeferredFluidType<TFluidType> registerFluidType(String registryName, Function<FluidType.Properties, TFluidType> factory, Supplier<FluidType.Properties> propertiesFactory) {
        return this.registerForHolder(NeoForgeRegistries.Keys.FLUID_TYPES, registryName, (ResourceLocation $) -> (FluidType)factory.apply((FluidType.Properties)propertiesFactory.get()), DeferredFluidType::new);
    }

    public final <TFluidType extends FluidType> DeferredFluidType<TFluidType> registerFluidType(String registryName, Function<FluidType.Properties, TFluidType> factory, UnaryOperator<FluidType.Properties> propertiesMutator) {
        return this.registerFluidType(registryName, factory, () -> (FluidType.Properties)propertiesMutator.apply(FluidType.Properties.create()));
    }

    public final <TFluidType extends FluidType> DeferredFluidType<TFluidType> registerFluidType(String registryName, Function<FluidType.Properties, TFluidType> factory, FluidType.Properties properties) {
        return this.registerFluidType(registryName, factory, () -> properties);
    }

    public final <TFluidType extends FluidType> DeferredFluidType<TFluidType> registerFluidType(String registryName, Function<FluidType.Properties, TFluidType> factory) {
        return this.registerFluidType(registryName, factory, FluidType.Properties::create);
    }

    public final DeferredFluidType<FluidType> registerSimpleFluidType(String registryName, Supplier<FluidType.Properties> propertiesFactory) {
        return this.registerFluidType(registryName, FluidType::new, propertiesFactory);
    }

    public final DeferredFluidType<FluidType> registerSimpleFluidType(String registryName, UnaryOperator<FluidType.Properties> propertiesMutator) {
        return this.registerSimpleFluidType(registryName, () -> (FluidType.Properties)propertiesMutator.apply(FluidType.Properties.create()));
    }

    public final DeferredFluidType<FluidType> registerSimpleFluidType(String registryName, FluidType.Properties properties) {
        return this.registerSimpleFluidType(registryName, () -> properties);
    }

    public final DeferredFluidType<FluidType> registerSimpleFluidType(String registryName) {
        return this.registerSimpleFluidType(registryName, FluidType.Properties::create);
    }

    public final <TFluid extends Fluid> DeferredFluid<TFluid> registerFluid(String registryName, Supplier<TFluid> factory) {
        return this.registerForHolder(Registries.FLUID, registryName, factory, DeferredFluid::new);
    }

    public final <TRecipe extends Recipe<?>> DeferredRecipeSerializer<TRecipe> registerRecipeSerializer(String registryName, MapCodec<TRecipe> codec, StreamCodec<RegistryFriendlyByteBuf, TRecipe> streamCodec) {
        return this.registerForHolder(Registries.RECIPE_SERIALIZER, registryName, () -> new SimpleRecipeSerializer(codec, streamCodec), DeferredRecipeSerializer::new);
    }

    public final <TParticle extends ParticleOptions, TParticleType extends ParticleType<TParticle>> DeferredParticleType<TParticle, TParticleType> registerParticle(String registryName, Supplier<ParticleType<TParticle>> factory) {
        return this.registerForHolder(Registries.PARTICLE_TYPE, registryName, factory, DeferredParticleType::new);
    }

    public final <TParticle extends ParticleOptions> DeferredParticleType<TParticle, ParticleType<TParticle>> registerParticle(String registryName, boolean overrideLimiter, final MapCodec<TParticle> codec, final StreamCodec<? super RegistryFriendlyByteBuf, TParticle> streamCodec) {
        return this.registerParticle(registryName, () -> new ParticleType<TParticle>(this, overrideLimiter){

            public MapCodec<TParticle> codec() {
                return codec;
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, TParticle> streamCodec() {
                return streamCodec;
            }
        });
    }

    public final DeferredParticleType<SimpleParticleType, SimpleParticleType> registerSimpleParticle(String registryName, boolean overrideLimiter) {
        return this.registerParticle(registryName, () -> new SimpleParticleType(overrideLimiter));
    }

    public final <TValue extends GameRules.Value<TValue>> GameRules.Key<TValue> registerGameRule(String registryName, GameRules.Category category, GameRules.Type<TValue> type) {
        return GameRules.register((String)(this.namespace + ":" + registryName), (GameRules.Category)category, type);
    }

    public final GameRules.Key<GameRules.BooleanValue> registerBooleanGameRule(String registryName, GameRules.Category category, boolean defaultValue, BiConsumer<MinecraftServer, GameRules.BooleanValue> changeListener) {
        return this.registerGameRule(registryName, category, GameRules.BooleanValue.create((boolean)defaultValue, changeListener));
    }

    public final GameRules.Key<GameRules.BooleanValue> registerBooleanGameRule(String registryName, GameRules.Category category, boolean defaultValue) {
        return this.registerBooleanGameRule(registryName, category, defaultValue, (server, value) -> {});
    }

    public final GameRules.Key<GameRules.IntegerValue> registerIntegerGameRule(String registryName, GameRules.Category category, int defaultValue, BiConsumer<MinecraftServer, GameRules.IntegerValue> changeListener) {
        return this.registerGameRule(registryName, category, GameRules.IntegerValue.create((int)defaultValue, changeListener));
    }

    public final GameRules.Key<GameRules.IntegerValue> registerIntegerGameRule(String registryName, GameRules.Category category, int defaultValue) {
        return this.registerIntegerGameRule(registryName, category, defaultValue, (server, value) -> {});
    }

    public static String creativeModeTabKey(ResourceKey<CreativeModeTab> registryKey) {
        return Registree.creativeModeTabKey(registryKey.location());
    }

    public static String creativeModeTabKey(ResourceLocation registryName) {
        return registryName.toLanguageKey("itemGroup");
    }

    private static /* synthetic */ void lambda$registerMenu$44(DeferredMenu holder, Supplier screenFactory, RegisterMenuScreensEvent event) {
        event.register((MenuType)holder.value(), (MenuScreens.ScreenConstructor)screenFactory.get());
    }
}

