/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.tooltip;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import dev.apexstudios.apexcore.lib.tooltip.TooltipMutator;
import dev.apexstudios.apexcore.lib.tooltip.TooltipOrder;
import dev.apexstudios.apexcore.lib.tooltip.TooltipPosition;
import java.util.List;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;

public final class RegisterTooltipEvent
extends Event
implements IModBusEvent {
    private final Table<TooltipPosition, TooltipOrder, List<TooltipMutator>> mutators = HashBasedTable.create();

    private RegisterTooltipEvent() {
    }

    public void registerBefore(TooltipPosition position, TooltipMutator mutator) {
        this.register(position, TooltipOrder.BEFORE, mutator);
    }

    public void registerAfter(TooltipPosition position, TooltipMutator mutator) {
        this.register(position, TooltipOrder.AFTER, mutator);
    }

    private void register(TooltipPosition position, TooltipOrder order, TooltipMutator mutator) {
        List list = (List)this.mutators.get((Object)position, (Object)order);
        if (list == null) {
            list = Lists.newLinkedList();
            this.mutators.put((Object)position, (Object)order, (Object)list);
        }
        list.add(mutator);
    }

    @ApiStatus.Internal
    public static Table<TooltipPosition, TooltipOrder, List<TooltipMutator>> post() {
        RegisterTooltipEvent event = new RegisterTooltipEvent();
        ModLoader.postEventWrapContainerInModOrder((Event)event);
        return event.mutators;
    }
}

