/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.util;

import com.mojang.math.OctahedralGroup;
import com.mojang.math.Quadrant;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface ApexShapes {
    public static VoxelShape join(VoxelShape shape, VoxelShape ... shapes) {
        VoxelShape result = shape;
        for (VoxelShape other : shapes) {
            result = Shapes.joinUnoptimized((VoxelShape)result, (VoxelShape)other, (BooleanOp)BooleanOp.OR);
        }
        return result.optimize();
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Vec3 center, Direction facing) {
        return switch (facing) {
            case Direction.EAST -> Shapes.rotate((VoxelShape)shape, (OctahedralGroup)OctahedralGroup.fromXYAngles((Quadrant)Quadrant.R0, (Quadrant)Quadrant.R90), (Vec3)center);
            case Direction.SOUTH -> Shapes.rotate((VoxelShape)shape, (OctahedralGroup)OctahedralGroup.fromXYAngles((Quadrant)Quadrant.R0, (Quadrant)Quadrant.R180), (Vec3)center);
            case Direction.WEST -> Shapes.rotate((VoxelShape)shape, (OctahedralGroup)OctahedralGroup.fromXYAngles((Quadrant)Quadrant.R0, (Quadrant)Quadrant.R270), (Vec3)center);
            default -> shape;
        };
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction facing) {
        return ApexShapes.rotateHorizontal(shape, Shapes.BLOCK_CENTER, facing);
    }
}

