/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public interface Dyeable {
    public static final Property<DyeColor> PROPERTY = EnumProperty.create((String)"color", DyeColor.class);
    public static final DyeColor DEFAULT_COLOR = DyeColor.WHITE;

    default public DyeColor getDyedColor(BlockState blockState) {
        return (DyeColor)blockState.getValueOrElse(PROPERTY, (Comparable)DEFAULT_COLOR);
    }

    default public void setDyedColor(Level level, BlockPos pos, BlockState blockState, DyeColor color) {
        level.setBlockAndUpdate(pos, (BlockState)blockState.trySetValue(PROPERTY, (Comparable)color));
    }

    public static DyeColor getColor(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof Dyeable) {
            Dyeable dyeable = (Dyeable)block;
            return dyeable.getDyedColor(blockState);
        }
        return (DyeColor)blockState.getValueOrElse(PROPERTY, (Comparable)DEFAULT_COLOR);
    }

    public static DyeColor getColor(ItemStack stack) {
        return (DyeColor)stack.getOrDefault(DataComponents.BASE_COLOR, (Object)DEFAULT_COLOR);
    }

    public static void setColor(Level level, BlockPos pos, BlockState blockState, DyeColor color) {
        Block block = blockState.getBlock();
        if (block instanceof Dyeable) {
            Dyeable dyeable = (Dyeable)block;
            dyeable.setDyedColor(level, pos, blockState, color);
        } else {
            level.setBlockAndUpdate(pos, (BlockState)blockState.trySetValue(PROPERTY, (Comparable)color));
        }
    }

    public static void setColor(ItemStack stack, DyeColor color) {
        if (color == DEFAULT_COLOR) {
            stack.remove(DataComponents.BASE_COLOR);
        } else if (color != Dyeable.getColor(stack)) {
            stack.set(DataComponents.BASE_COLOR, (Object)color);
        }
    }

    public static DyeColor getColorForPlacement(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return DEFAULT_COLOR;
        }
        InteractionHand hand = context.getHand();
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack stack = player.getItemInHand(otherHand);
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color == null) {
            color = Dyeable.getColor(context.getItemInHand());
        }
        return color;
    }

    public static InteractionResult useItemOn(Level level, BlockPos pos, BlockState blockState, ItemStack stack) {
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        DyeColor current = Dyeable.getColor(blockState);
        if (color == null || current == color) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!level.isClientSide()) {
            Dyeable.setColor(level, pos, blockState, color);
        }
        return InteractionResult.SUCCESS;
    }

    public static ItemStack getCloneStack(ItemLike item, BlockState blockState, @Nullable Player player, boolean includeData) {
        ItemStack stack = new ItemStack(item);
        if (includeData || player != null && player.isCreative()) {
            DyeColor color = Dyeable.getColor(blockState);
            Dyeable.setColor(stack, color);
        }
        return stack;
    }
}

