/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block.entity;

import dev.apexstudios.apexcore.lib.menu.SimpleMenu;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.StacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import org.jetbrains.annotations.Nullable;

public class InventoryBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final String TAG_NAME = "CustomName";
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SIZE = "Size";
    protected final ItemStacksResourceHandler inventory;
    @Nullable
    protected Component customName;

    protected InventoryBlockEntity(BlockEntityType<? extends InventoryBlockEntity> blockEntityType, BlockPos pos, BlockState blockState, int rows, int cols) {
        this(blockEntityType, pos, blockState, rows * cols);
    }

    protected InventoryBlockEntity(BlockEntityType<? extends InventoryBlockEntity> blockEntityType, BlockPos pos, BlockState blockState, int slots) {
        super(blockEntityType, pos, blockState);
        this.inventory = new ItemStacksResourceHandler(slots){

            public boolean isValid(int index, ItemResource resource) {
                return InventoryBlockEntity.this.canInsert(index, resource);
            }

            protected void onContentsChanged(int index, ItemStack previous) {
                super.onContentsChanged(index, (Object)previous);
                InventoryBlockEntity.this.setChanged();
            }
        };
    }

    @Nullable
    protected MenuType<?> menuType() {
        return null;
    }

    public void setCustomName(@Nullable Component customName) {
        if (this.customName != customName) {
            this.customName = customName;
            this.setChanged();
        }
    }

    public Component getDisplayName() {
        return Objects.requireNonNullElseGet(this.customName, this::getDefaultName);
    }

    protected Component getDefaultName() {
        return this.getBlockState().getBlock().getName();
    }

    public ResourceHandler<ItemResource> getResourceHandler() {
        return this.inventory;
    }

    protected boolean canInsert(int index, ItemResource resource) {
        return true;
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.customName = InventoryBlockEntity.parseCustomNameSafe((ValueInput)input, (String)TAG_NAME);
        this.inventory.deserialize(input);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.storeNullable(TAG_NAME, ComponentSerialization.CODEC, (Object)this.customName);
        this.inventory.serialize(output);
    }

    protected void applyImplicitComponents(DataComponentGetter components) {
        super.applyImplicitComponents(components);
        this.customName = (Component)components.get(DataComponents.CUSTOM_NAME);
        ItemContainerContents contents = (ItemContainerContents)components.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        for (int i = 0; i < contents.getSlots(); ++i) {
            ItemStack stack = contents.getStackInSlot(i);
            this.inventory.set(i, (Resource)this.inventory.getResourceFrom(stack), this.inventory.getAmountFrom(stack));
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.inventory.copyToList()));
    }

    public void removeComponentsFromTag(ValueOutput output) {
        super.removeComponentsFromTag(output);
        output.discard(TAG_NAME);
        output.discard(TAG_ITEMS);
        output.discard(TAG_SIZE);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState blockState) {
        super.preRemoveSideEffects(pos, blockState);
        if (this.level != null) {
            int size = this.inventory.size();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = ItemUtil.getStack((ResourceHandler)this.inventory, (int)i);
                Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        MenuType<?> menuType = this.menuType();
        return menuType == null ? null : new SimpleMenu(menuType, windowId, playerInventory, (StacksResourceHandler<ItemStack, ItemResource>)this.inventory);
    }

    @Nullable
    public static ResourceHandler<ItemResource> inventoryProvider(Level level, BlockPos pos, BlockState blockState, @Nullable BlockEntity blockEntity, @Nullable Direction facing) {
        if (blockEntity == null) {
            blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, pos, blockState);
        }
        if (blockEntity instanceof InventoryBlockEntity) {
            InventoryBlockEntity inventory = (InventoryBlockEntity)blockEntity;
            return inventory.getResourceHandler();
        }
        return null;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event, Supplier<? extends BlockEntityType<? extends InventoryBlockEntity>> blockEntityType) {
        event.registerBlockEntity(Capabilities.Item.BLOCK, blockEntityType.get(), (blockEntity, facing) -> blockEntity.getResourceHandler());
        Set validBlocks = blockEntityType.get().getValidBlocks();
        if (!validBlocks.isEmpty()) {
            event.registerBlock(Capabilities.Item.BLOCK, InventoryBlockEntity::inventoryProvider, (Block[])validBlocks.toArray(Block[]::new));
        }
    }
}

