/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider;

import dev.apexstudios.apexcore.core.data.provider.RecipeProviderImpl;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.jetbrains.annotations.Nullable;

public interface RecipeProvider {
    public static final ProviderType<RecipeProvider> PROVIDER_TYPE = RecipeProviderImpl.PROVIDER_TYPE;

    public RecipeOutput output();

    public HolderGetter<Item> items();

    public void oneToOneConversionRecipe(ItemLike var1, ItemLike var2, @Nullable String var3);

    public void oneToOneConversionRecipe(ItemLike var1, ItemLike var2, @Nullable String var3, int var4);

    public void oreSmelting(List<ItemLike> var1, RecipeCategory var2, ItemLike var3, float var4, int var5, String var6);

    public void oreBlasting(List<ItemLike> var1, RecipeCategory var2, ItemLike var3, float var4, int var5, String var6);

    public <T extends AbstractCookingRecipe> void oreCooking(RecipeSerializer<T> var1, AbstractCookingRecipe.Factory<T> var2, List<ItemLike> var3, RecipeCategory var4, ItemLike var5, float var6, int var7, String var8, String var9);

    public void netheriteSmithing(Item var1, RecipeCategory var2, Item var3);

    public void trimSmithing(Item var1, ResourceKey<TrimPattern> var2, ResourceKey<Recipe<?>> var3);

    public void twoByTwoPacker(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public void threeByThreePacker(RecipeCategory var1, ItemLike var2, ItemLike var3, String var4);

    public void threeByThreePacker(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public void planksFromLog(ItemLike var1, TagKey<Item> var2, int var3);

    public void planksFromLogs(ItemLike var1, TagKey<Item> var2, int var3);

    public void woodFromLogs(ItemLike var1, ItemLike var2);

    public void woodenBoat(ItemLike var1, ItemLike var2);

    public void chestBoat(ItemLike var1, ItemLike var2);

    public RecipeBuilder buttonBuilder(ItemLike var1, Ingredient var2);

    public RecipeBuilder doorBuilder(ItemLike var1, Ingredient var2);

    public RecipeBuilder fenceBuilder(ItemLike var1, Ingredient var2);

    public RecipeBuilder fenceGateBuilder(ItemLike var1, Ingredient var2);

    public void pressurePlate(ItemLike var1, ItemLike var2);

    public RecipeBuilder pressurePlateBuilder(RecipeCategory var1, ItemLike var2, Ingredient var3);

    public void slab(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public RecipeBuilder slabBuilder(RecipeCategory var1, ItemLike var2, Ingredient var3);

    public RecipeBuilder stairBuilder(ItemLike var1, Ingredient var2);

    public RecipeBuilder trapdoorBuilder(ItemLike var1, Ingredient var2);

    public RecipeBuilder signBuilder(ItemLike var1, Ingredient var2);

    public void hangingSign(ItemLike var1, ItemLike var2);

    public void colorItemWithDye(List<Item> var1, List<Item> var2, String var3, RecipeCategory var4);

    public void colorWithDye(List<Item> var1, List<Item> var2, @Nullable Item var3, String var4, RecipeCategory var5);

    public void carpet(ItemLike var1, ItemLike var2);

    public void bedFromPlanksAndWool(ItemLike var1, ItemLike var2);

    public void banner(ItemLike var1, ItemLike var2);

    public void stainedGlassFromGlassAndDye(ItemLike var1, ItemLike var2);

    public void dryGhast(ItemLike var1);

    public void harness(ItemLike var1, ItemLike var2);

    public void stainedGlassPaneFromStainedGlass(ItemLike var1, ItemLike var2);

    public void stainedGlassPaneFromGlassPaneAndDye(ItemLike var1, ItemLike var2);

    public void coloredTerracottaFromTerracottaAndDye(ItemLike var1, ItemLike var2);

    public void concretePowder(ItemLike var1, ItemLike var2);

    public void candle(ItemLike var1, ItemLike var2);

    public void wall(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public RecipeBuilder wallBuilder(RecipeCategory var1, ItemLike var2, Ingredient var3);

    public void polished(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public RecipeBuilder polishedBuilder(RecipeCategory var1, ItemLike var2, Ingredient var3);

    public void cut(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public ShapedRecipeBuilder cutBuilder(RecipeCategory var1, ItemLike var2, Ingredient var3);

    public void chiseled(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public void mosaicBuilder(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public ShapedRecipeBuilder chiseledBuilder(RecipeCategory var1, ItemLike var2, Ingredient var3);

    public void stonecutterResultFromBase(RecipeCategory var1, ItemLike var2, ItemLike var3);

    public void stonecutterResultFromBase(RecipeCategory var1, ItemLike var2, ItemLike var3, int var4);

    public void smeltingResultFromBase(ItemLike var1, ItemLike var2);

    public void nineBlockStorageRecipes(RecipeCategory var1, ItemLike var2, RecipeCategory var3, ItemLike var4);

    public void nineBlockStorageRecipesWithCustomPacking(RecipeCategory var1, ItemLike var2, RecipeCategory var3, ItemLike var4, String var5, String var6);

    public void nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeCategory var1, ItemLike var2, RecipeCategory var3, ItemLike var4, String var5, String var6);

    public void nineBlockStorageRecipes(RecipeCategory var1, ItemLike var2, RecipeCategory var3, ItemLike var4, String var5, @Nullable String var6, String var7, @Nullable String var8);

    public void copySmithingTemplate(ItemLike var1, ItemLike var2);

    public void copySmithingTemplate(ItemLike var1, Ingredient var2);

    public <T extends AbstractCookingRecipe> void cookRecipes(String var1, RecipeSerializer<T> var2, AbstractCookingRecipe.Factory<T> var3, int var4);

    public <T extends AbstractCookingRecipe> void simpleCookingRecipe(String var1, RecipeSerializer<T> var2, AbstractCookingRecipe.Factory<T> var3, int var4, ItemLike var5, ItemLike var6, float var7);

    public void grate(Block var1, Block var2);

    public void copperBulb(Block var1, Block var2);

    public void suspiciousStew(Item var1, SuspiciousEffectHolder var2);

    public void generateRecipes(BlockFamily var1, FeatureFlagSet var2);

    public Block getBaseBlock(BlockFamily var1, BlockFamily.Variant var2);

    public Criterion<InventoryChangeTrigger.TriggerInstance> has(MinMaxBounds.Ints var1, ItemLike var2);

    public Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike var1);

    public Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> var1);

    public Ingredient tag(TagKey<Item> var1);

    public ShapedRecipeBuilder shaped(RecipeCategory var1, ItemLike var2);

    public ShapedRecipeBuilder shaped(RecipeCategory var1, ItemLike var2, int var3);

    public ShapelessRecipeBuilder shapeless(RecipeCategory var1, ItemStack var2);

    public ShapelessRecipeBuilder shapeless(RecipeCategory var1, ItemLike var2);

    public ShapelessRecipeBuilder shapeless(RecipeCategory var1, ItemLike var2, int var3);

    default public void variant(BlockFamily family, BlockFamily.Variant variant) {
        Block block = Objects.requireNonNull(family.get(variant));
        FamilyRecipeProvider provider = RecipeProvider.variantProvider(variant);
        Block baseBlock = this.getBaseBlock(family, variant);
        if (provider != null) {
            RecipeBuilder builder = provider.create(this, (ItemLike)block, (ItemLike)baseBlock);
            family.getRecipeGroupPrefix().ifPresent(group -> builder.group(group + (String)(variant == BlockFamily.Variant.CUT ? "" : "_" + variant.getRecipeGroup())));
            builder.unlockedBy(family.getRecipeUnlockedBy().orElseGet(() -> RecipeProvider.getHasName((ItemLike)baseBlock)), this.has((ItemLike)baseBlock)).save(this.output());
        }
        if (variant == BlockFamily.Variant.CRACKED) {
            this.smeltingResultFromBase((ItemLike)block, (ItemLike)baseBlock);
        }
    }

    public static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block block) {
        return net.minecraft.data.recipes.RecipeProvider.insideOf((Block)block);
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... items) {
        return net.minecraft.data.recipes.RecipeProvider.inventoryTrigger((ItemPredicate.Builder[])items);
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... predicates) {
        return net.minecraft.data.recipes.RecipeProvider.inventoryTrigger((ItemPredicate[])predicates);
    }

    public static String getHasName(ItemLike itemLike) {
        return net.minecraft.data.recipes.RecipeProvider.getHasName((ItemLike)itemLike);
    }

    public static String getHasName(TagKey<Item> tag) {
        return "has_" + tag.location().getPath().replace("/", "_");
    }

    public static String getItemName(ItemLike itemLike) {
        return net.minecraft.data.recipes.RecipeProvider.getItemName((ItemLike)itemLike);
    }

    public static String getSimpleRecipeName(ItemLike item) {
        return net.minecraft.data.recipes.RecipeProvider.getSimpleRecipeName((ItemLike)item);
    }

    public static String getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        return net.minecraft.data.recipes.RecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)ingredient);
    }

    public static String getSmeltingRecipeName(ItemLike item) {
        return net.minecraft.data.recipes.RecipeProvider.getSmeltingRecipeName((ItemLike)item);
    }

    public static String getBlastingRecipeName(ItemLike item) {
        return net.minecraft.data.recipes.RecipeProvider.getBlastingRecipeName((ItemLike)item);
    }

    public static ResourceKey<Recipe<?>> recipeKey(ResourceLocation recipeId) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId);
    }

    public static ResourceKey<Recipe<?>> recipeKeyWithPrefix(ItemLike item, String prefix) {
        return RecipeProvider.recipeKey(RecipeBuilder.getDefaultRecipeId((ItemLike)item).withPrefix(prefix));
    }

    public static ResourceKey<Recipe<?>> recipeKeyWithSuffix(ItemLike item, String suffix) {
        return RecipeProvider.recipeKey(RecipeBuilder.getDefaultRecipeId((ItemLike)item).withSuffix(suffix));
    }

    @Nullable
    public static FamilyRecipeProvider variantProvider(BlockFamily.Variant variant) {
        RecipeProvider.FamilyRecipeProvider vanilla = (RecipeProvider.FamilyRecipeProvider)net.minecraft.data.recipes.RecipeProvider.SHAPE_BUILDERS.get(variant);
        return vanilla == null ? null : (provider, ingredient, result) -> vanilla.create(((RecipeProviderImpl)provider).delegate, ingredient, result);
    }

    @FunctionalInterface
    public static interface FamilyRecipeProvider {
        public RecipeBuilder create(RecipeProvider var1, ItemLike var2, ItemLike var3);
    }
}

