/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data;

import com.google.common.collect.Maps;
import dev.apexstudios.apexcore.core.data.pack.FeaturePackGeneratorImpl;
import dev.apexstudios.apexcore.core.data.pack.ModPackGeneratorImpl;
import dev.apexstudios.apexcore.lib.data.ResourceGenerator;
import dev.apexstudios.apexcore.lib.data.pack.FeaturePackGenerator;
import dev.apexstudios.apexcore.lib.data.pack.ModPackGenerator;
import dev.apexstudios.apexcore.lib.util.StringHelper;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.fml.ModContainer;
import org.jetbrains.annotations.Nullable;

public final class ResourceGeneration
implements ResourceGenerator {
    private final ModPackGeneratorImpl pack = new ModPackGeneratorImpl();
    private final Map<String, FeaturePackGeneratorImpl> featurePacks = Maps.newHashMap();

    @Override
    public ModPackGenerator pack() {
        return this.pack;
    }

    @Override
    public FeaturePackGenerator pack(String packId) {
        return this.featurePacks.computeIfAbsent(packId, FeaturePackGeneratorImpl::new);
    }

    public void generate(ModContainer mod, Function<PackType, ResourceManager> resourceManagerGetter, CompletableFuture<HolderLookup.Provider> vanillaRegistries, DataGenerator generator) {
        Path outputDir = generator.getPackOutput().getOutputFolder();
        String modId = mod.getModId();
        this.pack.defaultDescription(() -> Component.literal((String)mod.getModInfo().getDisplayName()));
        CompletableFuture<HolderLookup.Provider> moddedRegistries = this.pack.generate(modId, resourceManagerGetter, vanillaRegistries, outputDir, this.addProvider(null, generator));
        this.featurePacks.forEach((packId, pack) -> {
            pack.defaultDescription(() -> Component.literal((String)StringHelper.toEnglishName(packId)));
            pack.generate(modId, resourceManagerGetter, moddedRegistries, outputDir, this.addProvider((String)packId, generator));
        });
    }

    private Consumer<DataProvider> addProvider(@Nullable String providerPrefix, DataGenerator generator) {
        return original -> generator.addProvider(true, new DataProvider(){
            final /* synthetic */ DataProvider val$original;
            final /* synthetic */ String val$providerPrefix;
            {
                this.val$original = dataProvider;
                this.val$providerPrefix = string;
            }

            public CompletableFuture<?> run(CachedOutput cache) {
                return this.val$original.run(cache);
            }

            public String getName() {
                return this.val$providerPrefix == null ? this.val$original.getName() : this.val$providerPrefix + "/" + this.val$original.getName();
            }
        });
    }
}

