/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data.provider;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.core.data.provider.BaseProvider;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.provider.LanguageProvider;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;

public final class LanguageProviderImpl
implements BaseProvider,
LanguageProvider {
    public static final ProviderType<LanguageProvider> PROVIDER_TYPE = ProviderType.register(ApexCore.identifier("language"), LanguageProviderImpl::new);
    private final Map<String, String> translations = Maps.newTreeMap();

    private LanguageProviderImpl() {
    }

    @Override
    public CompletableFuture<?> generate(CachedOutput cache, ProviderOutputContext context) {
        JsonObject json = new JsonObject();
        this.translations.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        if (json.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Path path = context.outputPath(PackOutput.Target.RESOURCE_PACK, "lang", "en_us.json");
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
    }

    @Override
    public LanguageProvider add(String key, String value) {
        if (this.translations.putIfAbsent(key, value) != null) {
            throw new IllegalStateException("Duplicate translation: '" + key + "' -> '" + value + "'");
        }
        return this;
    }
}

