/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.multiblock;

import com.google.errorprone.annotations.ForOverride;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlockProperty;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public interface MultiBlock {
    public MultiBlockProperty getMultiBlockProperty();

    @ApiStatus.NonExtendable
    default public List<Vector3ic> getMultiBlockLocationPositions() {
        return this.getMultiBlockProperty().getPositions();
    }

    @ApiStatus.NonExtendable
    default public int getMultiBlockSize() {
        return this.getMultiBlockLocationPositions().size();
    }

    @ForOverride
    default public Rotation getMultiBlockRotation(BlockState blockState) {
        if (blockState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
            return MultiBlock.rotation(facing);
        }
        return Rotation.NONE;
    }

    @Nullable
    public static MultiBlock asMultiBlock(BlockState blockState) {
        MultiBlock multiBlock;
        Block block = blockState.getBlock();
        return block instanceof MultiBlock ? (multiBlock = (MultiBlock)block) : null;
    }

    public static MultiBlock asMultiBlockOrThrow(BlockState blockState) {
        return Objects.requireNonNull(MultiBlock.asMultiBlock(blockState));
    }

    public static void asMultiBlock(BlockState blockState, Consumer<MultiBlock> consumer) {
        MultiBlock multiBlock = MultiBlock.asMultiBlock(blockState);
        if (multiBlock != null) {
            consumer.accept(multiBlock);
        }
    }

    public static boolean testMultiBlock(BlockState blockState, Predicate<MultiBlock> predicate) {
        MultiBlock multiBlock = MultiBlock.asMultiBlock(blockState);
        return multiBlock != null && predicate.test(multiBlock);
    }

    public static boolean isMultiBlock(BlockState blockState) {
        return MultiBlock.asMultiBlock(blockState) != null;
    }

    public static int getIndex(BlockState blockState) {
        MultiBlock multiBlock = MultiBlock.asMultiBlock(blockState);
        return multiBlock == null ? 0 : (Integer)blockState.getValue((Property)multiBlock.getMultiBlockProperty());
    }

    public static BlockState setIndex(BlockState blockState, int index) {
        MultiBlock multiBlock = MultiBlock.asMultiBlock(blockState);
        return multiBlock == null ? blockState : (BlockState)blockState.setValue((Property)multiBlock.getMultiBlockProperty(), (Comparable)Integer.valueOf(index));
    }

    public static Vector3ic getLocalPos(BlockState blockState) {
        MultiBlock multiBlock = MultiBlock.asMultiBlock(blockState);
        if (multiBlock == null) {
            return new Vector3i();
        }
        int index = MultiBlock.getIndex(blockState);
        Vector3ic localPos = multiBlock.getMultiBlockLocationPositions().get(index);
        Rotation rotation = multiBlock.getMultiBlockRotation(blockState);
        return MultiBlock.rotate(localPos, rotation);
    }

    public static BlockPos getOrigin(BlockPos worldPos, BlockState blockState) {
        if (MultiBlock.isMultiBlock(blockState)) {
            Vector3ic localPos = MultiBlock.getLocalPos(blockState);
            return worldPos.offset(-localPos.x(), -localPos.y(), -localPos.z());
        }
        return worldPos;
    }

    public static BlockPos getWorldPos(BlockPos origin, BlockState blockState) {
        if (MultiBlock.isMultiBlock(blockState)) {
            Vector3ic localPos = MultiBlock.getLocalPos(blockState);
            return origin.offset(localPos.x(), localPos.y(), localPos.z());
        }
        return origin;
    }

    public static void forEachPos(BlockPos worldPos, BlockState blockState, BiConsumer<BlockPos, BlockState> consumer) {
        MultiBlock.asMultiBlock(blockState, multiBlock -> {
            BlockPos origin = MultiBlock.getOrigin(worldPos, blockState);
            for (int i = 0; i < multiBlock.getMultiBlockSize(); ++i) {
                BlockState otherBlockState = MultiBlock.setIndex(blockState, i);
                BlockPos otherPos = MultiBlock.getWorldPos(origin, otherBlockState);
                consumer.accept(otherPos, otherBlockState);
            }
        });
    }

    public static boolean testEachPos(BlockPos worldPos, BlockState blockState, BiPredicate<BlockPos, BlockState> predicate) {
        return MultiBlock.testMultiBlock(blockState, multiBlock -> {
            BlockPos origin = MultiBlock.getOrigin(worldPos, blockState);
            for (int i = 0; i < multiBlock.getMultiBlockSize(); ++i) {
                BlockState otherBlockState = MultiBlock.setIndex(blockState, i);
                BlockPos otherPos = MultiBlock.getWorldPos(origin, otherBlockState);
                if (predicate.test(otherPos, otherBlockState)) continue;
                return false;
            }
            return true;
        });
    }

    public static boolean canPlace(BlockPlaceContext context, BlockState placementBlockState) {
        return MultiBlock.testMultiBlock(placementBlockState, multiBlock -> {
            Level level = context.getLevel();
            BlockPos worldPos = context.getClickedPos();
            WorldBorder worldBorder = level.getWorldBorder();
            CollisionContext collisionContext = CollisionContext.placementContext((Player)context.getPlayer());
            return MultiBlock.testEachPos(worldPos, placementBlockState, (otherPos, otherBlockState) -> {
                if (!level.getBlockState(otherPos).canBeReplaced(context)) {
                    return false;
                }
                if (!level.isInWorldBounds(otherPos)) {
                    return false;
                }
                if (!worldBorder.isWithinBounds(otherPos)) {
                    return false;
                }
                return level.isUnobstructed(otherBlockState, otherPos, collisionContext);
            });
        });
    }

    public static void setBlockStates(Level level, BlockPos worldPos, BlockState blockState, UnaryOperator<BlockState> blockStateMutator) {
        if (!MultiBlock.isMultiBlock(blockState)) {
            return;
        }
        int index = MultiBlock.getIndex(blockState);
        MultiBlock.forEachPos(worldPos, blockState, (otherPos, otherBlockState) -> {
            if (MultiBlock.getIndex(otherBlockState) != index) {
                level.setBlock(otherPos, (BlockState)blockStateMutator.apply((BlockState)otherBlockState), 3);
            }
        });
    }

    public static void setBlockStates(Level level, BlockPos worldPos, BlockState blockState) {
        MultiBlock.setBlockStates(level, worldPos, blockState, UnaryOperator.identity());
    }

    public static void destroyBlocks(LevelAccessor level, BlockPos worldPos, BlockState blockState) {
        if (!MultiBlock.isMultiBlock(blockState)) {
            return;
        }
        int index = MultiBlock.getIndex(blockState);
        MultiBlock.forEachPos(worldPos, blockState, (otherPos, otherBlockState) -> {
            if (MultiBlock.getIndex(otherBlockState) != index && level.getBlockState(otherPos).is(otherBlockState.getBlock())) {
                level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 3);
            }
        });
    }

    public static void spawnDestroyParticles(LevelAccessor level, BlockPos worldPos, BlockState blockState, @Nullable Entity destroyer) {
        if (!MultiBlock.isMultiBlock(blockState)) {
            return;
        }
        int index = MultiBlock.getIndex(blockState);
        MultiBlock.forEachPos(worldPos, blockState, (otherPos, otherBlockState) -> {
            if (MultiBlock.getIndex(otherBlockState) != index && level.getBlockState(otherPos).is(otherBlockState.getBlock())) {
                level.levelEvent(destroyer, 2001, otherPos, Block.getId((BlockState)otherBlockState));
            }
        });
    }

    public static Rotation rotation(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.EAST -> Rotation.CLOCKWISE_180;
            default -> Rotation.NONE;
        };
    }

    public static Vector3ic rotate(Vector3ic position, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new Vector3i(-position.z(), position.y(), position.x());
            case Rotation.CLOCKWISE_180 -> new Vector3i(-position.x(), position.y(), -position.z());
            case Rotation.COUNTERCLOCKWISE_90 -> new Vector3i(position.z(), position.y(), -position.x());
            default -> position;
        };
    }

    @Nullable
    public static BlockEntity getBlockEntity(BlockGetter level, BlockPos worldPos, BlockState blockState) {
        BlockPos origin = MultiBlock.getOrigin(worldPos, blockState);
        return level.getBlockEntity(origin);
    }

    @Nullable
    public static BlockEntity getBlockEntity(BlockGetter level, BlockPos worldPos) {
        return MultiBlock.getBlockEntity(level, worldPos, level.getBlockState(worldPos));
    }

    public static VoxelShape fixShape(VoxelShape shape, BlockState blockState, BlockPos worldPos) {
        if (!MultiBlock.isMultiBlock(blockState)) {
            return shape;
        }
        BlockPos origin = MultiBlock.getOrigin(worldPos, blockState);
        BlockPos offset = worldPos.subtract((Vec3i)origin);
        return shape.move((Vec3i)offset.multiply(-1));
    }
}

