/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.util;

import dev.apexstudios.apexcore.lib.util.BlockSetTypeBuilder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.WoodType;

public final class WoodTypeBuilder {
    private final BlockSetTypeBuilder blockSetType = BlockSetTypeBuilder.builder();
    private Supplier<SoundType> soundType = () -> SoundType.WOOD;
    private Supplier<SoundType> hangingSignSoundType = () -> SoundType.HANGING_SIGN;
    private Supplier<SoundEvent> fenceGateClose = () -> SoundEvents.FENCE_GATE_CLOSE;
    private Supplier<SoundEvent> fenceGateOpen = () -> SoundEvents.FENCE_GATE_OPEN;

    private WoodTypeBuilder() {
    }

    public WoodTypeBuilder soundType(Supplier<SoundType> soundType) {
        this.soundType = soundType;
        return this;
    }

    public WoodTypeBuilder hangingSignSoundType(Supplier<SoundType> hangingSignSoundType) {
        this.hangingSignSoundType = hangingSignSoundType;
        return this;
    }

    public WoodTypeBuilder fenceGateClose(Supplier<SoundEvent> fenceGateClose) {
        this.fenceGateClose = fenceGateClose;
        return this;
    }

    public WoodTypeBuilder fenceGateOpen(Supplier<SoundEvent> fenceGateOpen) {
        this.fenceGateOpen = fenceGateOpen;
        return this;
    }

    public WoodTypeBuilder blockSetType(Consumer<BlockSetTypeBuilder> blockSetTypeBuilder) {
        blockSetTypeBuilder.accept(this.blockSetType);
        return this;
    }

    public WoodTypeBuilder copy(WoodType woodType) {
        return this.soundType(() -> ((WoodType)woodType).soundType()).hangingSignSoundType(() -> ((WoodType)woodType).hangingSignSoundType()).fenceGateClose(() -> ((WoodType)woodType).fenceGateClose()).fenceGateOpen(() -> ((WoodType)woodType).fenceGateOpen()).blockSetType(builder -> builder.copy(woodType.setType()));
    }

    public WoodType build(String woodTypeName, String blockSetTypeName) {
        return new WoodType(woodTypeName, this.blockSetType.build(blockSetTypeName), this.soundType.get(), this.hangingSignSoundType.get(), this.fenceGateClose.get(), this.fenceGateOpen.get());
    }

    public WoodType build(String name) {
        return this.build(name, name);
    }

    public static WoodTypeBuilder builder() {
        return new WoodTypeBuilder();
    }
}

