/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwmoddinglegacy;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.data.McwBlockIdBase;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.door.Doors;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.furnitures.AddFurnituresStorage;
import fr.samlegamer.addonslib.furnitures.Furnitures;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.mapping.MappingMissing;
import fr.samlegamer.addonslib.path.Paths;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.stairs.Stairs;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.trapdoor.Trapdoors;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.addonslib.windows.Windows;
import fr.samlegamer.mcwmoddinglegacy.Recipes;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="mcwmoddinglegacy")
public class McwModdingLegacy
extends McwMod {
    public static final String MODID = "mcwmoddinglegacy";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DeferredRegister.Blocks block = Registration.blocks((String)"mcwmoddinglegacy");
    private static final DeferredRegister.Items item = DeferredRegister.createItems((String)"mcwmoddinglegacy");
    public static final DeferredRegister<CreativeModeTab> ct = Registration.creativeModeTab((String)"mcwmoddinglegacy");
    public static final List<String> wood_blue_skies = List.of("bsky_bluebright", "bsky_comet", "bsky_dusk", "bsky_frostbright", "bsky_lunar", "bsky_maple", "bsky_starlit");
    public static final List<String> wood_premium_wood = List.of("pwood_magic", "pwood_maple", "pwood_purple_heart", "pwood_silverbell", "pwood_tiger", "pwood_willow");
    public static final List<String> wood_crystallized = List.of("bsky_crystallized");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MCWMODDINGLEGACY_TAB = ct.register("tab", () -> CreativeModeTab.builder().icon(McwModdingLegacy::getIcon).title((Component)Component.translatable((String)"mcwmoddinglegacy.tab")).build());
    private static final MappingMissing.Bridges bridges_Bsky = new MappingMissing.Bridges("mcwbridgesmoddinglegacy", "mcwmoddinglegacy", wood_blue_skies);
    private static final MappingMissing.Bridges bridges_pWood = new MappingMissing.Bridges("mcwbridgesmoddinglegacy", "mcwmoddinglegacy", wood_premium_wood);
    private static final MappingMissing.Bridges bridges_glass = new MappingMissing.Bridges("mcwbridgesmoddinglegacy", "mcwmoddinglegacy", wood_crystallized);

    public McwModdingLegacy(IEventBus bus) {
        super(bus);
        LOGGER.info("Macaw's Modding Legacy Mod Loading...");
        Registration.init((IEventBus)bus, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, ct);
        BlockBehaviour.Properties wood = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
        BlockBehaviour.Properties leaves = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES);
        BlockBehaviour.Properties glass = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).sound(SoundType.GLASS);
        Bridges.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Roofs.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Fences.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Fences.setRegistrationHedgesModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)leaves);
        Furnitures.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Stairs.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Paths.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Doors.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR), (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR));
        Trapdoors.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR));
        Windows.setRegistrationWoodModLoaded(wood_blue_skies, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Bridges.setRegistrationWoodModLoaded(wood_crystallized, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)glass);
        Roofs.setRegistrationWoodModLoaded(wood_crystallized, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)glass);
        Fences.setRegistrationHedgesModLoaded(wood_crystallized, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)leaves);
        Bridges.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Roofs.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Fences.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Fences.setRegistrationHedgesModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)leaves);
        Furnitures.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Stairs.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Paths.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        Doors.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR), (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR));
        Trapdoors.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR));
        Windows.setRegistrationWoodModLoaded(wood_premium_wood, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)wood);
        bridges_Bsky.missingnoWoodBlock(block);
        bridges_pWood.missingnoWoodBlock(block);
        bridges_glass.missingnoWoodBlock(block);
        bridges_Bsky.missingnoWoodItem(item);
        bridges_pWood.missingnoWoodItem(item);
        bridges_glass.missingnoWoodItem(item);
        bus.addListener(this::clientSetup);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::tabSetup);
        bus.addListener(this::addFurnitures);
        LOGGER.info("Macaw's Modding Legacy Mod Finish !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, wood_blue_skies, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, wood_blue_skies, (RenderType)RenderType.TRANSLUCENT, (ModType[])new ModType[]{ModType.ROOFS, ModType.BRIDGES});
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, wood_premium_wood, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, wood_blue_skies);
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, wood_crystallized, (RenderType)RenderType.TRANSLUCENT);
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, wood_blue_skies);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, wood_blue_skies);
            McwLootTables.addBlockAllWood((String)MODID, wood_premium_wood);
            McwLootTables.addBlock((String)MODID, wood_crystallized, (McwBlockIdBase)McwBlocksIdBase.BRIDGES_WOOD_BLOCKS);
            McwLootTables.addBlock((String)MODID, wood_crystallized, (McwBlockIdBase)McwBlocksIdBase.ROOFS_WOOD_BLOCKS);
            McwLootTables.addBlockHedges((String)MODID, wood_blue_skies);
            McwLootTables.addBlockHedges((String)MODID, wood_crystallized);
            McwLootTables.addBlockHedges((String)MODID, wood_premium_wood);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture registries = gatherDataEvent.getLookupProvider();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        McwBlockTags mcwBlockTags = new McwBlockTags(this, output, registries, MODID, existingFileHelper){

            protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull HolderLookup.Provider provider) {
                this.addAllMcwTags(McwModdingLegacy.MODID, wood_blue_skies, wood_blue_skies);
                this.addAllMcwTags(McwModdingLegacy.MODID, wood_premium_wood, wood_premium_wood);
                this.mcwRoofsTags(McwModdingLegacy.MODID, wood_crystallized, List.of());
                this.mcwBridgesTagsWood(McwModdingLegacy.MODID, wood_crystallized);
                this.mcwFencesTags(McwModdingLegacy.MODID, List.of(), wood_crystallized, List.of());
            }
        };
        generator.addProvider(true, (DataProvider)new Recipes.Runner(output, registries));
        generator.addProvider(true, (DataProvider)mcwBlockTags);
        generator.addProvider(true, (DataProvider)new McwItemTags(this, output, registries, mcwBlockTags.contentsGetter(), MODID, existingFileHelper){

            protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull HolderLookup.Provider provider) {
                this.addAllMcwTags(McwModdingLegacy.MODID, wood_blue_skies, wood_blue_skies);
                this.addAllMcwTags(McwModdingLegacy.MODID, wood_premium_wood, wood_premium_wood);
                this.mcwFencesTags(McwModdingLegacy.MODID, List.of(), wood_crystallized, List.of());
            }
        });
    }

    public void tabSetup(BuildCreativeModeTabContentsEvent event) {
        ModList modList = ModList.get();
        if (modList.isLoaded("blue_skies")) {
            APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood_blue_skies, (CreativeModeTab)((CreativeModeTab)MCWMODDINGLEGACY_TAB.get()), (ModType[])Registration.getAllModTypeWood());
            APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood_blue_skies, (CreativeModeTab)((CreativeModeTab)MCWMODDINGLEGACY_TAB.get()));
            APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood_crystallized, (CreativeModeTab)((CreativeModeTab)MCWMODDINGLEGACY_TAB.get()), (ModType[])new ModType[]{ModType.ROOFS, ModType.BRIDGES});
            APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood_crystallized, (CreativeModeTab)((CreativeModeTab)MCWMODDINGLEGACY_TAB.get()));
        }
        if (modList.isLoaded("premium_wood")) {
            APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood_premium_wood, (CreativeModeTab)((CreativeModeTab)MCWMODDINGLEGACY_TAB.get()), (ModType[])Registration.getAllModTypeWood());
            APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood_premium_wood, (CreativeModeTab)((CreativeModeTab)MCWMODDINGLEGACY_TAB.get()));
        }
    }

    private void addFurnitures(BlockEntityTypeAddBlocksEvent event) {
        AddFurnituresStorage.addCompatibleBlocksToFurnitureStorage((BlockEntityTypeAddBlocksEvent)event, (String)MODID, wood_blue_skies);
        AddFurnituresStorage.addCompatibleBlocksToFurnitureStorage((BlockEntityTypeAddBlocksEvent)event, (String)MODID, wood_premium_wood);
    }

    private static ItemStack getIcon() {
        NewIconRandom.NewProperties prop = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_roof")), Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_picket_fence")), Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_wardrobe")), Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_log_bridge_middle")), Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_blinds")), Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_mystic_door")), Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_barrel_trapdoor")), Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_planks_path")), Finder.findBlock((String)MODID, (String)(McwModdingLegacy.randomNaming() + "_skyline_stairs")));
        prop.addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.FENCES).addType(NewIconRandom.BlockType.FURNITURES).addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.STAIRS).addType(NewIconRandom.BlockType.WINDOWS).addType(NewIconRandom.BlockType.DOORS).addType(NewIconRandom.BlockType.TRAPDOORS).addType(NewIconRandom.BlockType.PATHS);
        return new ItemStack((ItemLike)prop.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.FENCES, NewIconRandom.BlockType.FURNITURES, NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.STAIRS, NewIconRandom.BlockType.WINDOWS, NewIconRandom.BlockType.DOORS, NewIconRandom.BlockType.TRAPDOORS, NewIconRandom.BlockType.PATHS}));
    }

    private static String randomNaming() {
        Random rand = new Random();
        if (ModList.get().isLoaded("blue_skies") && ModList.get().isLoaded("premium_wood")) {
            int i = rand.nextInt(0, 1);
            switch (i) {
                case 0: {
                    return "pwood_purple_heart";
                }
                case 1: {
                    return "bsky_bluebright";
                }
            }
        } else {
            if (ModList.get().isLoaded("blue_skies")) {
                return "bsky_bluebright";
            }
            if (ModList.get().isLoaded("premium_wood")) {
                return "pwood_purple_heart";
            }
        }
        return "bsky_bluebright";
    }
}

