/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reinfshulker.gametest.testcase;

import atonkish.reinfchest.item.ModItems;
import atonkish.reinfcore.gametest.TestFunction;
import atonkish.reinfcore.util.ReinforcingMaterials;
import atonkish.reinfshulker.ReinforcedShulkerBoxesMod;
import atonkish.reinfshulker.gametest.util.MockServerPlayerHelper;
import atonkish.reinfshulker.gametest.util.TestIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_167;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8779;

public class AdvancementTests {
    private static final Map<class_1767, class_1792> SHULKER_BOX_MAP = new LinkedHashMap<class_1767, class_1792>(){
        {
            this.put(null, class_1802.field_8545);
            this.put(class_1767.field_7952, class_1802.field_8722);
            this.put(class_1767.field_7946, class_1802.field_8380);
            this.put(class_1767.field_7958, class_1802.field_8050);
            this.put(class_1767.field_7951, class_1802.field_8829);
            this.put(class_1767.field_7947, class_1802.field_8271);
            this.put(class_1767.field_7961, class_1802.field_8548);
            this.put(class_1767.field_7954, class_1802.field_8520);
            this.put(class_1767.field_7944, class_1802.field_8627);
            this.put(class_1767.field_7967, class_1802.field_8451);
            this.put(class_1767.field_7955, class_1802.field_8213);
            this.put(class_1767.field_7945, class_1802.field_8816);
            this.put(class_1767.field_7966, class_1802.field_8350);
            this.put(class_1767.field_7957, class_1802.field_8584);
            this.put(class_1767.field_7942, class_1802.field_8461);
            this.put(class_1767.field_7964, class_1802.field_8676);
            this.put(class_1767.field_7963, class_1802.field_8268);
        }
    };
    private static final String TEST_ENVIRONMENT_DEFAULT = String.format("%s:advancement/default", "reinfshulker");
    private static final String TEST_STRUCTURE_EMPTY = "fabric-gametest-api-v1:empty";
    public static final Collection<TestFunction> TEST_FUNCTIONS = new ArrayList<TestFunction>(){
        {
            for (class_1792 item : SHULKER_BOX_MAP.values()) {
                this.add(AdvancementTests.createTest(String.format("Obtain Copper Shulker Box recipe advancement by having %s", item.method_63680().getString()), item, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/copper_shulker_box")));
            }
            this.add(AdvancementTests.createTest("Obtain Copper Shulker Box recipe advancement by having Copper Ingot", class_1802.field_27022, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/copper_shulker_box")));
            this.add(AdvancementTests.createTest("Obtain Copper Shulker Box recipe advancement by having Copper Chest", (class_1792)ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("copper")), class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/copper_shulker_box_from_copper_chest")));
            for (class_1792 item : atonkish.reinfshulker.item.ModItems.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("copper")).values()) {
                this.add(AdvancementTests.createTest(String.format("Obtain Iron Shulker Box recipe advancement by having %s", item.method_63680().getString()), item, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/iron_shulker_box")));
            }
            this.add(AdvancementTests.createTest("Obtain Iron Shulker Box recipe advancement by having Iron Ingot", class_1802.field_8620, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/iron_shulker_box")));
            this.add(AdvancementTests.createTest("Obtain Iron Shulker Box recipe advancement by having Iron Chest", (class_1792)ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("iron")), class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/iron_shulker_box_from_iron_chest")));
            for (class_1792 item : atonkish.reinfshulker.item.ModItems.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("iron")).values()) {
                this.add(AdvancementTests.createTest(String.format("Obtain Gold Shulker Box recipe advancement by having %s", item.method_63680().getString()), item, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/gold_shulker_box")));
            }
            this.add(AdvancementTests.createTest("Obtain Gold Shulker Box recipe advancement by having Gold Ingot", class_1802.field_8695, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/gold_shulker_box")));
            this.add(AdvancementTests.createTest("Obtain Gold Shulker Box recipe advancement by having Gold Chest", (class_1792)ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("gold")), class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/gold_shulker_box_from_gold_chest")));
            for (class_1792 item : atonkish.reinfshulker.item.ModItems.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("gold")).values()) {
                this.add(AdvancementTests.createTest(String.format("Obtain Diamond Shulker Box recipe advancement by having %s", item.method_63680().getString()), item, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/diamond_shulker_box")));
            }
            this.add(AdvancementTests.createTest("Obtain Diamond Shulker Box recipe advancement by having Diamond Ingot", class_1802.field_8477, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/diamond_shulker_box")));
            this.add(AdvancementTests.createTest("Obtain Diamond Shulker Box recipe advancement by having Diamond Chest", (class_1792)ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("diamond")), class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/diamond_shulker_box_from_diamond_chest")));
            for (class_1792 item : atonkish.reinfshulker.item.ModItems.REINFORCED_SHULKER_BOX_MAP.get(ReinforcingMaterials.MAP.get("diamond")).values()) {
                this.add(AdvancementTests.createTest(String.format("Obtain Netherite Shulker Box recipe advancement by having %s", item.method_63680().getString()), item, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/netherite_shulker_box_smithing")));
            }
            this.add(AdvancementTests.createTest("Obtain Netherite Shulker Box recipe advancement by having Netherite Ingot", class_1802.field_22020, class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/netherite_shulker_box_smithing")));
            this.add(AdvancementTests.createTest("Obtain Netherite Shulker Box recipe advancement by having Netherite Chest", (class_1792)ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("netherite")), class_2960.method_60655((String)"reinfshulker", (String)"recipes/decorations/netherite_shulker_box_from_netherite_chest")));
        }
    };

    private static TestFunction createTest(String name, class_1792 item, class_2960 advancementId) {
        class_2960 testIdentifier = TestIdentifier.of("reinfshulker", AdvancementTests.class, name);
        return new TestFunction(testIdentifier, TEST_ENVIRONMENT_DEFAULT, TEST_STRUCTURE_EMPTY, 20, 0, true, class_2470.field_11467, false, 1, 1, false, context -> {
            class_3222 player = MockServerPlayerHelper.spawn(context, class_1934.field_9215, class_243.method_24954((class_2382)class_2338.field_10980));
            class_8779 entry = context.method_35943().method_8503().method_3851().method_12896(advancementId);
            class_167 progress = player.method_14236().method_12882(entry);
            CompletableFuture futurePartialAct1 = new CompletableFuture();
            CompletableFuture futurePartialAct2 = new CompletableFuture();
            HashMap progressMap = new HashMap();
            String progressMapKeyBeforeHavingItem = "beforeHavingItem";
            String progressMapKeyAfterHavingItem = "afterHavingItem";
            long tickOrigin = 0L;
            context.method_35951(tickOrigin, () -> {
                progressMap.put(progressMapKeyBeforeHavingItem, progress.method_740());
                player.method_7270(new class_1799((class_1935)item));
                futurePartialAct1.complete(null);
            });
            long tickObtained = 1L;
            context.method_35951(tickObtained, () -> {
                progressMap.put(progressMapKeyAfterHavingItem, progress.method_740());
                futurePartialAct2.complete(null);
            });
            CompletableFuture.allOf(futurePartialAct1, futurePartialAct2).thenRun(() -> {
                try {
                    context.method_49994(((Boolean)progressMap.get(progressMapKeyBeforeHavingItem)).booleanValue(), class_2561.method_30163((String)String.format("Expected that advancement %s has not been done yet, but it has been already done.", entry)));
                    context.method_46226(((Boolean)progressMap.get(progressMapKeyAfterHavingItem)).booleanValue(), class_2561.method_30163((String)String.format("Expected that advancement %s has been done, but it has not been done yet.", entry)));
                }
                catch (Exception e) {
                    ReinforcedShulkerBoxesMod.LOGGER.error("[{}] {}", (Object)testIdentifier, (Object)e.getMessage());
                    throw e;
                }
                finally {
                    MockServerPlayerHelper.destroy(context, player);
                }
                context.method_36036();
            });
        });
    }
}

