/*
 * Decompiled with CFR 0.152.
 */
package com.logixel.newJoinMessages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NewJoinMessages
extends JavaPlugin
implements Listener {
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.getCommand("join") != null) {
            this.getCommand("join").setTabCompleter((TabCompleter)new JoinTabCompleter(this));
        }
        if (this.getServer().getPluginManager().getPermission("newjoin.admin") == null) {
            Permission perm = new Permission("newjoin.admin", "Allows the player to view the status of the plugin", PermissionDefault.OP);
            this.getServer().getPluginManager().addPermission(perm);
        }
        this.getLogger().info("New Join Messages Enabled");
        this.getLogger().info("Thank you for using Logixel's Join Messages Plugin");
    }

    public void onDisable() {
        this.getLogger().info("New Join Messages Disabled");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.getBoolean("enabled", true)) {
            return;
        }
        event.setJoinMessage(null);
        String player = event.getPlayer().getName();
        String template = this.config.getString("join-message", "&7[&a&l+&7] &b%player% &7joined the server.");
        Bukkit.broadcastMessage((String)this.format(template, player));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.config.getBoolean("enabled", true)) {
            return;
        }
        event.setQuitMessage(null);
        String player = event.getPlayer().getName();
        String template = this.config.getString("leave-message", "&7[&c&l-&7] &b%player% &7left the server.");
        Bukkit.broadcastMessage((String)this.format(template, player));
    }

    private String format(String template, String player) {
        if (template == null) {
            return "";
        }
        String replaced = template.replace("%player%", player);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)replaced);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("join")) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "New Join Messages v1");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Created by Logixel");
            if (sender.hasPermission("newjoin.admin")) {
                if (this.config.getBoolean("enabled", true)) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "NewJoinMessages is currently enabled!");
                } else if (!this.config.getBoolean("enabled", true)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "NewJoinMessages is currently disabled!");
                }
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("newjoin.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to reload the join messages.");
                return true;
            }
            this.saveDefaultConfig();
            this.reloadConfig();
            this.config = this.getConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "NewJoinMessages reloaded successfully!");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /join reload");
        return true;
    }

    private class JoinTabCompleter
    implements TabCompleter {
        private JoinTabCompleter(NewJoinMessages newJoinMessages) {
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            if (!command.getName().equalsIgnoreCase("join")) {
                return null;
            }
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                if (sender.hasPermission("newjoin.admin")) {
                    completions.add("reload");
                }
                return completions;
            }
            return Collections.emptyList();
        }
    }
}

