/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.converter;

import java.io.IOException;
import java.io.RandomAccessFile;

public class RiffFile {
    public static final int DDC_SUCCESS = 0;
    public static final int DDC_FAILURE = 1;
    public static final int DDC_OUT_OF_MEMORY = 2;
    public static final int DDC_FILE_ERROR = 3;
    public static final int DDC_INVALID_CALL = 4;
    public static final int DDC_USER_ABORT = 5;
    public static final int DDC_INVALID_FILE = 6;
    public static final int RFM_UNKNOWN = 0;
    public static final int RFM_WRITE = 1;
    public static final int RFM_READ = 2;
    private RiffChunkHeader riffHeader = new RiffChunkHeader();
    protected int fmode = 0;
    protected RandomAccessFile file = null;

    public RiffFile() {
        this.riffHeader.ckID = RiffFile.fourCC("RIFF");
        this.riffHeader.ckSize = 0;
    }

    public int CurrentFileMode() {
        return this.fmode;
    }

    public int Open(String filename, int NewMode) {
        int retcode = 0;
        if (this.fmode != 0) {
            retcode = this.close();
        }
        if (retcode == 0) {
            switch (NewMode) {
                case 1: {
                    try {
                        this.file = new RandomAccessFile(filename, "rw");
                        try {
                            byte br7;
                            byte[] br = new byte[8];
                            br[0] = (byte)(this.riffHeader.ckID >>> 24 & 0xFF);
                            br[1] = (byte)(this.riffHeader.ckID >>> 16 & 0xFF);
                            br[2] = (byte)(this.riffHeader.ckID >>> 8 & 0xFF);
                            br[3] = (byte)(this.riffHeader.ckID & 0xFF);
                            byte br4 = (byte)(this.riffHeader.ckSize >>> 24 & 0xFF);
                            byte br5 = (byte)(this.riffHeader.ckSize >>> 16 & 0xFF);
                            byte br6 = (byte)(this.riffHeader.ckSize >>> 8 & 0xFF);
                            br[4] = br7 = (byte)(this.riffHeader.ckSize & 0xFF);
                            br[5] = br6;
                            br[6] = br5;
                            br[7] = br4;
                            this.file.write(br, 0, 8);
                            this.fmode = 1;
                        }
                        catch (IOException ioe) {
                            this.file.close();
                            this.fmode = 0;
                        }
                    }
                    catch (IOException ioe) {
                        this.fmode = 0;
                        retcode = 3;
                    }
                    break;
                }
                case 2: {
                    try {
                        this.file = new RandomAccessFile(filename, "r");
                        try {
                            byte[] br = new byte[8];
                            this.file.read(br, 0, 8);
                            this.fmode = 2;
                            this.riffHeader.ckID = br[0] << 24 & 0xFF000000 | br[1] << 16 & 0xFF0000 | br[2] << 8 & 0xFF00 | br[3] & 0xFF;
                            this.riffHeader.ckSize = br[4] << 24 & 0xFF000000 | br[5] << 16 & 0xFF0000 | br[6] << 8 & 0xFF00 | br[7] & 0xFF;
                        }
                        catch (IOException ioe) {
                            this.file.close();
                            this.fmode = 0;
                        }
                    }
                    catch (IOException ioe) {
                        this.fmode = 0;
                        retcode = 3;
                    }
                    break;
                }
                default: {
                    retcode = 4;
                }
            }
        }
        return retcode;
    }

    public int write(byte[] data, int numBytes) {
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.write(data, 0, numBytes);
            this.fmode = 1;
        }
        catch (IOException ioe) {
            return 3;
        }
        this.riffHeader.ckSize += numBytes;
        return 0;
    }

    public int write(short[] data, int numBytes) {
        byte[] theData = new byte[numBytes];
        int yc = 0;
        for (int y = 0; y < numBytes; y += 2) {
            theData[y] = (byte)(data[yc] & 0xFF);
            theData[y + 1] = (byte)(data[yc++] >>> 8 & 0xFF);
        }
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.write(theData, 0, numBytes);
            this.fmode = 1;
        }
        catch (IOException ioe) {
            return 3;
        }
        this.riffHeader.ckSize += numBytes;
        return 0;
    }

    public int write(RiffChunkHeader triffHeader, int numBytes) {
        byte br7;
        byte[] br = new byte[8];
        br[0] = (byte)(triffHeader.ckID >>> 24 & 0xFF);
        br[1] = (byte)(triffHeader.ckID >>> 16 & 0xFF);
        br[2] = (byte)(triffHeader.ckID >>> 8 & 0xFF);
        br[3] = (byte)(triffHeader.ckID & 0xFF);
        byte br4 = (byte)(triffHeader.ckSize >>> 24 & 0xFF);
        byte br5 = (byte)(triffHeader.ckSize >>> 16 & 0xFF);
        byte br6 = (byte)(triffHeader.ckSize >>> 8 & 0xFF);
        br[4] = br7 = (byte)(triffHeader.ckSize & 0xFF);
        br[5] = br6;
        br[6] = br5;
        br[7] = br4;
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.write(br, 0, numBytes);
            this.fmode = 1;
        }
        catch (IOException ioe) {
            return 3;
        }
        this.riffHeader.ckSize += numBytes;
        return 0;
    }

    public int write(short data, int numBytes) {
        short theData = (short)(data >>> 8 & 0xFF | data << 8 & 0xFF00);
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.writeShort(theData);
            this.fmode = 1;
        }
        catch (IOException ioe) {
            return 3;
        }
        this.riffHeader.ckSize += numBytes;
        return 0;
    }

    public int write(int data, int numBytes) {
        short theDataL = (short)(data >>> 16 & 0xFFFF);
        short theDataR = (short)(data & 0xFFFF);
        short theDataLI = (short)(theDataL >>> 8 & 0xFF | theDataL << 8 & 0xFF00);
        short theDataRI = (short)(theDataR >>> 8 & 0xFF | theDataR << 8 & 0xFF00);
        int theData = theDataRI << 16 & 0xFFFF0000 | theDataLI & 0xFFFF;
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.writeInt(theData);
            this.fmode = 1;
        }
        catch (IOException ioe) {
            return 3;
        }
        this.riffHeader.ckSize += numBytes;
        return 0;
    }

    public int read(byte[] data, int numBytes) {
        int retcode = 0;
        try {
            this.file.read(data, 0, numBytes);
        }
        catch (IOException ioe) {
            retcode = 3;
        }
        return retcode;
    }

    public int expect(String data, int numBytes) {
        byte target = 0;
        int cnt = 0;
        try {
            while (numBytes-- != 0) {
                target = this.file.readByte();
                if (target == data.charAt(cnt++)) continue;
                return 3;
            }
        }
        catch (IOException ioe) {
            return 3;
        }
        return 0;
    }

    public int close() {
        int retcode = 0;
        switch (this.fmode) {
            case 1: {
                try {
                    this.file.seek(0L);
                    try {
                        byte[] br = new byte[8];
                        br[0] = (byte)(this.riffHeader.ckID >>> 24 & 0xFF);
                        br[1] = (byte)(this.riffHeader.ckID >>> 16 & 0xFF);
                        br[2] = (byte)(this.riffHeader.ckID >>> 8 & 0xFF);
                        br[3] = (byte)(this.riffHeader.ckID & 0xFF);
                        br[7] = (byte)(this.riffHeader.ckSize >>> 24 & 0xFF);
                        br[6] = (byte)(this.riffHeader.ckSize >>> 16 & 0xFF);
                        br[5] = (byte)(this.riffHeader.ckSize >>> 8 & 0xFF);
                        br[4] = (byte)(this.riffHeader.ckSize & 0xFF);
                        this.file.write(br, 0, 8);
                        this.file.close();
                    }
                    catch (IOException ioe) {
                        retcode = 3;
                    }
                }
                catch (IOException ioe) {
                    retcode = 3;
                }
                break;
            }
            case 2: {
                try {
                    this.file.close();
                    break;
                }
                catch (IOException ioe) {
                    retcode = 3;
                }
            }
        }
        this.file = null;
        this.fmode = 0;
        return retcode;
    }

    public long currentFilePosition() {
        long position;
        try {
            position = this.file.getFilePointer();
        }
        catch (IOException ioe) {
            position = -1L;
        }
        return position;
    }

    public int backpatch(long fileOffset, RiffChunkHeader data, int numBytes) {
        if (this.file == null) {
            return 4;
        }
        try {
            this.file.seek(fileOffset);
        }
        catch (IOException ioe) {
            return 3;
        }
        return this.write(data, numBytes);
    }

    public int backpatch(long fileOffset, byte[] data, int numBytes) {
        if (this.file == null) {
            return 4;
        }
        try {
            this.file.seek(fileOffset);
        }
        catch (IOException ioe) {
            return 3;
        }
        return this.write(data, numBytes);
    }

    protected int seek(long offset) {
        int rc;
        try {
            this.file.seek(offset);
            rc = 0;
        }
        catch (IOException ioe) {
            rc = 3;
        }
        return rc;
    }

    private String toDDCRETString(int retcode) {
        return switch (retcode) {
            case 0 -> "DDC_SUCCESS";
            case 1 -> "DDC_FAILURE";
            case 2 -> "DDC_OUT_OF_MEMORY";
            case 3 -> "DDC_FILE_ERROR";
            case 4 -> "DDC_INVALID_CALL";
            case 5 -> "DDC_USER_ABORT";
            case 6 -> "DDC_INVALID_FILE";
            default -> "Unknown Error";
        };
    }

    public static int fourCC(String chunkName) {
        byte[] p = chunkName.getBytes();
        int ret = p[0] << 24 & 0xFF000000 | p[1] << 16 & 0xFF0000 | p[2] << 8 & 0xFF00 | p[3] & 0xFF;
        return ret;
    }

    static class RiffChunkHeader {
        public int ckID = 0;
        public int ckSize = 0;

        RiffChunkHeader() {
        }
    }
}

