/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.decoder;

final class BitReserve {
    private static final int BUFSIZE = 32768;
    private static final int BUFSIZE_MASK = Short.MAX_VALUE;
    private int offset = 0;
    private int totbit = 0;
    private int bufByteIdx = 0;
    private final int[] buf = new int[32768];
    private int buf_bit_idx;

    BitReserve() {
    }

    public int hsstell() {
        return this.totbit;
    }

    public int hgetbits(int N) {
        this.totbit += N;
        int val = 0;
        int pos = this.bufByteIdx;
        if (pos + N < 32768) {
            while (N-- > 0) {
                val <<= 1;
                val |= this.buf[pos++] != 0 ? 1 : 0;
            }
        } else {
            while (N-- > 0) {
                val <<= 1;
                val |= this.buf[pos] != 0 ? 1 : 0;
                pos = pos + 1 & Short.MAX_VALUE;
            }
        }
        this.bufByteIdx = pos;
        return val;
    }

    public int hget1bit() {
        ++this.totbit;
        int val = this.buf[this.bufByteIdx];
        this.bufByteIdx = this.bufByteIdx + 1 & Short.MAX_VALUE;
        return val;
    }

    public void hputbuf(int val) {
        int ofs = this.offset;
        this.buf[ofs++] = val & 0x80;
        this.buf[ofs++] = val & 0x40;
        this.buf[ofs++] = val & 0x20;
        this.buf[ofs++] = val & 0x10;
        this.buf[ofs++] = val & 8;
        this.buf[ofs++] = val & 4;
        this.buf[ofs++] = val & 2;
        this.buf[ofs++] = val & 1;
        this.offset = ofs == 32768 ? 0 : ofs;
    }

    public void rewindNBits(int n) {
        this.totbit -= n;
        this.bufByteIdx -= n;
        if (this.bufByteIdx < 0) {
            this.bufByteIdx += 32768;
        }
    }

    public void rewindNBytes(int n) {
        int bits = n << 3;
        this.totbit -= bits;
        this.bufByteIdx -= bits;
        if (this.bufByteIdx < 0) {
            this.bufByteIdx += 32768;
        }
    }
}

