/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.decoder;

import audio.javazoom.jl.jl.decoder.BitstreamErrors;
import audio.javazoom.jl.jl.decoder.BitstreamException;
import audio.javazoom.jl.jl.decoder.Crc16;
import audio.javazoom.jl.jl.decoder.Header;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public final class Bitstream
implements BitstreamErrors {
    static byte INITIAL_SYNC = 0;
    static byte STRICT_SYNC = 1;
    private static final int BUFFER_INT_SIZE = 433;
    private final int[] frameBuffer = new int[433];
    private int frameSize;
    private byte[] frameBytes = new byte[1732];
    private int wordPointer;
    private int bitindex;
    private int syncWord;
    private int headerPos = 0;
    private boolean singleChMode;
    private final int[] bitmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071};
    private final PushbackInputStream source;
    private final Header header = new Header();
    private final byte[] syncBuf = new byte[4];
    private Crc16[] crc = new Crc16[1];
    private byte[] rawid3v2 = null;
    private boolean firstframe = true;

    public Bitstream(InputStream in) {
        if (in == null) {
            throw new NullPointerException("in");
        }
        in = new BufferedInputStream(in);
        this.loadID3v2(in);
        this.firstframe = true;
        this.source = new PushbackInputStream(in, 1732);
        this.closeFrame();
    }

    public int header_pos() {
        return this.headerPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadID3v2(InputStream in) {
        int size = -1;
        try {
            in.mark(10);
            this.headerPos = size = this.readID3v2Header(in);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
        try {
            if (size > 0) {
                this.rawid3v2 = new byte[size];
                in.read(this.rawid3v2, 0, this.rawid3v2.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readID3v2Header(InputStream in) throws IOException {
        byte[] id3header = new byte[4];
        int size = -10;
        in.read(id3header, 0, 3);
        if (id3header[0] == 73 && id3header[1] == 68 && id3header[2] == 51) {
            in.read(id3header, 0, 3);
            byte majorVersion = id3header[0];
            byte revision = id3header[1];
            in.read(id3header, 0, 4);
            size = (id3header[0] << 21) + (id3header[1] << 14) + (id3header[2] << 7) + id3header[3];
        }
        return size + 10;
    }

    public InputStream getRawID3v2() {
        if (this.rawid3v2 == null) {
            return null;
        }
        ByteArrayInputStream bain = new ByteArrayInputStream(this.rawid3v2);
        return bain;
    }

    public void close() throws BitstreamException {
        try {
            this.source.close();
        }
        catch (IOException ex) {
            throw this.newBitstreamException(258, ex);
        }
    }

    public Header readFrame() throws BitstreamException {
        Header result;
        block7: {
            result = null;
            try {
                result = this.readNextFrame();
                if (this.firstframe) {
                    result.parseVBR(this.frameBytes);
                    this.firstframe = false;
                }
            }
            catch (BitstreamException ex) {
                if (ex.getErrorCode() == 261) {
                    try {
                        this.closeFrame();
                        result = this.readNextFrame();
                    }
                    catch (BitstreamException e) {
                        if (e.getErrorCode() != 260) {
                            throw this.newBitstreamException(e.getErrorCode(), e);
                        }
                        break block7;
                    }
                }
                if (ex.getErrorCode() == 260) break block7;
                throw this.newBitstreamException(ex.getErrorCode(), ex);
            }
        }
        return result;
    }

    private Header readNextFrame() throws BitstreamException {
        if (this.frameSize == -1) {
            this.nextFrame();
        }
        return this.header;
    }

    private void nextFrame() throws BitstreamException {
        this.header.read_header(this, this.crc);
    }

    public void unreadFrame() throws BitstreamException {
        if (this.wordPointer == -1 && this.bitindex == -1 && this.frameSize > 0) {
            try {
                this.source.unread(this.frameBytes, 0, this.frameSize);
            }
            catch (IOException ex) {
                throw this.newBitstreamException(258);
            }
        }
    }

    public void closeFrame() {
        this.frameSize = -1;
        this.wordPointer = -1;
        this.bitindex = -1;
    }

    public boolean isSyncCurrentPosition(int syncmode) throws BitstreamException {
        int read = this.readBytes(this.syncBuf, 0, 4);
        int headerString = this.syncBuf[0] << 24 & 0xFF000000 | this.syncBuf[1] << 16 & 0xFF0000 | this.syncBuf[2] << 8 & 0xFF00 | this.syncBuf[3] << 0 & 0xFF;
        try {
            this.source.unread(this.syncBuf, 0, read);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean sync = switch (read) {
            case 0 -> true;
            case 4 -> this.isSyncMark(headerString, syncmode, this.syncWord);
            default -> false;
        };
        return sync;
    }

    public int readBits(int n) {
        return this.getBits(n);
    }

    public int readCheckedBits(int n) {
        return this.getBits(n);
    }

    BitstreamException newBitstreamException(int errorcode) {
        return new BitstreamException(errorcode, null);
    }

    BitstreamException newBitstreamException(int errorcode, Throwable throwable) {
        return new BitstreamException(errorcode, throwable);
    }

    int syncHeader(byte syncMode) throws BitstreamException {
        boolean sync;
        int bytesRead = this.readBytes(this.syncBuf, 0, 3);
        if (bytesRead != 3) {
            throw this.newBitstreamException(260, null);
        }
        int headerString = this.syncBuf[0] << 16 & 0xFF0000 | this.syncBuf[1] << 8 & 0xFF00 | this.syncBuf[2] << 0 & 0xFF;
        do {
            headerString <<= 8;
            if (this.readBytes(this.syncBuf, 3, 1) == 1) continue;
            throw this.newBitstreamException(260, null);
        } while (!(sync = this.isSyncMark(headerString |= this.syncBuf[3] & 0xFF, syncMode, this.syncWord)));
        return headerString;
    }

    public boolean isSyncMark(int headerstring, int syncmode, int word) {
        boolean sync = false;
        if (syncmode == INITIAL_SYNC) {
            sync = (headerstring & 0xFFE00000) == -2097152;
        } else {
            boolean bl = (headerstring & 0xFFF80C00) == word && (headerstring & 0xC0) == 192 == this.singleChMode ? true : (sync = false);
        }
        if (sync) {
            boolean bl = sync = (headerstring >>> 10 & 3) != 3;
        }
        if (sync) {
            boolean bl = sync = (headerstring >>> 17 & 3) != 0;
        }
        if (sync) {
            sync = (headerstring >>> 19 & 3) != 1;
        }
        return sync;
    }

    int readFrameData(int bytesize) throws BitstreamException {
        int numread = 0;
        numread = this.readFully(this.frameBytes, 0, bytesize);
        this.frameSize = bytesize;
        this.wordPointer = -1;
        this.bitindex = -1;
        return numread;
    }

    void parseFrame() throws BitstreamException {
        int b = 0;
        byte[] byteread = this.frameBytes;
        int bytesize = this.frameSize;
        for (int k = 0; k < bytesize; k += 4) {
            boolean convert = false;
            byte b0 = 0;
            byte b1 = 0;
            byte b2 = 0;
            byte b3 = 0;
            b0 = byteread[k];
            if (k + 1 < bytesize) {
                b1 = byteread[k + 1];
            }
            if (k + 2 < bytesize) {
                b2 = byteread[k + 2];
            }
            if (k + 3 < bytesize) {
                b3 = byteread[k + 3];
            }
            this.frameBuffer[b++] = b0 << 24 & 0xFF000000 | b1 << 16 & 0xFF0000 | b2 << 8 & 0xFF00 | b3 & 0xFF;
        }
        this.wordPointer = 0;
        this.bitindex = 0;
    }

    public int getBits(int number_of_bits) {
        int returnvalue = 0;
        int sum = this.bitindex + number_of_bits;
        if (this.wordPointer < 0) {
            this.wordPointer = 0;
        }
        if (sum <= 32) {
            returnvalue = this.frameBuffer[this.wordPointer] >>> 32 - sum & this.bitmask[number_of_bits];
            if ((this.bitindex += number_of_bits) == 32) {
                this.bitindex = 0;
                ++this.wordPointer;
            }
            return returnvalue;
        }
        int Right = this.frameBuffer[this.wordPointer] & 0xFFFF;
        ++this.wordPointer;
        int Left = this.frameBuffer[this.wordPointer] & 0xFFFF0000;
        returnvalue = Right << 16 & 0xFFFF0000 | Left >>> 16 & 0xFFFF;
        returnvalue >>>= 48 - sum;
        this.bitindex = sum - 32;
        return returnvalue &= this.bitmask[number_of_bits];
    }

    void setSyncWord(int syncWord) {
        this.syncWord = syncWord & 0xFFFFFF3F;
        this.singleChMode = (syncWord & 0xC0) == 192;
    }

    private int readFully(byte[] b, int offs, int len) throws BitstreamException {
        int nRead = 0;
        try {
            while (len > 0) {
                int bytesread = this.source.read(b, offs, len);
                if (bytesread == -1) {
                    while (len-- > 0) {
                        b[offs++] = 0;
                    }
                    break;
                }
                nRead += bytesread;
                offs += bytesread;
                len -= bytesread;
            }
        }
        catch (IOException ex) {
            throw this.newBitstreamException(258, ex);
        }
        return nRead;
    }

    private int readBytes(byte[] b, int offs, int len) throws BitstreamException {
        int totalBytesRead = 0;
        try {
            int bytesread;
            while (len > 0 && (bytesread = this.source.read(b, offs, len)) != -1) {
                totalBytesRead += bytesread;
                offs += bytesread;
                len -= bytesread;
            }
        }
        catch (IOException ex) {
            throw this.newBitstreamException(258, ex);
        }
        return totalBytesRead;
    }
}

