/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.decoder;

import audio.javazoom.jl.jl.decoder.Bitstream;
import audio.javazoom.jl.jl.decoder.Crc16;
import audio.javazoom.jl.jl.decoder.FrameDecoder;
import audio.javazoom.jl.jl.decoder.Header;
import audio.javazoom.jl.jl.decoder.LayerIDecoder;
import audio.javazoom.jl.jl.decoder.SynthesisFilter;

class LayerIIDecoder
extends LayerIDecoder
implements FrameDecoder {
    LayerIIDecoder() {
    }

    @Override
    protected void createSubbands() {
        if (this.mode == 3) {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer2(i);
            }
        } else if (this.mode == 1) {
            int i;
            for (i = 0; i < this.header.intensityStereoBound(); ++i) {
                this.subbands[i] = new SubbandLayer2Stereo(i);
            }
            while (i < this.num_subbands) {
                this.subbands[i] = new SubbandLayer2IntensityStereo(i);
                ++i;
            }
        } else {
            for (int i = 0; i < this.num_subbands; ++i) {
                this.subbands[i] = new SubbandLayer2Stereo(i);
            }
        }
    }

    @Override
    protected void readScaleFactorSelection() {
        for (int i = 0; i < this.num_subbands; ++i) {
            ((SubbandLayer2)this.subbands[i]).readScaleFactorSelection(this.stream, this.crc);
        }
    }

    static class SubbandLayer2
    extends LayerIDecoder.Subband {
        public static final float[] grouping_5bits = new float[]{-0.6666667f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, -0.6666667f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f};
        public static final float[] grouping_7bits = new float[]{-0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.8f, -0.8f, -0.8f, -0.4f, -0.4f, -0.8f, -0.4f, 0.0f, -0.8f, -0.4f, 0.4f, -0.8f, -0.4f, 0.8f, -0.8f, -0.4f, -0.8f, -0.4f, -0.4f, -0.4f, -0.4f, -0.4f, 0.0f, -0.4f, -0.4f, 0.4f, -0.4f, -0.4f, 0.8f, -0.4f, -0.4f, -0.8f, 0.0f, -0.4f, -0.4f, 0.0f, -0.4f, 0.0f, 0.0f, -0.4f, 0.4f, 0.0f, -0.4f, 0.8f, 0.0f, -0.4f, -0.8f, 0.4f, -0.4f, -0.4f, 0.4f, -0.4f, 0.0f, 0.4f, -0.4f, 0.4f, 0.4f, -0.4f, 0.8f, 0.4f, -0.4f, -0.8f, 0.8f, -0.4f, -0.4f, 0.8f, -0.4f, 0.0f, 0.8f, -0.4f, 0.4f, 0.8f, -0.4f, 0.8f, 0.8f, -0.4f, -0.8f, -0.8f, 0.0f, -0.4f, -0.8f, 0.0f, 0.0f, -0.8f, 0.0f, 0.4f, -0.8f, 0.0f, 0.8f, -0.8f, 0.0f, -0.8f, -0.4f, 0.0f, -0.4f, -0.4f, 0.0f, 0.0f, -0.4f, 0.0f, 0.4f, -0.4f, 0.0f, 0.8f, -0.4f, 0.0f, -0.8f, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.0f, 0.0f, 0.8f, 0.0f, 0.0f, -0.8f, 0.4f, 0.0f, -0.4f, 0.4f, 0.0f, 0.0f, 0.4f, 0.0f, 0.4f, 0.4f, 0.0f, 0.8f, 0.4f, 0.0f, -0.8f, 0.8f, 0.0f, -0.4f, 0.8f, 0.0f, 0.0f, 0.8f, 0.0f, 0.4f, 0.8f, 0.0f, 0.8f, 0.8f, 0.0f, -0.8f, -0.8f, 0.4f, -0.4f, -0.8f, 0.4f, 0.0f, -0.8f, 0.4f, 0.4f, -0.8f, 0.4f, 0.8f, -0.8f, 0.4f, -0.8f, -0.4f, 0.4f, -0.4f, -0.4f, 0.4f, 0.0f, -0.4f, 0.4f, 0.4f, -0.4f, 0.4f, 0.8f, -0.4f, 0.4f, -0.8f, 0.0f, 0.4f, -0.4f, 0.0f, 0.4f, 0.0f, 0.0f, 0.4f, 0.4f, 0.0f, 0.4f, 0.8f, 0.0f, 0.4f, -0.8f, 0.4f, 0.4f, -0.4f, 0.4f, 0.4f, 0.0f, 0.4f, 0.4f, 0.4f, 0.4f, 0.4f, 0.8f, 0.4f, 0.4f, -0.8f, 0.8f, 0.4f, -0.4f, 0.8f, 0.4f, 0.0f, 0.8f, 0.4f, 0.4f, 0.8f, 0.4f, 0.8f, 0.8f, 0.4f, -0.8f, -0.8f, 0.8f, -0.4f, -0.8f, 0.8f, 0.0f, -0.8f, 0.8f, 0.4f, -0.8f, 0.8f, 0.8f, -0.8f, 0.8f, -0.8f, -0.4f, 0.8f, -0.4f, -0.4f, 0.8f, 0.0f, -0.4f, 0.8f, 0.4f, -0.4f, 0.8f, 0.8f, -0.4f, 0.8f, -0.8f, 0.0f, 0.8f, -0.4f, 0.0f, 0.8f, 0.0f, 0.0f, 0.8f, 0.4f, 0.0f, 0.8f, 0.8f, 0.0f, 0.8f, -0.8f, 0.4f, 0.8f, -0.4f, 0.4f, 0.8f, 0.0f, 0.4f, 0.8f, 0.4f, 0.4f, 0.8f, 0.8f, 0.4f, 0.8f, -0.8f, 0.8f, 0.8f, -0.4f, 0.8f, 0.8f, 0.0f, 0.8f, 0.8f, 0.4f, 0.8f, 0.8f, 0.8f, 0.8f, 0.8f};
        public static final float[] grouping_10bits = new float[]{-0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.22222222f, 0.0f, -0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.8888889f, 0.8888889f, -0.8888889f, -0.8888889f, -0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.6666667f, -0.8888889f, -0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, -0.6666667f, -0.44444445f, -0.6666667f, -0.6666667f, -0.22222222f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.22222222f, -0.6666667f, -0.6666667f, 0.44444445f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, 0.8888889f, -0.6666667f, -0.6666667f, -0.8888889f, -0.44444445f, -0.6666667f, -0.6666667f, -0.44444445f, -0.6666667f, -0.44444445f, -0.44444445f, -0.6666667f, -0.22222222f, -0.44444445f, -0.6666667f, 0.0f, -0.44444445f, -0.6666667f, 0.22222222f, -0.44444445f, -0.6666667f, 0.44444445f, -0.44444445f, -0.6666667f, 0.6666667f, -0.44444445f, -0.6666667f, 0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.22222222f, -0.6666667f, -0.6666667f, -0.22222222f, -0.6666667f, -0.44444445f, -0.22222222f, -0.6666667f, -0.22222222f, -0.22222222f, -0.6666667f, 0.0f, -0.22222222f, -0.6666667f, 0.22222222f, -0.22222222f, -0.6666667f, 0.44444445f, -0.22222222f, -0.6666667f, 0.6666667f, -0.22222222f, -0.6666667f, 0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, 0.0f, -0.6666667f, -0.6666667f, 0.0f, -0.6666667f, -0.44444445f, 0.0f, -0.6666667f, -0.22222222f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.22222222f, 0.0f, -0.6666667f, 0.44444445f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.22222222f, -0.6666667f, -0.6666667f, 0.22222222f, -0.6666667f, -0.44444445f, 0.22222222f, -0.6666667f, -0.22222222f, 0.22222222f, -0.6666667f, 0.0f, 0.22222222f, -0.6666667f, 0.22222222f, 0.22222222f, -0.6666667f, 0.44444445f, 0.22222222f, -0.6666667f, 0.6666667f, 0.22222222f, -0.6666667f, 0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.44444445f, -0.6666667f, -0.6666667f, 0.44444445f, -0.6666667f, -0.44444445f, 0.44444445f, -0.6666667f, -0.22222222f, 0.44444445f, -0.6666667f, 0.0f, 0.44444445f, -0.6666667f, 0.22222222f, 0.44444445f, -0.6666667f, 0.44444445f, 0.44444445f, -0.6666667f, 0.6666667f, 0.44444445f, -0.6666667f, 0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.6666667f, -0.6666667f, -0.6666667f, 0.6666667f, -0.6666667f, -0.44444445f, 0.6666667f, -0.6666667f, -0.22222222f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.22222222f, 0.6666667f, -0.6666667f, 0.44444445f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.8888889f, -0.6666667f, -0.6666667f, 0.8888889f, -0.6666667f, -0.44444445f, 0.8888889f, -0.6666667f, -0.22222222f, 0.8888889f, -0.6666667f, 0.0f, 0.8888889f, -0.6666667f, 0.22222222f, 0.8888889f, -0.6666667f, 0.44444445f, 0.8888889f, -0.6666667f, 0.6666667f, 0.8888889f, -0.6666667f, 0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, -0.8888889f, -0.44444445f, -0.6666667f, -0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.44444445f, -0.8888889f, -0.6666667f, -0.44444445f, -0.6666667f, -0.6666667f, -0.44444445f, -0.44444445f, -0.6666667f, -0.44444445f, -0.22222222f, -0.6666667f, -0.44444445f, 0.0f, -0.6666667f, -0.44444445f, 0.22222222f, -0.6666667f, -0.44444445f, 0.44444445f, -0.6666667f, -0.44444445f, 0.6666667f, -0.6666667f, -0.44444445f, 0.8888889f, -0.6666667f, -0.44444445f, -0.8888889f, -0.44444445f, -0.44444445f, -0.6666667f, -0.44444445f, -0.44444445f, -0.44444445f, -0.44444445f, -0.44444445f, -0.22222222f, -0.44444445f, -0.44444445f, 0.0f, -0.44444445f, -0.44444445f, 0.22222222f, -0.44444445f, -0.44444445f, 0.44444445f, -0.44444445f, -0.44444445f, 0.6666667f, -0.44444445f, -0.44444445f, 0.8888889f, -0.44444445f, -0.44444445f, -0.8888889f, -0.22222222f, -0.44444445f, -0.6666667f, -0.22222222f, -0.44444445f, -0.44444445f, -0.22222222f, -0.44444445f, -0.22222222f, -0.22222222f, -0.44444445f, 0.0f, -0.22222222f, -0.44444445f, 0.22222222f, -0.22222222f, -0.44444445f, 0.44444445f, -0.22222222f, -0.44444445f, 0.6666667f, -0.22222222f, -0.44444445f, 0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, 0.0f, -0.44444445f, -0.6666667f, 0.0f, -0.44444445f, -0.44444445f, 0.0f, -0.44444445f, -0.22222222f, 0.0f, -0.44444445f, 0.0f, 0.0f, -0.44444445f, 0.22222222f, 0.0f, -0.44444445f, 0.44444445f, 0.0f, -0.44444445f, 0.6666667f, 0.0f, -0.44444445f, 0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.22222222f, -0.44444445f, -0.6666667f, 0.22222222f, -0.44444445f, -0.44444445f, 0.22222222f, -0.44444445f, -0.22222222f, 0.22222222f, -0.44444445f, 0.0f, 0.22222222f, -0.44444445f, 0.22222222f, 0.22222222f, -0.44444445f, 0.44444445f, 0.22222222f, -0.44444445f, 0.6666667f, 0.22222222f, -0.44444445f, 0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.44444445f, -0.44444445f, -0.6666667f, 0.44444445f, -0.44444445f, -0.44444445f, 0.44444445f, -0.44444445f, -0.22222222f, 0.44444445f, -0.44444445f, 0.0f, 0.44444445f, -0.44444445f, 0.22222222f, 0.44444445f, -0.44444445f, 0.44444445f, 0.44444445f, -0.44444445f, 0.6666667f, 0.44444445f, -0.44444445f, 0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.6666667f, -0.44444445f, -0.6666667f, 0.6666667f, -0.44444445f, -0.44444445f, 0.6666667f, -0.44444445f, -0.22222222f, 0.6666667f, -0.44444445f, 0.0f, 0.6666667f, -0.44444445f, 0.22222222f, 0.6666667f, -0.44444445f, 0.44444445f, 0.6666667f, -0.44444445f, 0.6666667f, 0.6666667f, -0.44444445f, 0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.8888889f, -0.44444445f, -0.6666667f, 0.8888889f, -0.44444445f, -0.44444445f, 0.8888889f, -0.44444445f, -0.22222222f, 0.8888889f, -0.44444445f, 0.0f, 0.8888889f, -0.44444445f, 0.22222222f, 0.8888889f, -0.44444445f, 0.44444445f, 0.8888889f, -0.44444445f, 0.6666667f, 0.8888889f, -0.44444445f, 0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, -0.8888889f, -0.22222222f, -0.6666667f, -0.8888889f, -0.22222222f, -0.44444445f, -0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, -0.22222222f, 0.0f, -0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, -0.22222222f, -0.8888889f, -0.6666667f, -0.22222222f, -0.6666667f, -0.6666667f, -0.22222222f, -0.44444445f, -0.6666667f, -0.22222222f, -0.22222222f, -0.6666667f, -0.22222222f, 0.0f, -0.6666667f, -0.22222222f, 0.22222222f, -0.6666667f, -0.22222222f, 0.44444445f, -0.6666667f, -0.22222222f, 0.6666667f, -0.6666667f, -0.22222222f, 0.8888889f, -0.6666667f, -0.22222222f, -0.8888889f, -0.44444445f, -0.22222222f, -0.6666667f, -0.44444445f, -0.22222222f, -0.44444445f, -0.44444445f, -0.22222222f, -0.22222222f, -0.44444445f, -0.22222222f, 0.0f, -0.44444445f, -0.22222222f, 0.22222222f, -0.44444445f, -0.22222222f, 0.44444445f, -0.44444445f, -0.22222222f, 0.6666667f, -0.44444445f, -0.22222222f, 0.8888889f, -0.44444445f, -0.22222222f, -0.8888889f, -0.22222222f, -0.22222222f, -0.6666667f, -0.22222222f, -0.22222222f, -0.44444445f, -0.22222222f, -0.22222222f, -0.22222222f, -0.22222222f, -0.22222222f, 0.0f, -0.22222222f, -0.22222222f, 0.22222222f, -0.22222222f, -0.22222222f, 0.44444445f, -0.22222222f, -0.22222222f, 0.6666667f, -0.22222222f, -0.22222222f, 0.8888889f, -0.22222222f, -0.22222222f, -0.8888889f, 0.0f, -0.22222222f, -0.6666667f, 0.0f, -0.22222222f, -0.44444445f, 0.0f, -0.22222222f, -0.22222222f, 0.0f, -0.22222222f, 0.0f, 0.0f, -0.22222222f, 0.22222222f, 0.0f, -0.22222222f, 0.44444445f, 0.0f, -0.22222222f, 0.6666667f, 0.0f, -0.22222222f, 0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.22222222f, -0.22222222f, -0.6666667f, 0.22222222f, -0.22222222f, -0.44444445f, 0.22222222f, -0.22222222f, -0.22222222f, 0.22222222f, -0.22222222f, 0.0f, 0.22222222f, -0.22222222f, 0.22222222f, 0.22222222f, -0.22222222f, 0.44444445f, 0.22222222f, -0.22222222f, 0.6666667f, 0.22222222f, -0.22222222f, 0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.44444445f, -0.22222222f, -0.6666667f, 0.44444445f, -0.22222222f, -0.44444445f, 0.44444445f, -0.22222222f, -0.22222222f, 0.44444445f, -0.22222222f, 0.0f, 0.44444445f, -0.22222222f, 0.22222222f, 0.44444445f, -0.22222222f, 0.44444445f, 0.44444445f, -0.22222222f, 0.6666667f, 0.44444445f, -0.22222222f, 0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.6666667f, -0.22222222f, -0.6666667f, 0.6666667f, -0.22222222f, -0.44444445f, 0.6666667f, -0.22222222f, -0.22222222f, 0.6666667f, -0.22222222f, 0.0f, 0.6666667f, -0.22222222f, 0.22222222f, 0.6666667f, -0.22222222f, 0.44444445f, 0.6666667f, -0.22222222f, 0.6666667f, 0.6666667f, -0.22222222f, 0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.8888889f, -0.22222222f, -0.6666667f, 0.8888889f, -0.22222222f, -0.44444445f, 0.8888889f, -0.22222222f, -0.22222222f, 0.8888889f, -0.22222222f, 0.0f, 0.8888889f, -0.22222222f, 0.22222222f, 0.8888889f, -0.22222222f, 0.44444445f, 0.8888889f, -0.22222222f, 0.6666667f, 0.8888889f, -0.22222222f, 0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, -0.8888889f, 0.0f, -0.6666667f, -0.8888889f, 0.0f, -0.44444445f, -0.8888889f, 0.0f, -0.22222222f, -0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.0f, -0.8888889f, -0.6666667f, 0.0f, -0.6666667f, -0.6666667f, 0.0f, -0.44444445f, -0.6666667f, 0.0f, -0.22222222f, -0.6666667f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.22222222f, -0.6666667f, 0.0f, 0.44444445f, -0.6666667f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, 0.8888889f, -0.6666667f, 0.0f, -0.8888889f, -0.44444445f, 0.0f, -0.6666667f, -0.44444445f, 0.0f, -0.44444445f, -0.44444445f, 0.0f, -0.22222222f, -0.44444445f, 0.0f, 0.0f, -0.44444445f, 0.0f, 0.22222222f, -0.44444445f, 0.0f, 0.44444445f, -0.44444445f, 0.0f, 0.6666667f, -0.44444445f, 0.0f, 0.8888889f, -0.44444445f, 0.0f, -0.8888889f, -0.22222222f, 0.0f, -0.6666667f, -0.22222222f, 0.0f, -0.44444445f, -0.22222222f, 0.0f, -0.22222222f, -0.22222222f, 0.0f, 0.0f, -0.22222222f, 0.0f, 0.22222222f, -0.22222222f, 0.0f, 0.44444445f, -0.22222222f, 0.0f, 0.6666667f, -0.22222222f, 0.0f, 0.8888889f, -0.22222222f, 0.0f, -0.8888889f, 0.0f, 0.0f, -0.6666667f, 0.0f, 0.0f, -0.44444445f, 0.0f, 0.0f, -0.22222222f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.22222222f, 0.0f, 0.0f, 0.44444445f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.8888889f, 0.0f, 0.0f, -0.8888889f, 0.22222222f, 0.0f, -0.6666667f, 0.22222222f, 0.0f, -0.44444445f, 0.22222222f, 0.0f, -0.22222222f, 0.22222222f, 0.0f, 0.0f, 0.22222222f, 0.0f, 0.22222222f, 0.22222222f, 0.0f, 0.44444445f, 0.22222222f, 0.0f, 0.6666667f, 0.22222222f, 0.0f, 0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.44444445f, 0.0f, -0.6666667f, 0.44444445f, 0.0f, -0.44444445f, 0.44444445f, 0.0f, -0.22222222f, 0.44444445f, 0.0f, 0.0f, 0.44444445f, 0.0f, 0.22222222f, 0.44444445f, 0.0f, 0.44444445f, 0.44444445f, 0.0f, 0.6666667f, 0.44444445f, 0.0f, 0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.0f, -0.44444445f, 0.6666667f, 0.0f, -0.22222222f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.0f, 0.22222222f, 0.6666667f, 0.0f, 0.44444445f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.8888889f, 0.0f, -0.6666667f, 0.8888889f, 0.0f, -0.44444445f, 0.8888889f, 0.0f, -0.22222222f, 0.8888889f, 0.0f, 0.0f, 0.8888889f, 0.0f, 0.22222222f, 0.8888889f, 0.0f, 0.44444445f, 0.8888889f, 0.0f, 0.6666667f, 0.8888889f, 0.0f, 0.8888889f, 0.8888889f, 0.0f, -0.8888889f, -0.8888889f, 0.22222222f, -0.6666667f, -0.8888889f, 0.22222222f, -0.44444445f, -0.8888889f, 0.22222222f, -0.22222222f, -0.8888889f, 0.22222222f, 0.0f, -0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.22222222f, -0.8888889f, -0.6666667f, 0.22222222f, -0.6666667f, -0.6666667f, 0.22222222f, -0.44444445f, -0.6666667f, 0.22222222f, -0.22222222f, -0.6666667f, 0.22222222f, 0.0f, -0.6666667f, 0.22222222f, 0.22222222f, -0.6666667f, 0.22222222f, 0.44444445f, -0.6666667f, 0.22222222f, 0.6666667f, -0.6666667f, 0.22222222f, 0.8888889f, -0.6666667f, 0.22222222f, -0.8888889f, -0.44444445f, 0.22222222f, -0.6666667f, -0.44444445f, 0.22222222f, -0.44444445f, -0.44444445f, 0.22222222f, -0.22222222f, -0.44444445f, 0.22222222f, 0.0f, -0.44444445f, 0.22222222f, 0.22222222f, -0.44444445f, 0.22222222f, 0.44444445f, -0.44444445f, 0.22222222f, 0.6666667f, -0.44444445f, 0.22222222f, 0.8888889f, -0.44444445f, 0.22222222f, -0.8888889f, -0.22222222f, 0.22222222f, -0.6666667f, -0.22222222f, 0.22222222f, -0.44444445f, -0.22222222f, 0.22222222f, -0.22222222f, -0.22222222f, 0.22222222f, 0.0f, -0.22222222f, 0.22222222f, 0.22222222f, -0.22222222f, 0.22222222f, 0.44444445f, -0.22222222f, 0.22222222f, 0.6666667f, -0.22222222f, 0.22222222f, 0.8888889f, -0.22222222f, 0.22222222f, -0.8888889f, 0.0f, 0.22222222f, -0.6666667f, 0.0f, 0.22222222f, -0.44444445f, 0.0f, 0.22222222f, -0.22222222f, 0.0f, 0.22222222f, 0.0f, 0.0f, 0.22222222f, 0.22222222f, 0.0f, 0.22222222f, 0.44444445f, 0.0f, 0.22222222f, 0.6666667f, 0.0f, 0.22222222f, 0.8888889f, 0.0f, 0.22222222f, -0.8888889f, 0.22222222f, 0.22222222f, -0.6666667f, 0.22222222f, 0.22222222f, -0.44444445f, 0.22222222f, 0.22222222f, -0.22222222f, 0.22222222f, 0.22222222f, 0.0f, 0.22222222f, 0.22222222f, 0.22222222f, 0.22222222f, 0.22222222f, 0.44444445f, 0.22222222f, 0.22222222f, 0.6666667f, 0.22222222f, 0.22222222f, 0.8888889f, 0.22222222f, 0.22222222f, -0.8888889f, 0.44444445f, 0.22222222f, -0.6666667f, 0.44444445f, 0.22222222f, -0.44444445f, 0.44444445f, 0.22222222f, -0.22222222f, 0.44444445f, 0.22222222f, 0.0f, 0.44444445f, 0.22222222f, 0.22222222f, 0.44444445f, 0.22222222f, 0.44444445f, 0.44444445f, 0.22222222f, 0.6666667f, 0.44444445f, 0.22222222f, 0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.6666667f, 0.22222222f, -0.6666667f, 0.6666667f, 0.22222222f, -0.44444445f, 0.6666667f, 0.22222222f, -0.22222222f, 0.6666667f, 0.22222222f, 0.0f, 0.6666667f, 0.22222222f, 0.22222222f, 0.6666667f, 0.22222222f, 0.44444445f, 0.6666667f, 0.22222222f, 0.6666667f, 0.6666667f, 0.22222222f, 0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.8888889f, 0.22222222f, -0.6666667f, 0.8888889f, 0.22222222f, -0.44444445f, 0.8888889f, 0.22222222f, -0.22222222f, 0.8888889f, 0.22222222f, 0.0f, 0.8888889f, 0.22222222f, 0.22222222f, 0.8888889f, 0.22222222f, 0.44444445f, 0.8888889f, 0.22222222f, 0.6666667f, 0.8888889f, 0.22222222f, 0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, -0.8888889f, 0.44444445f, -0.6666667f, -0.8888889f, 0.44444445f, -0.44444445f, -0.8888889f, 0.44444445f, -0.22222222f, -0.8888889f, 0.44444445f, 0.0f, -0.8888889f, 0.44444445f, 0.22222222f, -0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.44444445f, -0.8888889f, -0.6666667f, 0.44444445f, -0.6666667f, -0.6666667f, 0.44444445f, -0.44444445f, -0.6666667f, 0.44444445f, -0.22222222f, -0.6666667f, 0.44444445f, 0.0f, -0.6666667f, 0.44444445f, 0.22222222f, -0.6666667f, 0.44444445f, 0.44444445f, -0.6666667f, 0.44444445f, 0.6666667f, -0.6666667f, 0.44444445f, 0.8888889f, -0.6666667f, 0.44444445f, -0.8888889f, -0.44444445f, 0.44444445f, -0.6666667f, -0.44444445f, 0.44444445f, -0.44444445f, -0.44444445f, 0.44444445f, -0.22222222f, -0.44444445f, 0.44444445f, 0.0f, -0.44444445f, 0.44444445f, 0.22222222f, -0.44444445f, 0.44444445f, 0.44444445f, -0.44444445f, 0.44444445f, 0.6666667f, -0.44444445f, 0.44444445f, 0.8888889f, -0.44444445f, 0.44444445f, -0.8888889f, -0.22222222f, 0.44444445f, -0.6666667f, -0.22222222f, 0.44444445f, -0.44444445f, -0.22222222f, 0.44444445f, -0.22222222f, -0.22222222f, 0.44444445f, 0.0f, -0.22222222f, 0.44444445f, 0.22222222f, -0.22222222f, 0.44444445f, 0.44444445f, -0.22222222f, 0.44444445f, 0.6666667f, -0.22222222f, 0.44444445f, 0.8888889f, -0.22222222f, 0.44444445f, -0.8888889f, 0.0f, 0.44444445f, -0.6666667f, 0.0f, 0.44444445f, -0.44444445f, 0.0f, 0.44444445f, -0.22222222f, 0.0f, 0.44444445f, 0.0f, 0.0f, 0.44444445f, 0.22222222f, 0.0f, 0.44444445f, 0.44444445f, 0.0f, 0.44444445f, 0.6666667f, 0.0f, 0.44444445f, 0.8888889f, 0.0f, 0.44444445f, -0.8888889f, 0.22222222f, 0.44444445f, -0.6666667f, 0.22222222f, 0.44444445f, -0.44444445f, 0.22222222f, 0.44444445f, -0.22222222f, 0.22222222f, 0.44444445f, 0.0f, 0.22222222f, 0.44444445f, 0.22222222f, 0.22222222f, 0.44444445f, 0.44444445f, 0.22222222f, 0.44444445f, 0.6666667f, 0.22222222f, 0.44444445f, 0.8888889f, 0.22222222f, 0.44444445f, -0.8888889f, 0.44444445f, 0.44444445f, -0.6666667f, 0.44444445f, 0.44444445f, -0.44444445f, 0.44444445f, 0.44444445f, -0.22222222f, 0.44444445f, 0.44444445f, 0.0f, 0.44444445f, 0.44444445f, 0.22222222f, 0.44444445f, 0.44444445f, 0.44444445f, 0.44444445f, 0.44444445f, 0.6666667f, 0.44444445f, 0.44444445f, 0.8888889f, 0.44444445f, 0.44444445f, -0.8888889f, 0.6666667f, 0.44444445f, -0.6666667f, 0.6666667f, 0.44444445f, -0.44444445f, 0.6666667f, 0.44444445f, -0.22222222f, 0.6666667f, 0.44444445f, 0.0f, 0.6666667f, 0.44444445f, 0.22222222f, 0.6666667f, 0.44444445f, 0.44444445f, 0.6666667f, 0.44444445f, 0.6666667f, 0.6666667f, 0.44444445f, 0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.8888889f, 0.44444445f, -0.6666667f, 0.8888889f, 0.44444445f, -0.44444445f, 0.8888889f, 0.44444445f, -0.22222222f, 0.8888889f, 0.44444445f, 0.0f, 0.8888889f, 0.44444445f, 0.22222222f, 0.8888889f, 0.44444445f, 0.44444445f, 0.8888889f, 0.44444445f, 0.6666667f, 0.8888889f, 0.44444445f, 0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, -0.8888889f, 0.6666667f, -0.6666667f, -0.8888889f, 0.6666667f, -0.44444445f, -0.8888889f, 0.6666667f, -0.22222222f, -0.8888889f, 0.6666667f, 0.0f, -0.8888889f, 0.6666667f, 0.22222222f, -0.8888889f, 0.6666667f, 0.44444445f, -0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.6666667f, -0.8888889f, -0.6666667f, 0.6666667f, -0.6666667f, -0.6666667f, 0.6666667f, -0.44444445f, -0.6666667f, 0.6666667f, -0.22222222f, -0.6666667f, 0.6666667f, 0.0f, -0.6666667f, 0.6666667f, 0.22222222f, -0.6666667f, 0.6666667f, 0.44444445f, -0.6666667f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, 0.8888889f, -0.6666667f, 0.6666667f, -0.8888889f, -0.44444445f, 0.6666667f, -0.6666667f, -0.44444445f, 0.6666667f, -0.44444445f, -0.44444445f, 0.6666667f, -0.22222222f, -0.44444445f, 0.6666667f, 0.0f, -0.44444445f, 0.6666667f, 0.22222222f, -0.44444445f, 0.6666667f, 0.44444445f, -0.44444445f, 0.6666667f, 0.6666667f, -0.44444445f, 0.6666667f, 0.8888889f, -0.44444445f, 0.6666667f, -0.8888889f, -0.22222222f, 0.6666667f, -0.6666667f, -0.22222222f, 0.6666667f, -0.44444445f, -0.22222222f, 0.6666667f, -0.22222222f, -0.22222222f, 0.6666667f, 0.0f, -0.22222222f, 0.6666667f, 0.22222222f, -0.22222222f, 0.6666667f, 0.44444445f, -0.22222222f, 0.6666667f, 0.6666667f, -0.22222222f, 0.6666667f, 0.8888889f, -0.22222222f, 0.6666667f, -0.8888889f, 0.0f, 0.6666667f, -0.6666667f, 0.0f, 0.6666667f, -0.44444445f, 0.0f, 0.6666667f, -0.22222222f, 0.0f, 0.6666667f, 0.0f, 0.0f, 0.6666667f, 0.22222222f, 0.0f, 0.6666667f, 0.44444445f, 0.0f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.8888889f, 0.0f, 0.6666667f, -0.8888889f, 0.22222222f, 0.6666667f, -0.6666667f, 0.22222222f, 0.6666667f, -0.44444445f, 0.22222222f, 0.6666667f, -0.22222222f, 0.22222222f, 0.6666667f, 0.0f, 0.22222222f, 0.6666667f, 0.22222222f, 0.22222222f, 0.6666667f, 0.44444445f, 0.22222222f, 0.6666667f, 0.6666667f, 0.22222222f, 0.6666667f, 0.8888889f, 0.22222222f, 0.6666667f, -0.8888889f, 0.44444445f, 0.6666667f, -0.6666667f, 0.44444445f, 0.6666667f, -0.44444445f, 0.44444445f, 0.6666667f, -0.22222222f, 0.44444445f, 0.6666667f, 0.0f, 0.44444445f, 0.6666667f, 0.22222222f, 0.44444445f, 0.6666667f, 0.44444445f, 0.44444445f, 0.6666667f, 0.6666667f, 0.44444445f, 0.6666667f, 0.8888889f, 0.44444445f, 0.6666667f, -0.8888889f, 0.6666667f, 0.6666667f, -0.6666667f, 0.6666667f, 0.6666667f, -0.44444445f, 0.6666667f, 0.6666667f, -0.22222222f, 0.6666667f, 0.6666667f, 0.0f, 0.6666667f, 0.6666667f, 0.22222222f, 0.6666667f, 0.6666667f, 0.44444445f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.6666667f, 0.8888889f, 0.6666667f, 0.6666667f, -0.8888889f, 0.8888889f, 0.6666667f, -0.6666667f, 0.8888889f, 0.6666667f, -0.44444445f, 0.8888889f, 0.6666667f, -0.22222222f, 0.8888889f, 0.6666667f, 0.0f, 0.8888889f, 0.6666667f, 0.22222222f, 0.8888889f, 0.6666667f, 0.44444445f, 0.8888889f, 0.6666667f, 0.6666667f, 0.8888889f, 0.6666667f, 0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, -0.8888889f, 0.8888889f, -0.6666667f, -0.8888889f, 0.8888889f, -0.44444445f, -0.8888889f, 0.8888889f, -0.22222222f, -0.8888889f, 0.8888889f, 0.0f, -0.8888889f, 0.8888889f, 0.22222222f, -0.8888889f, 0.8888889f, 0.44444445f, -0.8888889f, 0.8888889f, 0.6666667f, -0.8888889f, 0.8888889f, 0.8888889f, -0.8888889f, 0.8888889f, -0.8888889f, -0.6666667f, 0.8888889f, -0.6666667f, -0.6666667f, 0.8888889f, -0.44444445f, -0.6666667f, 0.8888889f, -0.22222222f, -0.6666667f, 0.8888889f, 0.0f, -0.6666667f, 0.8888889f, 0.22222222f, -0.6666667f, 0.8888889f, 0.44444445f, -0.6666667f, 0.8888889f, 0.6666667f, -0.6666667f, 0.8888889f, 0.8888889f, -0.6666667f, 0.8888889f, -0.8888889f, -0.44444445f, 0.8888889f, -0.6666667f, -0.44444445f, 0.8888889f, -0.44444445f, -0.44444445f, 0.8888889f, -0.22222222f, -0.44444445f, 0.8888889f, 0.0f, -0.44444445f, 0.8888889f, 0.22222222f, -0.44444445f, 0.8888889f, 0.44444445f, -0.44444445f, 0.8888889f, 0.6666667f, -0.44444445f, 0.8888889f, 0.8888889f, -0.44444445f, 0.8888889f, -0.8888889f, -0.22222222f, 0.8888889f, -0.6666667f, -0.22222222f, 0.8888889f, -0.44444445f, -0.22222222f, 0.8888889f, -0.22222222f, -0.22222222f, 0.8888889f, 0.0f, -0.22222222f, 0.8888889f, 0.22222222f, -0.22222222f, 0.8888889f, 0.44444445f, -0.22222222f, 0.8888889f, 0.6666667f, -0.22222222f, 0.8888889f, 0.8888889f, -0.22222222f, 0.8888889f, -0.8888889f, 0.0f, 0.8888889f, -0.6666667f, 0.0f, 0.8888889f, -0.44444445f, 0.0f, 0.8888889f, -0.22222222f, 0.0f, 0.8888889f, 0.0f, 0.0f, 0.8888889f, 0.22222222f, 0.0f, 0.8888889f, 0.44444445f, 0.0f, 0.8888889f, 0.6666667f, 0.0f, 0.8888889f, 0.8888889f, 0.0f, 0.8888889f, -0.8888889f, 0.22222222f, 0.8888889f, -0.6666667f, 0.22222222f, 0.8888889f, -0.44444445f, 0.22222222f, 0.8888889f, -0.22222222f, 0.22222222f, 0.8888889f, 0.0f, 0.22222222f, 0.8888889f, 0.22222222f, 0.22222222f, 0.8888889f, 0.44444445f, 0.22222222f, 0.8888889f, 0.6666667f, 0.22222222f, 0.8888889f, 0.8888889f, 0.22222222f, 0.8888889f, -0.8888889f, 0.44444445f, 0.8888889f, -0.6666667f, 0.44444445f, 0.8888889f, -0.44444445f, 0.44444445f, 0.8888889f, -0.22222222f, 0.44444445f, 0.8888889f, 0.0f, 0.44444445f, 0.8888889f, 0.22222222f, 0.44444445f, 0.8888889f, 0.44444445f, 0.44444445f, 0.8888889f, 0.6666667f, 0.44444445f, 0.8888889f, 0.8888889f, 0.44444445f, 0.8888889f, -0.8888889f, 0.6666667f, 0.8888889f, -0.6666667f, 0.6666667f, 0.8888889f, -0.44444445f, 0.6666667f, 0.8888889f, -0.22222222f, 0.6666667f, 0.8888889f, 0.0f, 0.6666667f, 0.8888889f, 0.22222222f, 0.6666667f, 0.8888889f, 0.44444445f, 0.6666667f, 0.8888889f, 0.6666667f, 0.6666667f, 0.8888889f, 0.8888889f, 0.6666667f, 0.8888889f, -0.8888889f, 0.8888889f, 0.8888889f, -0.6666667f, 0.8888889f, 0.8888889f, -0.44444445f, 0.8888889f, 0.8888889f, -0.22222222f, 0.8888889f, 0.8888889f, 0.0f, 0.8888889f, 0.8888889f, 0.22222222f, 0.8888889f, 0.8888889f, 0.44444445f, 0.8888889f, 0.8888889f, 0.6666667f, 0.8888889f, 0.8888889f, 0.8888889f, 0.8888889f, 0.8888889f};
        public static final int[] table_ab1_codelength = new int[]{0, 5, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        public static final float[][] table_ab1_groupingtables = new float[][]{null, grouping_5bits, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        public static final float[] table_ab1_factor = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.1035156E-5f, 3.0517578E-5f};
        public static final float[] table_ab1_c = new float[]{0.0f, 1.3333334f, 1.1428572f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f, 1.0000153f};
        public static final float[] table_ab1_d = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f, 3.051758E-5f};
        public static final float[][] table_ab234_groupingtables = new float[][]{null, grouping_5bits, grouping_7bits, null, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null};
        public static final int[] table_ab2_codelength = new int[]{0, 5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16};
        public static final float[] table_ab2_factor = new float[]{0.0f, 0.5f, 0.25f, 0.25f, 0.125f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 3.0517578E-5f};
        public static final float[] table_ab2_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.0000153f};
        public static final float[] table_ab2_d = new float[]{0.0f, 0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 3.051758E-5f};
        public static final int[] table_ab3_codelength = new int[]{0, 5, 7, 3, 10, 4, 5, 16};
        public static final float[] table_ab3_factor = new float[]{0.0f, 0.5f, 0.25f, 0.25f, 0.125f, 0.125f, 0.0625f, 3.0517578E-5f};
        public static final float[] table_ab3_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0000153f};
        public static final float[] table_ab3_d = new float[]{0.0f, 0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 3.051758E-5f};
        public static final int[] table_ab4_codelength = new int[]{0, 5, 7, 16};
        public static final float[] table_ab4_factor = new float[]{0.0f, 0.5f, 0.25f, 3.0517578E-5f};
        public static final float[] table_ab4_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.0000153f};
        public static final float[] table_ab4_d = new float[]{0.0f, 0.5f, 0.5f, 3.051758E-5f};
        public static final int[] table_cd_codelength = new int[]{0, 5, 7, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        public static final float[][] table_cd_groupingtables = new float[][]{null, grouping_5bits, grouping_7bits, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null, null};
        public static final float[] table_cd_factor = new float[]{0.0f, 0.5f, 0.25f, 0.125f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.1035156E-5f};
        public static final float[] table_cd_c = new float[]{0.0f, 1.3333334f, 1.6f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f};
        public static final float[] table_cd_d = new float[]{0.0f, 0.5f, 0.5f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f};
        protected int subbandNumber;
        protected int allocation;
        protected int scfsi;
        protected float scaleFactor1;
        protected float scaleFactor2;
        protected float scaleFactor3;
        protected int[] codeLength = new int[]{0};
        protected float[][] groupingTable = new float[2][];
        protected float[] factor = new float[]{0.0f};
        protected int groupNumber;
        protected int sampleNumber;
        protected float[] samples = new float[3];
        protected float[] c = new float[]{0.0f};
        protected float[] d = new float[]{0.0f};

        public SubbandLayer2(int subbandNumber) {
            this.subbandNumber = subbandNumber;
            this.sampleNumber = 0;
            this.groupNumber = 0;
        }

        protected int getAllocationLength(Header header) {
            if (header.version() == 1) {
                int channelBitrate = header.bitrateIndex();
                if (header.mode() != 3) {
                    channelBitrate = channelBitrate == 4 ? 1 : (channelBitrate -= 4);
                }
                if (channelBitrate == 1 || channelBitrate == 2) {
                    if (this.subbandNumber <= 1) {
                        return 4;
                    }
                    return 3;
                }
                if (this.subbandNumber <= 10) {
                    return 4;
                }
                if (this.subbandNumber <= 22) {
                    return 3;
                }
                return 2;
            }
            if (this.subbandNumber <= 3) {
                return 4;
            }
            if (this.subbandNumber <= 10) {
                return 3;
            }
            return 2;
        }

        protected void prepare_sample_reading(Header header, int allocation, int channel, float[] factor, int[] codeLength, float[] c, float[] d) {
            int channelBitrate = header.bitrateIndex();
            if (header.mode() != 3) {
                channelBitrate = channelBitrate == 4 ? 1 : (channelBitrate -= 4);
            }
            if (channelBitrate == 1 || channelBitrate == 2) {
                this.groupingTable[channel] = table_cd_groupingtables[allocation];
                factor[0] = table_cd_factor[allocation];
                codeLength[0] = table_cd_codelength[allocation];
                c[0] = table_cd_c[allocation];
                d[0] = table_cd_d[allocation];
            } else if (this.subbandNumber <= 2) {
                this.groupingTable[channel] = table_ab1_groupingtables[allocation];
                factor[0] = table_ab1_factor[allocation];
                codeLength[0] = table_ab1_codelength[allocation];
                c[0] = table_ab1_c[allocation];
                d[0] = table_ab1_d[allocation];
            } else {
                this.groupingTable[channel] = table_ab234_groupingtables[allocation];
                if (this.subbandNumber <= 10) {
                    factor[0] = table_ab2_factor[allocation];
                    codeLength[0] = table_ab2_codelength[allocation];
                    c[0] = table_ab2_c[allocation];
                    d[0] = table_ab2_d[allocation];
                } else if (this.subbandNumber <= 22) {
                    factor[0] = table_ab3_factor[allocation];
                    codeLength[0] = table_ab3_codelength[allocation];
                    c[0] = table_ab3_c[allocation];
                    d[0] = table_ab3_d[allocation];
                } else {
                    factor[0] = table_ab4_factor[allocation];
                    codeLength[0] = table_ab4_codelength[allocation];
                    c[0] = table_ab4_c[allocation];
                    d[0] = table_ab4_d[allocation];
                }
            }
        }

        @Override
        public void readAllocation(Bitstream stream, Header header, Crc16 crc) {
            int length = this.getAllocationLength(header);
            this.allocation = stream.getBits(length);
            if (crc != null) {
                crc.addBits(this.allocation, length);
            }
        }

        public void readScaleFactorSelection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.getBits(2);
                if (crc != null) {
                    crc.addBits(this.scfsi, 2);
                }
            }
        }

        @Override
        public void readScaleFactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                switch (this.scfsi) {
                    case 0: {
                        this.scaleFactor1 = scaleFactors[stream.getBits(6)];
                        this.scaleFactor2 = scaleFactors[stream.getBits(6)];
                        this.scaleFactor3 = scaleFactors[stream.getBits(6)];
                        break;
                    }
                    case 1: {
                        this.scaleFactor1 = this.scaleFactor2 = scaleFactors[stream.getBits(6)];
                        this.scaleFactor3 = scaleFactors[stream.getBits(6)];
                        break;
                    }
                    case 2: {
                        this.scaleFactor2 = this.scaleFactor3 = scaleFactors[stream.getBits(6)];
                        this.scaleFactor1 = this.scaleFactor3;
                        break;
                    }
                    case 3: {
                        this.scaleFactor1 = scaleFactors[stream.getBits(6)];
                        this.scaleFactor2 = this.scaleFactor3 = scaleFactors[stream.getBits(6)];
                    }
                }
                this.prepare_sample_reading(header, this.allocation, 0, this.factor, this.codeLength, this.c, this.d);
            }
        }

        @Override
        public boolean readSampleData(Bitstream stream) {
            if (this.allocation != 0) {
                if (this.groupingTable[0] != null) {
                    int samplecode = stream.getBits(this.codeLength[0]);
                    samplecode += samplecode << 1;
                    float[] target = this.samples;
                    float[] source = this.groupingTable[0];
                    int tmp = 0;
                    int temp = samplecode;
                    if (temp > source.length - 3) {
                        temp = source.length - 3;
                    }
                    target[tmp] = source[temp];
                    target[++tmp] = source[++temp];
                    target[++tmp] = source[++temp];
                } else {
                    this.samples[0] = (float)((double)((float)stream.getBits(this.codeLength[0]) * this.factor[0]) - 1.0);
                    this.samples[1] = (float)((double)((float)stream.getBits(this.codeLength[0]) * this.factor[0]) - 1.0);
                    this.samples[2] = (float)((double)((float)stream.getBits(this.codeLength[0]) * this.factor[0]) - 1.0);
                }
            }
            this.sampleNumber = 0;
            return ++this.groupNumber == 12;
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0 && channels != 2) {
                float sample = this.samples[this.sampleNumber];
                if (this.groupingTable[0] == null) {
                    sample = (sample + this.d[0]) * this.c[0];
                }
                sample = this.groupNumber <= 4 ? (sample *= this.scaleFactor1) : (this.groupNumber <= 8 ? (sample *= this.scaleFactor2) : (sample *= this.scaleFactor3));
                filter1.inputSample(sample, this.subbandNumber);
            }
            return ++this.sampleNumber == 3;
        }
    }

    static class SubbandLayer2Stereo
    extends SubbandLayer2 {
        protected int channel2Allocation;
        protected int channel2Scfsi;
        protected float channel2ScaleFactor1;
        protected float channel2ScaleFactor2;
        protected float channel2ScaleFactor3;
        protected int[] channel2CodeLength = new int[]{0};
        protected float[] channel2Factor = new float[]{0.0f};
        protected float[] channel2Samples;
        protected float[] channel2C = new float[]{0.0f};
        protected float[] channel2D = new float[]{0.0f};

        public SubbandLayer2Stereo(int subbandNumber) {
            super(subbandNumber);
            this.channel2Samples = new float[3];
        }

        @Override
        public void readAllocation(Bitstream stream, Header header, Crc16 crc) {
            int length = this.getAllocationLength(header);
            this.allocation = stream.getBits(length);
            this.channel2Allocation = stream.getBits(length);
            if (crc != null) {
                crc.addBits(this.allocation, length);
                crc.addBits(this.channel2Allocation, length);
            }
        }

        @Override
        public void readScaleFactorSelection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.getBits(2);
                if (crc != null) {
                    crc.addBits(this.scfsi, 2);
                }
            }
            if (this.channel2Allocation != 0) {
                this.channel2Scfsi = stream.getBits(2);
                if (crc != null) {
                    crc.addBits(this.channel2Scfsi, 2);
                }
            }
        }

        @Override
        public void readScaleFactor(Bitstream stream, Header header) {
            super.readScaleFactor(stream, header);
            if (this.channel2Allocation != 0) {
                switch (this.channel2Scfsi) {
                    case 0: {
                        this.channel2ScaleFactor1 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor2 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor3 = scaleFactors[stream.getBits(6)];
                        break;
                    }
                    case 1: {
                        this.channel2ScaleFactor1 = this.channel2ScaleFactor2 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor3 = scaleFactors[stream.getBits(6)];
                        break;
                    }
                    case 2: {
                        this.channel2ScaleFactor2 = this.channel2ScaleFactor3 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor1 = this.channel2ScaleFactor3;
                        break;
                    }
                    case 3: {
                        this.channel2ScaleFactor1 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor2 = this.channel2ScaleFactor3 = scaleFactors[stream.getBits(6)];
                    }
                }
                this.prepare_sample_reading(header, this.channel2Allocation, 1, this.channel2Factor, this.channel2CodeLength, this.channel2C, this.channel2D);
            }
        }

        @Override
        public boolean readSampleData(Bitstream stream) {
            boolean returnValue = super.readSampleData(stream);
            if (this.channel2Allocation != 0) {
                if (this.groupingTable[1] != null) {
                    int sampleCode = stream.getBits(this.channel2CodeLength[0]);
                    sampleCode += sampleCode << 1;
                    float[] target = this.channel2Samples;
                    float[] source = this.groupingTable[1];
                    int tmp = 0;
                    int temp = sampleCode;
                    target[tmp] = source[temp];
                    target[++tmp] = source[++temp];
                    target[++tmp] = source[++temp];
                } else {
                    this.channel2Samples[0] = (float)((double)((float)stream.getBits(this.channel2CodeLength[0]) * this.channel2Factor[0]) - 1.0);
                    this.channel2Samples[1] = (float)((double)((float)stream.getBits(this.channel2CodeLength[0]) * this.channel2Factor[0]) - 1.0);
                    this.channel2Samples[2] = (float)((double)((float)stream.getBits(this.channel2CodeLength[0]) * this.channel2Factor[0]) - 1.0);
                }
            }
            return returnValue;
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            boolean returnValue = super.put_next_sample(channels, filter1, filter2);
            if (this.channel2Allocation != 0 && channels != 1) {
                float sample = this.channel2Samples[this.sampleNumber - 1];
                if (this.groupingTable[1] == null) {
                    sample = (sample + this.channel2D[0]) * this.channel2C[0];
                }
                sample = this.groupNumber <= 4 ? (sample *= this.channel2ScaleFactor1) : (this.groupNumber <= 8 ? (sample *= this.channel2ScaleFactor2) : (sample *= this.channel2ScaleFactor3));
                if (channels == 0) {
                    filter2.inputSample(sample, this.subbandNumber);
                } else {
                    filter1.inputSample(sample, this.subbandNumber);
                }
            }
            return returnValue;
        }
    }

    static class SubbandLayer2IntensityStereo
    extends SubbandLayer2 {
        protected int channel2Scfsi;
        protected float channel2ScaleFactor1;
        protected float channel2ScaleFactor2;
        protected float channel2ScaleFactor3;

        public SubbandLayer2IntensityStereo(int subbandNumber) {
            super(subbandNumber);
        }

        @Override
        public void readAllocation(Bitstream stream, Header header, Crc16 crc) {
            super.readAllocation(stream, header, crc);
        }

        @Override
        public void readScaleFactorSelection(Bitstream stream, Crc16 crc) {
            if (this.allocation != 0) {
                this.scfsi = stream.getBits(2);
                this.channel2Scfsi = stream.getBits(2);
                if (crc != null) {
                    crc.addBits(this.scfsi, 2);
                    crc.addBits(this.channel2Scfsi, 2);
                }
            }
        }

        @Override
        public void readScaleFactor(Bitstream stream, Header header) {
            if (this.allocation != 0) {
                super.readScaleFactor(stream, header);
                switch (this.channel2Scfsi) {
                    case 0: {
                        this.channel2ScaleFactor1 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor2 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor3 = scaleFactors[stream.getBits(6)];
                        break;
                    }
                    case 1: {
                        this.channel2ScaleFactor1 = this.channel2ScaleFactor2 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor3 = scaleFactors[stream.getBits(6)];
                        break;
                    }
                    case 2: {
                        this.channel2ScaleFactor2 = this.channel2ScaleFactor3 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor1 = this.channel2ScaleFactor3;
                        break;
                    }
                    case 3: {
                        this.channel2ScaleFactor1 = scaleFactors[stream.getBits(6)];
                        this.channel2ScaleFactor2 = this.channel2ScaleFactor3 = scaleFactors[stream.getBits(6)];
                    }
                }
            }
        }

        @Override
        public boolean readSampleData(Bitstream stream) {
            return super.readSampleData(stream);
        }

        @Override
        public boolean put_next_sample(int channels, SynthesisFilter filter1, SynthesisFilter filter2) {
            if (this.allocation != 0) {
                float sample = this.samples[this.sampleNumber];
                if (this.groupingTable[0] == null) {
                    sample = (sample + this.d[0]) * this.c[0];
                }
                if (channels == 0) {
                    float sample2 = sample;
                    if (this.groupNumber <= 4) {
                        sample *= this.scaleFactor1;
                        sample2 *= this.channel2ScaleFactor1;
                    } else if (this.groupNumber <= 8) {
                        sample *= this.scaleFactor2;
                        sample2 *= this.channel2ScaleFactor2;
                    } else {
                        sample *= this.scaleFactor3;
                        sample2 *= this.channel2ScaleFactor3;
                    }
                    filter1.inputSample(sample, this.subbandNumber);
                    filter2.inputSample(sample2, this.subbandNumber);
                } else if (channels == 1) {
                    sample = this.groupNumber <= 4 ? (sample *= this.scaleFactor1) : (this.groupNumber <= 8 ? (sample *= this.scaleFactor2) : (sample *= this.scaleFactor3));
                    filter1.inputSample(sample, this.subbandNumber);
                } else {
                    sample = this.groupNumber <= 4 ? (sample *= this.channel2ScaleFactor1) : (this.groupNumber <= 8 ? (sample *= this.channel2ScaleFactor2) : (sample *= this.channel2ScaleFactor3));
                    filter1.inputSample(sample, this.subbandNumber);
                }
            }
            return ++this.sampleNumber == 3;
        }
    }
}

