/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm;

import celia.adwadg.ncm.command.MusicPlayerCommand;
import celia.adwadg.ncm.config.ModConfig;
import celia.adwadg.ncm.service.AudioService;
import celia.adwadg.ncm.service.AuthService;
import celia.adwadg.ncm.service.BossBarService;
import celia.adwadg.ncm.service.CommentService;
import celia.adwadg.ncm.service.DjService;
import celia.adwadg.ncm.service.EqualizerService;
import celia.adwadg.ncm.service.LyricsService;
import celia.adwadg.ncm.service.MusicService;
import celia.adwadg.ncm.service.MvService;
import celia.adwadg.ncm.service.PlaylistPlayerService;
import celia.adwadg.ncm.service.PlaylistService;
import celia.adwadg.ncm.service.UserService;
import celia.adwadg.ncm.util.HttpClientUtil;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="ncm")
public class NeteaseCloudMusicAPI {
    public static final String MOD_ID = "ncm";
    private static AuthService authService;
    private static MusicService musicService;
    private static UserService userService;
    private static PlaylistService playlistService;
    private static CommentService commentService;
    private static MvService mvService;
    private static DjService djService;
    private static AudioService audioService;
    private static BossBarService bossBarService;
    private static LyricsService lyricsService;
    private static PlaylistPlayerService playlistPlayerService;
    private static EqualizerService equalizerService;

    public NeteaseCloudMusicAPI() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC);
        modEventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.initializeServices();
    }

    private void setup(FMLCommonSetupEvent event) {
        System.out.println("NeteaseCloudMusicAPI mod is loading...");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        MusicPlayerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        HttpClientUtil.init();
        if (audioService != null) {
            audioService.init();
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        NeteaseCloudMusicAPI.shutdownFull();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (audioService != null) {
            audioService.init();
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlaylistPlayerService.clearPlaylist(player2);
            LyricsService.clearLyricsForPlayer(player2);
            EqualizerService.clearEQSettings(player2);
            BossBarService.hideBossBar(player2);
        }
    }

    private void initializeServices() {
        authService = new AuthService();
        musicService = new MusicService();
        userService = new UserService();
        playlistService = new PlaylistService();
        commentService = new CommentService();
        mvService = new MvService();
        djService = new DjService();
        audioService = new AudioService();
        bossBarService = new BossBarService();
        lyricsService = new LyricsService();
        playlistPlayerService = new PlaylistPlayerService();
        equalizerService = new EqualizerService();
    }

    public static AuthService getAuthService() {
        return authService;
    }

    public static MusicService getMusicService() {
        return musicService;
    }

    public static UserService getUserService() {
        return userService;
    }

    public static PlaylistService getPlaylistService() {
        return playlistService;
    }

    public static CommentService getCommentService() {
        return commentService;
    }

    public static MvService getMvService() {
        return mvService;
    }

    public static DjService getDjService() {
        return djService;
    }

    public static AudioService getAudioService() {
        return audioService;
    }

    public static BossBarService getBossBarService() {
        return bossBarService;
    }

    public static LyricsService getLyricsService() {
        return lyricsService;
    }

    public static PlaylistPlayerService getPlaylistPlayerService() {
        return playlistPlayerService;
    }

    public static EqualizerService getEqualizerService() {
        return equalizerService;
    }

    public static void shutdown() {
        try {
            if (audioService != null) {
                audioService.shutdown();
            }
            if (bossBarService != null) {
                bossBarService.resetSongInfo();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to shutdown: " + e.getMessage());
        }
    }

    public static void shutdownFull() {
        try {
            HttpClientUtil.close();
            NeteaseCloudMusicAPI.shutdown();
        }
        catch (Exception e) {
            System.err.println("Failed to shutdown fully: " + e.getMessage());
        }
    }
}

