/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.audio;

import audio.javazoom.jl.jl.decoder.JavaLayerException;
import audio.javazoom.jl.jl.player.JavaSoundAudioDevice;
import celia.adwadg.ncm.service.EqualizerService;
import net.minecraft.server.level.ServerPlayer;

public class EqualizerAudioDevice
extends JavaSoundAudioDevice {
    private float volume = 1.0f;
    private ServerPlayer player;

    public EqualizerAudioDevice(ServerPlayer player) {
        this.player = player;
    }

    public void setVolume(float volume) {
        this.volume = Math.max(0.0f, Math.min(1.0f, volume));
    }

    public float getVolume() {
        return this.volume;
    }

    @Override
    protected void writeImpl(short[] samples, int offs, int len) throws JavaLayerException {
        float[] eqSettings = EqualizerService.getEQSettings(this.player);
        boolean hasEQ = false;
        for (float gain : eqSettings) {
            if (!(Math.abs(gain) > 0.1f)) continue;
            hasEQ = true;
            break;
        }
        if (hasEQ) {
            System.out.println("Applying EQ settings: BASS=" + eqSettings[0] + "dB, LOW_MID=" + eqSettings[1] + "dB, MID=" + eqSettings[2] + "dB, HIGH_MID=" + eqSettings[3] + "dB, TREBLE=" + eqSettings[4] + "dB");
        }
        for (int i = offs; i < offs + len; ++i) {
            float sample = (float)samples[i] / 32768.0f;
            sample = this.applyEQ(sample, eqSettings);
            samples[i] = (short)((sample *= this.volume) * 32767.0f);
        }
        super.writeImpl(samples, offs, len);
    }

    private float applyEQ(float sample, float[] eqSettings) {
        float processed = sample;
        for (int i = 0; i < eqSettings.length; ++i) {
            float gainDB = eqSettings[i];
            if (!(Math.abs(gainDB) > 0.1f)) continue;
            float linearGain = (float)Math.pow(10.0, (double)gainDB / 20.0);
            processed *= linearGain;
        }
        return Math.max(-1.0f, Math.min(1.0f, processed));
    }
}

