/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.util.HttpClientUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DjService {
    public JsonObject getDjDetail(long rid) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rid", String.valueOf(rid));
        return HttpClientUtil.get("dj/detail", params);
    }

    public JsonObject getDjProgram(long rid) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rid", String.valueOf(rid));
        return HttpClientUtil.get("dj/program", params);
    }

    public JsonObject getDjProgramDetail(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("dj/program/detail", params);
    }

    public JsonObject getDjToplist(int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("dj/toplist", params);
    }

    public JsonObject getDjToplistPopular(int limit) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        return HttpClientUtil.get("dj/toplist/popular", params);
    }

    public JsonObject getDjToplistNewcomer(int limit) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        return HttpClientUtil.get("dj/toplist/newcomer", params);
    }

    public JsonObject getDjRecommend() throws IOException {
        return HttpClientUtil.get("dj/recommend", null);
    }

    public JsonObject getDjRecommendType(int type) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", String.valueOf(type));
        return HttpClientUtil.get("dj/recommend/type", params);
    }

    public JsonObject getDjCatelist() throws IOException {
        return HttpClientUtil.get("dj/catelist", null);
    }

    public JsonObject getDjRecommendByCategory(int cateId, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cateId", String.valueOf(cateId));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("dj/recommend", params);
    }

    public JsonObject getDjPaygift(int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("dj/paygift", params);
    }

    public JsonObject getDjToplistHours(int limit) throws IOException {
        Map<String, String> params = this.newHashMap();
        params.put("limit", String.valueOf(limit));
        return HttpClientUtil.get("dj/toplist/hours", params);
    }

    public JsonObject subscribeDj(long rid, boolean subscribe) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("rid", String.valueOf(rid));
        params.put("t", subscribe ? "1" : "0");
        return HttpClientUtil.get("dj/sub", params);
    }

    public JsonObject getDjSublist(int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("dj/sublist", params);
    }

    public JsonObject getDjProgramToplist(int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("dj/program/toplist", params);
    }

    public JsonObject getDjProgramToplistHours(int limit) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("limit", String.valueOf(limit));
        return HttpClientUtil.get("dj/program/toplist/hours", params);
    }

    private Map<String, String> newHashMap() {
        return new HashMap<String, String>();
    }
}

