/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CacheManager {
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private final long defaultTtl;

    public CacheManager() {
        this.defaultTtl = TimeUnit.MINUTES.toMillis(2L);
    }

    public CacheManager(long defaultTtl, TimeUnit unit) {
        this.defaultTtl = unit.toMillis(defaultTtl);
    }

    public void put(String key, JsonElement data) {
        this.put(key, data, this.defaultTtl, TimeUnit.MILLISECONDS);
    }

    public void put(String key, JsonElement data, long ttl, TimeUnit unit) {
        long expireTime = System.currentTimeMillis() + unit.toMillis(ttl);
        this.cache.put(key, new CacheEntry(data, expireTime));
    }

    public JsonElement get(String key) {
        CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            this.cache.remove(key);
            return null;
        }
        return entry.getData();
    }

    public boolean contains(String key) {
        CacheEntry entry = this.cache.get(key);
        if (entry == null) {
            return false;
        }
        if (entry.isExpired()) {
            this.cache.remove(key);
            return false;
        }
        return true;
    }

    public void remove(String key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public void clearExpired() {
        this.cache.entrySet().removeIf(entry -> ((CacheEntry)entry.getValue()).isExpired());
    }

    public int size() {
        this.clearExpired();
        return this.cache.size();
    }

    public boolean isEmpty() {
        this.clearExpired();
        return this.cache.isEmpty();
    }

    public static String generateCacheKey(String endpoint, Map<String, String> params) {
        StringBuilder keyBuilder = new StringBuilder(endpoint);
        if (params != null && !params.isEmpty()) {
            keyBuilder.append("?");
            params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> keyBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&"));
            keyBuilder.deleteCharAt(keyBuilder.length() - 1);
        }
        return keyBuilder.toString();
    }

    public static String generateCacheKey(String endpoint, JsonObject data) {
        StringBuilder keyBuilder = new StringBuilder(endpoint);
        if (data != null && !data.isJsonNull()) {
            keyBuilder.append("#");
            data.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> keyBuilder.append((String)entry.getKey()).append("=").append(((JsonElement)entry.getValue()).getAsString()).append("&"));
            keyBuilder.deleteCharAt(keyBuilder.length() - 1);
        }
        return keyBuilder.toString();
    }

    public static String generateTimestampedKey(String baseKey) {
        return baseKey + "_" + System.currentTimeMillis();
    }

    public static String generateNoCacheKey(String endpoint, Map<String, String> params) {
        return CacheManager.generateTimestampedKey(CacheManager.generateCacheKey(endpoint, params));
    }

    private static class CacheEntry {
        private final JsonElement data;
        private final long expireTime;

        public CacheEntry(JsonElement data, long expireTime) {
            this.data = data;
            this.expireTime = expireTime;
        }

        public JsonElement getData() {
            return this.data;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expireTime;
        }
    }
}

