/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LyricsParser {
    public static List<LyricLine> parseStandardLyrics(String lyrics) {
        ArrayList<LyricLine> result = new ArrayList<LyricLine>();
        if (lyrics == null || lyrics.trim().isEmpty()) {
            return result;
        }
        String[] lines = lyrics.split("\\r?\\n");
        Pattern pattern = Pattern.compile("\\[(\\d+):(\\d+)\\.(\\d+)\\]");
        for (String line : lines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            try {
                int minutes = Integer.parseInt(matcher.group(1));
                int seconds = Integer.parseInt(matcher.group(2));
                int milliseconds = Integer.parseInt(matcher.group(3));
                long totalMs = (long)minutes * 60000L + (long)seconds * 1000L + (long)milliseconds;
                String text = line.substring(matcher.end()).trim();
                if (text.isEmpty()) continue;
                result.add(new LyricLine(totalMs, text));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static List<WordLyric> parseWordLyrics(String yrcLyrics) {
        ArrayList<WordLyric> result = new ArrayList<WordLyric>();
        if (yrcLyrics == null || yrcLyrics.trim().isEmpty()) {
            return result;
        }
        Pattern pattern = Pattern.compile("\\[(\\d+),(\\d+)\\]\\((\\d+),(\\d+),(\\d+)\\)([^\\[]+)");
        Matcher matcher = pattern.matcher(yrcLyrics);
        while (matcher.find()) {
            try {
                long lineStartTime = Long.parseLong(matcher.group(1));
                long lineDuration = Long.parseLong(matcher.group(2));
                long wordStartTime = Long.parseLong(matcher.group(3));
                long wordDuration = Long.parseLong(matcher.group(4)) * 10L;
                String word = matcher.group(6).trim();
                if (word.isEmpty()) continue;
                result.add(new WordLyric(wordStartTime, wordDuration, word));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public static JsonObject parseYrcMetadata(String yrcLyrics) {
        String[] lines;
        JsonObject metadata = new JsonObject();
        if (yrcLyrics == null || yrcLyrics.trim().isEmpty()) {
            return metadata;
        }
        for (String line : lines = yrcLyrics.split("\\r?\\n")) {
            if (!line.startsWith("{") || !line.endsWith("}")) continue;
            try {
                JsonObject obj;
                JsonElement element = JsonParser.parseString((String)line);
                if (!element.isJsonObject() || !(obj = element.getAsJsonObject()).has("t") || !obj.has("c")) continue;
                metadata.add(String.valueOf(obj.get("t").getAsLong()), (JsonElement)obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return metadata;
    }

    public static String formatTime(long milliseconds) {
        long minutes = milliseconds / 60000L;
        long seconds = milliseconds % 60000L / 1000L;
        long ms = milliseconds % 1000L;
        return String.format("%02d:%02d.%03d", minutes, seconds, ms);
    }

    public static long parseTime(String timeString) {
        Pattern pattern = Pattern.compile("(\\d+):(\\d+)\\.(\\d+)");
        Matcher matcher = pattern.matcher(timeString);
        if (matcher.find()) {
            try {
                int minutes = Integer.parseInt(matcher.group(1));
                int seconds = Integer.parseInt(matcher.group(2));
                int milliseconds = Integer.parseInt(matcher.group(3));
                return (long)minutes * 60000L + (long)seconds * 1000L + (long)milliseconds;
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static String getCurrentLyric(List<LyricLine> lyrics, long currentTime) {
        if (lyrics == null || lyrics.isEmpty()) {
            return "";
        }
        for (int i = lyrics.size() - 1; i >= 0; --i) {
            if (currentTime < lyrics.get(i).getTime()) continue;
            return lyrics.get(i).getText();
        }
        return lyrics.get(0).getText();
    }

    public static List<String> getCurrentWords(List<WordLyric> wordLyrics, long currentTime) {
        ArrayList<String> currentWords = new ArrayList<String>();
        if (wordLyrics == null || wordLyrics.isEmpty()) {
            return currentWords;
        }
        for (WordLyric word : wordLyrics) {
            if (currentTime < word.getStartTime() || currentTime > word.getStartTime() + word.getDuration()) continue;
            currentWords.add(word.getWord());
        }
        return currentWords;
    }

    public static class LyricLine {
        private final long time;
        private final String text;

        public LyricLine(long time, String text) {
            this.time = time;
            this.text = text;
        }

        public long getTime() {
            return this.time;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "[" + this.time + "ms] " + this.text;
        }
    }

    public static class WordLyric {
        private final long startTime;
        private final long duration;
        private final String word;

        public WordLyric(long startTime, long duration, String word) {
            this.startTime = startTime;
            this.duration = duration;
            this.word = word;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getDuration() {
            return this.duration;
        }

        public String getWord() {
            return this.word;
        }

        public String toString() {
            return "[" + this.startTime + "-" + (this.startTime + this.duration) + "ms] " + this.word;
        }
    }
}

