/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.converter;

import audio.javazoom.jl.jl.converter.Converter;
import audio.javazoom.jl.jl.decoder.JavaLayerException;
import java.io.PrintWriter;
import java.util.logging.Logger;

public class jlc {
    private static final Logger logger = Logger.getLogger(jlc.class.getName());

    public static void main(String[] args) {
        int argc = args.length + 1;
        String[] argv = new String[argc];
        argv[0] = "jlc";
        System.arraycopy(args, 0, argv, 1, args.length);
        jlcArgs ma = new jlcArgs();
        if (!ma.processArgs(argv)) {
            System.exit(1);
        }
        Converter conv = new Converter();
        int detail = ma.verboseMode ? ma.verboseLevel : 0;
        Converter.PrintWriterProgressListener listener = new Converter.PrintWriterProgressListener(new PrintWriter(System.out, true), detail);
        try {
            conv.convert(ma.filename, ma.outputFilename, listener);
        }
        catch (JavaLayerException ex) {
            logger.warning("Conversion failure: " + String.valueOf(ex));
        }
        System.exit(0);
    }

    static class jlcArgs {
        public int whichC = 0;
        public int outputMode;
        public boolean useOwnScalefactor = false;
        public float scaleFactor = 32768.0f;
        public String outputFilename;
        public String filename;
        public boolean verboseMode = false;
        public int verboseLevel = 3;

        public boolean processArgs(String[] argv) {
            this.filename = null;
            int argc = argv.length;
            this.verboseMode = false;
            this.outputMode = 0;
            this.outputFilename = "";
            if (argc < 2 || argv[1].equals("-h")) {
                return this.usage();
            }
            for (int i = 1; i < argc; ++i) {
                logger.finer("Option = " + argv[i]);
                if (argv[i].charAt(0) == '-') {
                    if (argv[i].startsWith("-v")) {
                        this.verboseMode = true;
                        if (argv[i].length() > 2) {
                            try {
                                String level = argv[i].substring(2);
                                this.verboseLevel = Integer.parseInt(level);
                            }
                            catch (NumberFormatException ex) {
                                System.err.println("Invalid verbose level. Using default.");
                            }
                        }
                        System.out.println("Verbose Activated (level " + this.verboseLevel + ")");
                        continue;
                    }
                    if (argv[i].equals("-p")) {
                        if (++i == argc) {
                            System.out.println("Please specify an output filename after the -p option!");
                            System.exit(1);
                        }
                        this.outputFilename = argv[i];
                        continue;
                    }
                    return this.usage();
                }
                this.filename = argv[i];
                System.out.println("FileName = " + argv[i]);
                if (this.filename != null) continue;
                return this.usage();
            }
            if (this.filename == null) {
                return this.usage();
            }
            return true;
        }

        public boolean usage() {
            System.out.println("JavaLayer Converter :");
            System.out.println("  -v[x]         verbose mode. ");
            System.out.println("                default = 2");
            System.out.println("  -p name    output as a PCM wave file");
            System.out.println();
            System.out.println("  More info on http://www.javazoom.net");
            return false;
        }
    }
}

