/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.player;

import audio.javazoom.jl.jl.decoder.JavaLayerException;
import audio.javazoom.jl.jl.player.AudioDevice;
import audio.javazoom.jl.jl.player.FactoryRegistry;
import audio.javazoom.jl.jl.player.Player;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class jlp {
    private static final Logger logger = Logger.getLogger(jlp.class.getName());
    private String fFilename = null;
    private boolean remote = false;
    private AudioDevice audioDevice;
    private Player player;

    public static void main(String[] args) {
        int retval = 0;
        try {
            jlp player = jlp.createInstance(args);
            if (player != null) {
                player.play();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            ex.printStackTrace(System.err);
            retval = 1;
        }
        System.exit(retval);
    }

    public static jlp createInstance(String[] args) {
        jlp player = new jlp();
        if (!player.parseArgs(args)) {
            player = null;
        }
        return player;
    }

    private jlp() {
    }

    public jlp(String filename) {
        this.init(filename);
    }

    protected void init(String filename) {
        this.fFilename = filename;
    }

    protected boolean parseArgs(String[] args) {
        boolean parsed = false;
        if (args.length == 1) {
            this.init(args[0]);
            parsed = true;
            this.remote = false;
        } else if (args.length == 2) {
            if (!args[0].equals("-url")) {
                this.showUsage();
            } else {
                this.init(args[1]);
                parsed = true;
                this.remote = true;
            }
        } else {
            this.showUsage();
        }
        return parsed;
    }

    public void showUsage() {
        System.out.println("Usage: jlp [-url] <filename>");
        System.out.println();
        System.out.println(" e.g. : java audio.javazoom.jl.player.jl.jlp localfile.mp3");
        System.out.println("        java audio.javazoom.jl.player.jl.jlp -url http://www.server.com/remotefile.mp3");
        System.out.println("        java audio.javazoom.jl.player.jl.jlp -url http://www.shoutcastserver.com:8000");
    }

    public void play() throws JavaLayerException {
        try {
            System.out.println("playing " + this.fFilename + "...");
            InputStream in = this.remote ? this.getURLInputStream() : this.getInputStream();
            AudioDevice dev = this.setAudioDevice();
            logger.fine("audioDevice: " + String.valueOf(dev));
            this.player = new Player(in, dev);
            this.player.play();
        }
        catch (Exception ex) {
            throw new JavaLayerException("Problem playing file " + this.fFilename, ex);
        }
    }

    public void stop() {
        this.player.close();
    }

    protected InputStream getURLInputStream() throws Exception {
        URL url = new URL(this.fFilename);
        InputStream fin = url.openStream();
        BufferedInputStream bin = new BufferedInputStream(fin);
        return bin;
    }

    protected InputStream getInputStream() throws IOException {
        FileInputStream fin = new FileInputStream(this.fFilename);
        BufferedInputStream bin = new BufferedInputStream(fin);
        return bin;
    }

    public void setAudioDevice(AudioDevice audioDevice) {
        this.audioDevice = audioDevice;
    }

    public AudioDevice setAudioDevice() throws JavaLayerException {
        if (this.audioDevice == null) {
            this.audioDevice = FactoryRegistry.systemRegistry().createAudioDevice();
        }
        return this.audioDevice;
    }
}

