/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.util.HttpClientUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;

public class UserService {
    public JsonObject getUserDetail(long uid) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", String.valueOf(uid));
        return HttpClientUtil.get("user/detail", params);
    }

    public JsonObject getUserPlaylists(long uid, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", String.valueOf(uid));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("user/playlist", params);
    }

    public JsonObject getUserLikedSongs(long uid) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", String.valueOf(uid));
        return HttpClientUtil.get("likelist", params);
    }

    public JsonObject getUserFollows(long uid, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", String.valueOf(uid));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("user/follows", params);
    }

    public JsonObject getUserFollowers(long uid, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", String.valueOf(uid));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("user/followeds", params);
    }

    public JsonObject getUserEvents(long uid, int limit, int lasttime) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", String.valueOf(uid));
        params.put("limit", String.valueOf(limit));
        params.put("lasttime", String.valueOf(lasttime));
        return HttpClientUtil.get("user/event", params);
    }

    public JsonObject getUserRecord(long uid, int type) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", String.valueOf(uid));
        params.put("type", String.valueOf(type));
        return HttpClientUtil.get("user/record", params);
    }

    public JsonObject getUserDj(long uid, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", String.valueOf(uid));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("user/dj", params);
    }

    public JsonObject updateProfile(String gender, String birthday, String nickname, String signature) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("gender", gender);
        params.put("birthday", birthday);
        params.put("nickname", nickname);
        params.put("signature", signature);
        return HttpClientUtil.post("user/update", params, null);
    }

    public JsonObject updateAvatar(String imgData) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("imgData", imgData);
        return HttpClientUtil.post("avatar/upload", params, null);
    }

    public JsonObject followUser(long id, boolean follow) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("t", follow ? "1" : "0");
        return HttpClientUtil.get("follow", params);
    }

    public JsonObject getAccountInfo() throws IOException {
        return HttpClientUtil.get("user/account", null);
    }

    public JsonObject getLevelInfo() throws IOException {
        return HttpClientUtil.get("user/level", null);
    }

    public JsonObject getBindingInfo() throws IOException {
        return HttpClientUtil.get("user/binding", null);
    }

    public JsonObject getSubcount() throws IOException {
        return HttpClientUtil.get("user/subcount", null);
    }
}

