/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class MusicMetadataUtil {
    public static ArtistInfo parseArtist(JsonObject artistJson) {
        if (artistJson == null) {
            return null;
        }
        long id = artistJson.has("id") ? artistJson.get("id").getAsLong() : 0L;
        String name = artistJson.has("name") ? artistJson.get("name").getAsString() : "";
        String picUrl = artistJson.has("picUrl") ? artistJson.get("picUrl").getAsString() : "";
        ArrayList<String> alias = new ArrayList<String>();
        if (artistJson.has("alias")) {
            JsonArray aliasArray = artistJson.getAsJsonArray("alias");
            for (JsonElement element : aliasArray) {
                alias.add(element.getAsString());
            }
        }
        return new ArtistInfo(id, name, picUrl, alias);
    }

    public static AlbumInfo parseAlbum(JsonObject albumJson) {
        if (albumJson == null) {
            return null;
        }
        long id = albumJson.has("id") ? albumJson.get("id").getAsLong() : 0L;
        String name = albumJson.has("name") ? albumJson.get("name").getAsString() : "";
        String picUrl = albumJson.has("picUrl") ? albumJson.get("picUrl").getAsString() : "";
        long publishTime = albumJson.has("publishTime") ? albumJson.get("publishTime").getAsLong() : 0L;
        ArrayList<ArtistInfo> artists = new ArrayList<ArtistInfo>();
        if (albumJson.has("artists")) {
            JsonArray artistsArray = albumJson.getAsJsonArray("artists");
            for (JsonElement element : artistsArray) {
                artists.add(MusicMetadataUtil.parseArtist(element.getAsJsonObject()));
            }
        }
        return new AlbumInfo(id, name, picUrl, publishTime, artists);
    }

    public static SongInfo parseSong(JsonObject songJson) {
        if (songJson == null) {
            return null;
        }
        long id = songJson.has("id") ? songJson.get("id").getAsLong() : 0L;
        String name = songJson.has("name") ? songJson.get("name").getAsString() : "";
        long duration = songJson.has("dt") ? songJson.get("dt").getAsLong() : 0L;
        int fee = songJson.has("fee") ? songJson.get("fee").getAsInt() : 0;
        long mvId = songJson.has("mv") ? songJson.get("mv").getAsLong() : 0L;
        ArrayList<ArtistInfo> artists = new ArrayList<ArtistInfo>();
        if (songJson.has("ar")) {
            JsonArray artistsArray = songJson.getAsJsonArray("ar");
            for (JsonElement element : artistsArray) {
                artists.add(MusicMetadataUtil.parseArtist(element.getAsJsonObject()));
            }
        }
        AlbumInfo album = null;
        if (songJson.has("al")) {
            album = MusicMetadataUtil.parseAlbum(songJson.getAsJsonObject("al"));
        }
        ArrayList<String> alias = new ArrayList<String>();
        if (songJson.has("alia")) {
            JsonArray aliasArray = songJson.getAsJsonArray("alia");
            for (JsonElement element : aliasArray) {
                alias.add(element.getAsString());
            }
        }
        return new SongInfo(id, name, artists, album, duration, fee, mvId, alias);
    }

    public static List<SongInfo> parseSongList(JsonArray songsArray) {
        ArrayList<SongInfo> songs = new ArrayList<SongInfo>();
        if (songsArray == null) {
            return songs;
        }
        for (JsonElement element : songsArray) {
            songs.add(MusicMetadataUtil.parseSong(element.getAsJsonObject()));
        }
        return songs;
    }

    public static String getArtistsString(List<ArtistInfo> artists) {
        if (artists == null || artists.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < artists.size(); ++i) {
            if (i > 0) {
                sb.append(" / ");
            }
            sb.append(artists.get(i).getName());
        }
        return sb.toString();
    }

    public static String formatDuration(long milliseconds) {
        long minutes = milliseconds / 60000L;
        long seconds = milliseconds % 60000L / 1000L;
        return String.format("%d:%02d", minutes, seconds);
    }

    public static String getFeeType(int fee) {
        switch (fee) {
            case 0: {
                return "\u514d\u8d39";
            }
            case 1: {
                return "VIP\u6b4c\u66f2";
            }
            case 4: {
                return "\u8d2d\u4e70\u4e13\u8f91";
            }
            case 8: {
                return "\u4f1a\u5458\u4e13\u4eab";
            }
        }
        return "\u672a\u77e5(" + fee + ")";
    }

    public static boolean isCopyrighted(int fee) {
        return fee != 0;
    }

    public static String getSongInfoSummary(SongInfo song) {
        if (song == null) {
            return "";
        }
        return String.format("%s - %s (%s)", song.getName(), MusicMetadataUtil.getArtistsString(song.getArtists()), MusicMetadataUtil.formatDuration(song.getDuration()));
    }

    public static JsonObject createSearchQuery(String keywords, String type, int limit, int offset) {
        JsonObject query = new JsonObject();
        query.addProperty("keywords", keywords);
        query.addProperty("type", type);
        query.addProperty("limit", (Number)limit);
        query.addProperty("offset", (Number)offset);
        return query;
    }

    public static JsonObject createSongDetailQuery(String ids) {
        JsonObject query = new JsonObject();
        query.addProperty("ids", ids);
        return query;
    }

    public static class ArtistInfo {
        private final long id;
        private final String name;
        private final String picUrl;
        private final List<String> alias;

        public ArtistInfo(long id, String name, String picUrl, List<String> alias) {
            this.id = id;
            this.name = name;
            this.picUrl = picUrl;
            this.alias = alias;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPicUrl() {
            return this.picUrl;
        }

        public List<String> getAlias() {
            return this.alias;
        }

        public String toString() {
            return "ArtistInfo{id=" + this.id + ", name='" + this.name + "', picUrl='" + this.picUrl + "', alias=" + String.valueOf(this.alias) + "}";
        }
    }

    public static class AlbumInfo {
        private final long id;
        private final String name;
        private final String picUrl;
        private final long publishTime;
        private final List<ArtistInfo> artists;

        public AlbumInfo(long id, String name, String picUrl, long publishTime, List<ArtistInfo> artists) {
            this.id = id;
            this.name = name;
            this.picUrl = picUrl;
            this.publishTime = publishTime;
            this.artists = artists;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPicUrl() {
            return this.picUrl;
        }

        public long getPublishTime() {
            return this.publishTime;
        }

        public List<ArtistInfo> getArtists() {
            return this.artists;
        }

        public String toString() {
            return "AlbumInfo{id=" + this.id + ", name='" + this.name + "', picUrl='" + this.picUrl + "', publishTime=" + this.publishTime + ", artists=" + String.valueOf(this.artists) + "}";
        }
    }

    public static class SongInfo {
        private final long id;
        private final String name;
        private final List<ArtistInfo> artists;
        private final AlbumInfo album;
        private final long duration;
        private final int fee;
        private final long mvId;
        private final List<String> alias;

        public SongInfo(long id, String name, List<ArtistInfo> artists, AlbumInfo album, long duration, int fee, long mvId, List<String> alias) {
            this.id = id;
            this.name = name;
            this.artists = artists;
            this.album = album;
            this.duration = duration;
            this.fee = fee;
            this.mvId = mvId;
            this.alias = alias;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<ArtistInfo> getArtists() {
            return this.artists;
        }

        public AlbumInfo getAlbum() {
            return this.album;
        }

        public long getDuration() {
            return this.duration;
        }

        public int getFee() {
            return this.fee;
        }

        public long getMvId() {
            return this.mvId;
        }

        public List<String> getAlias() {
            return this.alias;
        }

        public String toString() {
            return "SongInfo{id=" + this.id + ", name='" + this.name + "', artists=" + String.valueOf(this.artists) + ", album=" + String.valueOf(this.album) + ", duration=" + this.duration + ", fee=" + this.fee + ", mvId=" + this.mvId + ", alias=" + String.valueOf(this.alias) + "}";
        }
    }
}

