/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.command;

import celia.adwadg.ncm.service.DebugService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class DebugCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ncmdebug").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"mode").executes(context -> DebugCommand.toggleDebugMode((CommandContext<CommandSourceStack>)context)))).then(Commands.literal((String)"test").then(((RequiredArgumentBuilder)Commands.argument((String)"api", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"param1", (ArgumentType)StringArgumentType.string()).executes(context -> DebugCommand.testApi((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"api"), StringArgumentType.getString((CommandContext)context, (String)"param1"))))).executes(context -> DebugCommand.testApi((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"api"), null))))).then(Commands.literal((String)"structure").then(Commands.argument((String)"api", (ArgumentType)StringArgumentType.string()).executes(context -> DebugCommand.showApiStructure((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"api")))))).then(Commands.literal((String)"example").then(Commands.argument((String)"api", (ArgumentType)StringArgumentType.string()).executes(context -> DebugCommand.showApiExample((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"api")))))).executes(context -> DebugCommand.showHelp((CommandContext<CommandSourceStack>)context)));
    }

    private static int toggleDebugMode(CommandContext<CommandSourceStack> context) {
        boolean newMode = !DebugService.isDebugMode();
        DebugService.setDebugMode(newMode);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a76\u8c03\u8bd5\u6a21\u5f0f " + (newMode ? "\u00a7a\u5df2\u542f\u7528" : "\u00a7c\u5df2\u7981\u7528"))));
        }
        return 1;
    }

    private static int testApi(CommandContext<CommandSourceStack> context, String api, String param) {
        block35: {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            try {
                JsonObject result;
                switch (api.toLowerCase()) {
                    case "search": {
                        result = DebugService.testSongSearch(param != null ? param : "\u5468\u6770\u4f26", 10);
                        break;
                    }
                    case "detail": {
                        long songId = param != null ? Long.parseLong(param) : 347230L;
                        result = DebugService.testSongDetail(songId);
                        break;
                    }
                    case "url": {
                        long urlSongId = param != null ? Long.parseLong(param) : 347230L;
                        result = DebugService.testSongUrl(urlSongId, 128000);
                        break;
                    }
                    case "lyric": {
                        long lyricSongId = param != null ? Long.parseLong(param) : 347230L;
                        result = DebugService.testLyric(lyricSongId);
                        break;
                    }
                    case "album": {
                        long albumId = param != null ? Long.parseLong(param) : 32311L;
                        result = DebugService.testAlbum(albumId);
                        break;
                    }
                    case "artist": {
                        long artistId = param != null ? Long.parseLong(param) : 6452L;
                        result = DebugService.testArtist(artistId);
                        break;
                    }
                    case "playlist": {
                        long playlistId = param != null ? Long.parseLong(param) : 156934569L;
                        result = DebugService.testPlaylistDetail(playlistId);
                        break;
                    }
                    case "user": {
                        long userId = param != null ? Long.parseLong(param) : 123456L;
                        result = DebugService.testUserDetail(userId);
                        break;
                    }
                    case "comments": {
                        long commentSongId = param != null ? Long.parseLong(param) : 347230L;
                        result = DebugService.testComments(commentSongId);
                        break;
                    }
                    case "mv": {
                        long mvId = param != null ? Long.parseLong(param) : 5436712L;
                        result = DebugService.testMvDetail(mvId);
                        break;
                    }
                    case "dj": {
                        long djId = param != null ? Long.parseLong(param) : 336355127L;
                        result = DebugService.testDjProgram(djId);
                        break;
                    }
                    case "login": {
                        result = DebugService.testLoginStatus();
                        break;
                    }
                    default: {
                        if (player != null) {
                            player.sendSystemMessage((Component)Component.literal((String)("\u00a7c\u672a\u77e5API\u7c7b\u578b: " + api)));
                            player.sendSystemMessage((Component)Component.literal((String)"\u00a76\u53ef\u7528\u7c7b\u578b: search, detail, url, lyric, album, artist, playlist, user, comments, mv, dj, login"));
                        }
                        return 0;
                    }
                }
                if (player != null) {
                    JsonObject resultObj;
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7aAPI\u6d4b\u8bd5\u6210\u529f!"));
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a76\u54cd\u5e94\u4ee3\u7801: " + result.get("code").getAsInt())));
                    if (result.has("result") && result.get("result").isJsonObject() && (resultObj = result.getAsJsonObject("result")).has("songCount")) {
                        player.sendSystemMessage((Component)Component.literal((String)("\u00a76\u6b4c\u66f2\u6570\u91cf: " + resultObj.get("songCount").getAsInt())));
                    }
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a77\u8be6\u7ec6\u7ed3\u679c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u65e5\u5fd7"));
                }
            }
            catch (IOException e) {
                if (player != null) {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7cAPI\u8c03\u7528\u5931\u8d25: " + e.getMessage())));
                }
            }
            catch (NumberFormatException e) {
                if (player == null) break block35;
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u9700\u8981\u6570\u5b57ID"));
            }
        }
        return 1;
    }

    private static int showApiStructure(CommandContext<CommandSourceStack> context, String api) {
        block32: {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
            try {
                JsonObject result;
                switch (api.toLowerCase()) {
                    case "search": {
                        result = DebugService.testSongSearch("\u6d4b\u8bd5", 1);
                        break;
                    }
                    case "detail": {
                        result = DebugService.testSongDetail(347230L);
                        break;
                    }
                    case "url": {
                        result = DebugService.testSongUrl(347230L, 128000);
                        break;
                    }
                    case "lyric": {
                        result = DebugService.testLyric(347230L);
                        break;
                    }
                    case "album": {
                        result = DebugService.testAlbum(32311L);
                        break;
                    }
                    case "artist": {
                        result = DebugService.testArtist(6452L);
                        break;
                    }
                    case "playlist": {
                        result = DebugService.testPlaylistDetail(156934569L);
                        break;
                    }
                    case "user": {
                        result = DebugService.testUserDetail(123456L);
                        break;
                    }
                    case "comments": {
                        result = DebugService.testComments(347230L);
                        break;
                    }
                    case "mv": {
                        result = DebugService.testMvDetail(5436712L);
                        break;
                    }
                    case "dj": {
                        result = DebugService.testDjProgram(336355127L);
                        break;
                    }
                    default: {
                        if (player != null) {
                            player.sendSystemMessage((Component)Component.literal((String)("\u00a7c\u672a\u77e5API\u7c7b\u578b: " + api)));
                            player.sendSystemMessage((Component)Component.literal((String)"\u00a76\u53ef\u7528\u7c7b\u578b: search, detail, url, lyric, album, artist, playlist, user, comments, mv, dj"));
                        }
                        return 0;
                    }
                }
                String structure = DebugService.analyzeJsonStructure((JsonElement)result, "");
                if (player != null) {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a76=== " + api + " API\u7ed3\u6784 ===")));
                    String[] lines = structure.split("\n");
                    for (int i = 0; i < Math.min(lines.length, 20); ++i) {
                        player.sendSystemMessage((Component)Component.literal((String)("\u00a77" + lines[i])));
                    }
                    if (lines.length > 20) {
                        player.sendSystemMessage((Component)Component.literal((String)"\u00a77... (\u66f4\u591a\u5185\u5bb9\u8bf7\u67e5\u770b\u63a7\u5236\u53f0)"));
                    }
                    System.out.println("API\u7ed3\u6784\u5206\u6790:\n" + structure);
                }
            }
            catch (IOException e) {
                if (player == null) break block32;
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7c\u83b7\u53d6API\u7ed3\u6784\u5931\u8d25: " + e.getMessage())));
            }
        }
        return 1;
    }

    private static int showApiExample(CommandContext<CommandSourceStack> context, String api) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        String example = DebugService.getApiStructureExample(api);
        if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a76=== " + api + " API\u793a\u4f8b ===")));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7a" + example)));
        }
        return 1;
    }

    private static int showHelp(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76=== NCMAPI\u8c03\u8bd5\u547d\u4ee4 ==="));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7a/ncmdebug mode \u00a77- \u5207\u6362\u8c03\u8bd5\u6a21\u5f0f"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7a/ncmdebug test <api> [\u53c2\u6570] \u00a77- \u6d4b\u8bd5API\u8c03\u7528"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7a/ncmdebug structure <api> \u00a77- \u663e\u793aAPI\u54cd\u5e94\u7ed3\u6784"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7a/ncmdebug example <api> \u00a77- \u663e\u793aAPI\u4f7f\u7528\u793a\u4f8b"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76\u53ef\u7528API: search, detail, url, lyric, album, artist, playlist, user, comments, mv, dj, login"));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u5f53\u524d\u8c03\u8bd5\u6a21\u5f0f: " + (DebugService.isDebugMode() ? "\u00a7a\u542f\u7528" : "\u00a7c\u7981\u7528"))));
        }
        return 1;
    }
}

