/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.example;

import celia.adwadg.ncm.NeteaseCloudMusicAPI;
import celia.adwadg.ncm.service.AudioService;
import com.google.gson.JsonObject;

public class AudioExample {
    public static void main(String[] args) {
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        AudioExample.playSongExample(audioService, 33894312L);
        AudioExample.controlPlaybackExample(audioService);
        AudioExample.getStatusExample(audioService);
    }

    private static void playSongExample(AudioService audioService, long songId) {
        try {
            System.out.println("\u6b63\u5728\u64ad\u653e\u6b4c\u66f2: " + songId);
            JsonObject result = audioService.playSong(songId, 128000);
            if (result.get("code").getAsInt() == 200) {
                System.out.println("\u64ad\u653e\u547d\u4ee4\u5df2\u53d1\u9001: " + result.get("message").getAsString());
            } else {
                System.out.println("\u64ad\u653e\u5931\u8d25: " + result.get("error").getAsString());
            }
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            System.err.println("\u64ad\u653e\u793a\u4f8b\u51fa\u9519: " + e.getMessage());
        }
    }

    private static void controlPlaybackExample(AudioService audioService) {
        try {
            JsonObject pauseResult = audioService.pause();
            System.out.println("\u6682\u505c\u7ed3\u679c: " + String.valueOf(pauseResult));
            Thread.sleep(2000L);
            JsonObject resumeResult = audioService.resume();
            System.out.println("\u6062\u590d\u7ed3\u679c: " + String.valueOf(resumeResult));
            Thread.sleep(3000L);
            JsonObject volumeResult = audioService.setVolume(0.7f);
            System.out.println("\u97f3\u91cf\u8bbe\u7f6e: " + String.valueOf(volumeResult));
            Thread.sleep(2000L);
            JsonObject stopResult = audioService.stop();
            System.out.println("\u505c\u6b62\u7ed3\u679c: " + String.valueOf(stopResult));
        }
        catch (Exception e) {
            System.err.println("\u63a7\u5236\u793a\u4f8b\u51fa\u9519: " + e.getMessage());
        }
    }

    private static void getStatusExample(AudioService audioService) {
        try {
            JsonObject statusResult = audioService.getPlaybackStatus();
            if (statusResult.get("code").getAsInt() == 200) {
                JsonObject data = statusResult.getAsJsonObject("data");
                System.out.println("\u64ad\u653e\u72b6\u6001:");
                System.out.println("  \u6b63\u5728\u64ad\u653e: " + data.get("isPlaying").getAsBoolean());
                System.out.println("  \u5f53\u524d\u6b4c\u66f2: " + data.get("currentSongId").getAsString());
                System.out.println("  \u97f3\u91cf: " + data.get("volume").getAsFloat());
                System.out.println("  \u6d3b\u8dc3\u64ad\u653e\u5668: " + data.get("activePlayers").getAsInt());
            }
        }
        catch (Exception e) {
            System.err.println("\u72b6\u6001\u67e5\u8be2\u51fa\u9519: " + e.getMessage());
        }
    }

    public static void playFromUrlExample(AudioService audioService, String audioUrl) {
        try {
            System.out.println("\u4eceURL\u64ad\u653e\u97f3\u9891: " + audioUrl);
            JsonObject result = audioService.playFromUrl(audioUrl, "custom_track", null, null);
            if (result.get("code").getAsInt() == 200) {
                System.out.println("URL\u64ad\u653e\u5f00\u59cb: " + result.get("message").getAsString());
            }
        }
        catch (Exception e) {
            System.err.println("URL\u64ad\u653e\u51fa\u9519: " + e.getMessage());
        }
    }
}

