/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.util.HttpClientUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;

public class AuthService {
    public JsonObject phoneLogin(String phone, String password) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("password", password);
        return HttpClientUtil.post("login/cellphone", params, null);
    }

    public JsonObject emailLogin(String email, String password) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        params.put("password", password);
        return HttpClientUtil.post("login", params, null);
    }

    public JsonObject qrCodeLogin() throws IOException {
        return HttpClientUtil.get("login/qr/key", null);
    }

    public JsonObject checkQrCodeStatus(String key) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", key);
        return HttpClientUtil.get("login/qr/check", params);
    }

    public JsonObject getLoginStatus() throws IOException {
        return HttpClientUtil.get("login/status", null);
    }

    public JsonObject logout() throws IOException {
        return HttpClientUtil.post("logout", null, null);
    }

    public JsonObject refreshLogin() throws IOException {
        return HttpClientUtil.get("login/refresh", null);
    }

    public JsonObject sendCaptcha(String phone) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        return HttpClientUtil.get("captcha/sent", params);
    }

    public JsonObject verifyCaptcha(String phone, String captcha) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("captcha", captcha);
        return HttpClientUtil.get("captcha/verify", params);
    }

    public JsonObject register(String phone, String password, String captcha, String nickname) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("password", password);
        params.put("captcha", captcha);
        params.put("nickname", nickname);
        return HttpClientUtil.post("register/cellphone", params, null);
    }

    public JsonObject checkPhoneExists(String phone) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        return HttpClientUtil.get("cellphone/existence/check", params);
    }

    public JsonObject activateProfile(String nickname) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("nickname", nickname);
        return HttpClientUtil.post("activate/init/profile", params, null);
    }
}

