/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.util.HttpClientUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;

public class PlaylistService {
    public JsonObject createPlaylist(String name, String privacy) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        params.put("privacy", privacy);
        return HttpClientUtil.get("playlist/create", params);
    }

    public JsonObject deletePlaylist(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("playlist/delete", params);
    }

    public JsonObject updatePlaylist(long id, String name, String desc) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("name", name);
        params.put("desc", desc);
        return HttpClientUtil.get("playlist/update", params);
    }

    public JsonObject addSongsToPlaylist(long pid, String tracks) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pid", String.valueOf(pid));
        params.put("tracks", tracks);
        return HttpClientUtil.get("playlist/tracks", params);
    }

    public JsonObject removeSongsFromPlaylist(long pid, String tracks) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pid", String.valueOf(pid));
        params.put("tracks", tracks);
        return HttpClientUtil.get("playlist/tracks/delete", params);
    }

    public JsonObject subscribePlaylist(long id, boolean subscribe) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("t", subscribe ? "1" : "2");
        return HttpClientUtil.get("playlist/subscribe", params);
    }

    public JsonObject getPlaylistSubscribers(long id, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("playlist/subscribers", params);
    }

    public JsonObject getPlaylistComments(long id, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("comment/playlist", params);
    }

    public JsonObject getHotPlaylists(String cat, int limit, int offset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cat", cat);
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return HttpClientUtil.get("top/playlist", params);
    }

    public JsonObject getPlaylistCategories() throws IOException {
        return HttpClientUtil.get("playlist/catlist", null);
    }

    public JsonObject getHighQualityPlaylists(String cat, int limit, int before) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cat", cat);
        params.put("limit", String.valueOf(limit));
        params.put("before", String.valueOf(before));
        return HttpClientUtil.get("top/playlist/highquality", params);
    }

    public JsonObject getRelatedPlaylists(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("related/playlist", params);
    }

    public JsonObject getPlaylistDynamicInfo(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("playlist/detail/dynamic", params);
    }

    public JsonObject getRecommendedPlaylists() throws IOException {
        return HttpClientUtil.get("recommend/resource", null);
    }

    public JsonObject getDailyRecommendedPlaylists() throws IOException {
        return HttpClientUtil.get("recommend/songs", null);
    }

    public JsonObject getPlaylistUpdateTime(long id) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return HttpClientUtil.get("playlist/update/time", params);
    }
}

