/*
 * Decompiled with CFR 0.152.
 */
package audio.javazoom.jl.jl.decoder;

import audio.javazoom.jl.jl.decoder.Bitstream;
import audio.javazoom.jl.jl.decoder.BitstreamException;
import audio.javazoom.jl.jl.decoder.Crc16;

public final class Header {
    public static final int[][] frequencies = new int[][]{{22050, 24000, 16000, 1}, {44100, 48000, 32000, 1}, {11025, 12000, 8000, 1}};
    public static final int MPEG2_LSF = 0;
    public static final int MPEG25_LSF = 2;
    public static final int MPEG1 = 1;
    public static final int STEREO = 0;
    public static final int JOINT_STEREO = 1;
    public static final int DUAL_CHANNEL = 2;
    public static final int SINGLE_CHANNEL = 3;
    public static final int FOURTYFOUR_POINT_ONE = 0;
    public static final int FOURTYEIGHT = 1;
    public static final int THIRTYTWO = 2;
    private int hLayer;
    private int h_protection_bit;
    private int hBitrateIndex;
    private int h_padding_bit;
    private int h_mode_extension;
    private int hVersion;
    private int h_mode;
    private int h_sample_frequency;
    private int hNumberOfSubbands;
    private int hIntensityStereoBound;
    private boolean h_copyright;
    private boolean h_original;
    private static final double[] h_vbr_time_per_frame = new double[]{-1.0, 384.0, 1152.0, 1152.0};
    private boolean h_vbr;
    private int h_vbr_frames;
    private int h_vbr_scale;
    private int h_vbr_bytes;
    private byte[] h_vbr_toc;
    private byte syncmode = Bitstream.INITIAL_SYNC;
    private Crc16 crc;
    public short checksum;
    public int framesize;
    public int nSlots;
    private int _headerstring = -1;
    public static final int[][][] bitrates = new int[][][]{new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}, new int[][]{{0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}}, new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}};
    public static final String[][][] bitrate_str = new String[][][]{{{"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "176 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}}, {{"free format", "32 kbit/s", "64 kbit/s", "96 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "288 kbit/s", "320 kbit/s", "352 kbit/s", "384 kbit/s", "416 kbit/s", "448 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "384 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "forbidden"}}, {{"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "176 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}}};

    Header() {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append("Layer ");
        buffer.append(this.layerString());
        buffer.append(" frame ");
        buffer.append(this.modeString());
        buffer.append(' ');
        buffer.append(this.versionString());
        if (!this.checksums()) {
            buffer.append(" no");
        }
        buffer.append(" checksums");
        buffer.append(' ');
        buffer.append(this.sampleFrequencyString());
        buffer.append(',');
        buffer.append(' ');
        buffer.append(this.bitrateString());
        return buffer.toString();
    }

    void read_header(Bitstream stream, Crc16[] crcp) throws BitstreamException {
        int headerString;
        boolean sync = false;
        do {
            this._headerstring = headerString = stream.syncHeader(this.syncmode);
            if (this.syncmode == Bitstream.INITIAL_SYNC) {
                this.hVersion = headerString >>> 19 & 1;
                if ((headerString >>> 20 & 1) == 0) {
                    if (this.hVersion == 0) {
                        this.hVersion = 2;
                    } else {
                        throw stream.newBitstreamException(256);
                    }
                }
                if ((this.h_sample_frequency = headerString >>> 10 & 3) == 3) {
                    throw stream.newBitstreamException(256);
                }
            }
            this.hLayer = 4 - (headerString >>> 17) & 3;
            this.h_protection_bit = headerString >>> 16 & 1;
            this.hBitrateIndex = headerString >>> 12 & 0xF;
            this.h_padding_bit = headerString >>> 9 & 1;
            this.h_mode = headerString >>> 6 & 3;
            this.h_mode_extension = headerString >>> 4 & 3;
            this.hIntensityStereoBound = this.h_mode == 1 ? (this.h_mode_extension << 2) + 4 : 0;
            if ((headerString >>> 3 & 1) == 1) {
                this.h_copyright = true;
            }
            if ((headerString >>> 2 & 1) == 1) {
                this.h_original = true;
            }
            if (this.hLayer == 1) {
                this.hNumberOfSubbands = 32;
            } else {
                int channelBitrate = this.hBitrateIndex;
                if (this.h_mode != 3) {
                    channelBitrate = channelBitrate == 4 ? 1 : (channelBitrate -= 4);
                }
                this.hNumberOfSubbands = channelBitrate == 1 || channelBitrate == 2 ? (this.h_sample_frequency == 2 ? 12 : 8) : (this.h_sample_frequency == 1 || channelBitrate >= 3 && channelBitrate <= 5 ? 27 : 30);
            }
            if (this.hIntensityStereoBound > this.hNumberOfSubbands) {
                this.hIntensityStereoBound = this.hNumberOfSubbands;
            }
            this.calculateFrameSize();
            int framesizeloaded = stream.readFrameData(this.framesize);
            if (this.framesize >= 0 && framesizeloaded != this.framesize) {
                throw stream.newBitstreamException(261);
            }
            if (stream.isSyncCurrentPosition(this.syncmode)) {
                if (this.syncmode == Bitstream.INITIAL_SYNC) {
                    this.syncmode = Bitstream.STRICT_SYNC;
                    stream.setSyncWord(headerString & 0xFFF80CC0);
                }
                sync = true;
                continue;
            }
            stream.unreadFrame();
        } while (!sync);
        stream.parseFrame();
        if (this.h_protection_bit == 0) {
            this.checksum = (short)stream.getBits(16);
            if (this.crc == null) {
                this.crc = new Crc16();
            }
            this.crc.addBits(headerString, 16);
            crcp[0] = this.crc;
        } else {
            crcp[0] = null;
        }
        if (this.h_sample_frequency == 0) {
            // empty if block
        }
    }

    void parseVBR(byte[] firstFrame) throws BitstreamException {
        String xing = "Xing";
        byte[] tmp = new byte[4];
        int offset = 0;
        offset = this.hVersion == 1 ? (this.h_mode == 3 ? 17 : 32) : (this.h_mode == 3 ? 9 : 17);
        try {
            System.arraycopy(firstFrame, offset, tmp, 0, 4);
            if (xing.equals(new String(tmp))) {
                this.h_vbr = true;
                this.h_vbr_frames = -1;
                this.h_vbr_bytes = -1;
                this.h_vbr_scale = -1;
                this.h_vbr_toc = new byte[100];
                int length = 4;
                byte[] flags = new byte[4];
                System.arraycopy(firstFrame, offset + length, flags, 0, flags.length);
                length += flags.length;
                if ((flags[3] & 1) != 0) {
                    System.arraycopy(firstFrame, offset + length, tmp, 0, tmp.length);
                    this.h_vbr_frames = tmp[0] << 24 & 0xFF000000 | tmp[1] << 16 & 0xFF0000 | tmp[2] << 8 & 0xFF00 | tmp[3] & 0xFF;
                    length += 4;
                }
                if ((flags[3] & 2) != 0) {
                    System.arraycopy(firstFrame, offset + length, tmp, 0, tmp.length);
                    this.h_vbr_bytes = tmp[0] << 24 & 0xFF000000 | tmp[1] << 16 & 0xFF0000 | tmp[2] << 8 & 0xFF00 | tmp[3] & 0xFF;
                    length += 4;
                }
                if ((flags[3] & 4) != 0) {
                    System.arraycopy(firstFrame, offset + length, this.h_vbr_toc, 0, this.h_vbr_toc.length);
                    length += this.h_vbr_toc.length;
                }
                if ((flags[3] & 8) != 0) {
                    System.arraycopy(firstFrame, offset + length, tmp, 0, tmp.length);
                    this.h_vbr_scale = tmp[0] << 24 & 0xFF000000 | tmp[1] << 16 & 0xFF0000 | tmp[2] << 8 & 0xFF00 | tmp[3] & 0xFF;
                    length += 4;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BitstreamException("XingVBRHeader Corrupted", (Throwable)e);
        }
        String vbri = "VBRI";
        offset = 32;
        try {
            System.arraycopy(firstFrame, offset, tmp, 0, 4);
            if (vbri.equals(new String(tmp))) {
                this.h_vbr = true;
                this.h_vbr_frames = -1;
                this.h_vbr_bytes = -1;
                this.h_vbr_scale = -1;
                this.h_vbr_toc = new byte[100];
                int length = 10;
                System.arraycopy(firstFrame, offset + length, tmp, 0, tmp.length);
                this.h_vbr_bytes = tmp[0] << 24 & 0xFF000000 | tmp[1] << 16 & 0xFF0000 | tmp[2] << 8 & 0xFF00 | tmp[3] & 0xFF;
                System.arraycopy(firstFrame, offset + (length += 4), tmp, 0, tmp.length);
                this.h_vbr_frames = tmp[0] << 24 & 0xFF000000 | tmp[1] << 16 & 0xFF0000 | tmp[2] << 8 & 0xFF00 | tmp[3] & 0xFF;
                length += 4;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BitstreamException("VBRIVBRHeader Corrupted", (Throwable)e);
        }
    }

    public int version() {
        return this.hVersion;
    }

    public int layer() {
        return this.hLayer;
    }

    public int bitrateIndex() {
        return this.hBitrateIndex;
    }

    public int sampleFrequency() {
        return this.h_sample_frequency;
    }

    public int frequency() {
        return frequencies[this.hVersion][this.h_sample_frequency];
    }

    public int mode() {
        return this.h_mode;
    }

    public boolean checksums() {
        return this.h_protection_bit == 0;
    }

    public boolean copyright() {
        return this.h_copyright;
    }

    public boolean original() {
        return this.h_original;
    }

    public boolean vbr() {
        return this.h_vbr;
    }

    public int vbrScale() {
        return this.h_vbr_scale;
    }

    public byte[] vbrToc() {
        return this.h_vbr_toc;
    }

    public boolean checksumOk() {
        return this.checksum == this.crc.checksum();
    }

    public boolean padding() {
        return this.h_padding_bit != 0;
    }

    public int slots() {
        return this.nSlots;
    }

    public int modeExtension() {
        return this.h_mode_extension;
    }

    public int calculateFrameSize() {
        if (this.hLayer == 1) {
            this.framesize = 12 * bitrates[this.hVersion][0][this.hBitrateIndex] / frequencies[this.hVersion][this.h_sample_frequency];
            if (this.h_padding_bit != 0) {
                ++this.framesize;
            }
            this.framesize <<= 2;
            this.nSlots = 0;
        } else {
            this.framesize = 144 * bitrates[this.hVersion][this.hLayer - 1][this.hBitrateIndex] / frequencies[this.hVersion][this.h_sample_frequency];
            if (this.hVersion == 0 || this.hVersion == 2) {
                this.framesize >>= 1;
            }
            if (this.h_padding_bit != 0) {
                ++this.framesize;
            }
            this.nSlots = this.hLayer == 3 ? (this.hVersion == 1 ? this.framesize - (this.h_mode == 3 ? 17 : 32) - (this.h_protection_bit != 0 ? 0 : 2) - 4 : this.framesize - (this.h_mode == 3 ? 9 : 17) - (this.h_protection_bit != 0 ? 0 : 2) - 4) : 0;
        }
        this.framesize -= 4;
        return this.framesize;
    }

    public int maxNumberOfFrames(int streamSize) {
        if (this.h_vbr) {
            return this.h_vbr_frames;
        }
        if (this.framesize + 4 - this.h_padding_bit == 0) {
            return 0;
        }
        return streamSize / (this.framesize + 4 - this.h_padding_bit);
    }

    public int minNumberOfFrames(int streamSize) {
        if (this.h_vbr) {
            return this.h_vbr_frames;
        }
        if (this.framesize + 5 - this.h_padding_bit == 0) {
            return 0;
        }
        return streamSize / (this.framesize + 5 - this.h_padding_bit);
    }

    public float msPerFrame() {
        if (this.h_vbr) {
            double tpf = h_vbr_time_per_frame[this.layer()] / (double)this.frequency();
            if (this.hVersion == 0 || this.hVersion == 2) {
                tpf /= 2.0;
            }
            return (float)(tpf * 1000.0);
        }
        float[][] ms_per_frame_array = new float[][]{{8.707483f, 8.0f, 12.0f}, {26.12245f, 24.0f, 36.0f}, {26.12245f, 24.0f, 36.0f}};
        return ms_per_frame_array[this.hLayer - 1][this.h_sample_frequency];
    }

    public float totalMs(int streamSize) {
        return (float)this.maxNumberOfFrames(streamSize) * this.msPerFrame();
    }

    public int getSyncHeader() {
        return this._headerstring;
    }

    public String layerString() {
        return switch (this.hLayer) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            default -> null;
        };
    }

    public String bitrateString() {
        if (this.h_vbr) {
            return this.bitrate() / 1000 + " kb/s";
        }
        return bitrate_str[this.hVersion][this.hLayer - 1][this.hBitrateIndex];
    }

    public int bitrate() {
        if (this.h_vbr) {
            return (int)((float)(this.h_vbr_bytes * 8) / (this.msPerFrame() * (float)this.h_vbr_frames)) * 1000;
        }
        return bitrates[this.hVersion][this.hLayer - 1][this.hBitrateIndex];
    }

    public int bitrateInstant() {
        return bitrates[this.hVersion][this.hLayer - 1][this.hBitrateIndex];
    }

    public String sampleFrequencyString() {
        switch (this.h_sample_frequency) {
            case 2: {
                if (this.hVersion == 1) {
                    return "32 kHz";
                }
                if (this.hVersion == 0) {
                    return "16 kHz";
                }
                return "8 kHz";
            }
            case 0: {
                if (this.hVersion == 1) {
                    return "44.1 kHz";
                }
                if (this.hVersion == 0) {
                    return "22.05 kHz";
                }
                return "11.025 kHz";
            }
            case 1: {
                if (this.hVersion == 1) {
                    return "48 kHz";
                }
                if (this.hVersion == 0) {
                    return "24 kHz";
                }
                return "12 kHz";
            }
        }
        return null;
    }

    public String modeString() {
        return switch (this.h_mode) {
            case 0 -> "Stereo";
            case 1 -> "Joint stereo";
            case 2 -> "Dual channel";
            case 3 -> "Single channel";
            default -> null;
        };
    }

    public String versionString() {
        return switch (this.hVersion) {
            case 1 -> "MPEG-1";
            case 0 -> "MPEG-2 LSF";
            case 2 -> "MPEG-2.5 LSF";
            default -> null;
        };
    }

    public int numberOfSubbands() {
        return this.hNumberOfSubbands;
    }

    public int intensityStereoBound() {
        return this.hIntensityStereoBound;
    }
}

