/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.audio;

import audio.javazoom.jl.jl.decoder.JavaLayerException;
import audio.javazoom.jl.jl.player.JavaSoundAudioDevice;
import celia.adwadg.ncm.service.EqualizerService;
import net.minecraft.server.level.ServerPlayer;

public class UniversalAudioDevice
extends JavaSoundAudioDevice {
    private float volume = 1.0f;
    private ServerPlayer player;
    private boolean hasEqualizer;

    public UniversalAudioDevice(ServerPlayer player) {
        this.player = player;
        this.hasEqualizer = player != null;
    }

    public void setVolume(float volume) {
        this.volume = Math.max(0.0f, Math.min(1.0f, volume));
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean hasEqualizer() {
        return this.hasEqualizer;
    }

    @Override
    protected void writeImpl(short[] samples, int offs, int len) throws JavaLayerException {
        if (this.hasEqualizer) {
            float[] eqSettings = EqualizerService.getEQSettings(this.player);
            for (int i = offs; i < offs + len; ++i) {
                float sample = (float)samples[i] / 32768.0f;
                sample = this.applyEQ(sample, eqSettings);
                samples[i] = (short)((sample *= this.volume) * 32767.0f);
            }
        } else if (this.volume != 1.0f) {
            for (int i = offs; i < offs + len; ++i) {
                samples[i] = (short)((float)samples[i] * this.volume);
            }
        }
        super.writeImpl(samples, offs, len);
    }

    private float applyEQ(float sample, float[] eqSettings) {
        float processed = sample;
        for (int i = 0; i < eqSettings.length; ++i) {
            float gainDB = eqSettings[i];
            if (!(Math.abs(gainDB) > 0.1f)) continue;
            float linearGain = (float)Math.pow(10.0, (double)gainDB / 20.0);
            processed *= linearGain;
        }
        return Math.max(-1.0f, Math.min(1.0f, processed));
    }
}

