/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.command;

import celia.adwadg.ncm.NeteaseCloudMusicAPI;
import celia.adwadg.ncm.service.AuthService;
import celia.adwadg.ncm.util.AsyncHttpClientUtil;
import celia.adwadg.ncm.util.CookieManager;
import celia.adwadg.ncm.util.QrCodeWebDisplay;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LoginCommand {
    private static final Map<String, String> qrCodeKeys = new HashMap<String, String>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nclogin").then(Commands.m_82127_((String)"qr").executes(LoginCommand::qrLogin))).then(Commands.m_82127_((String)"status").executes(LoginCommand::loginStatus))).then(Commands.m_82127_((String)"logout").executes(LoginCommand::logout))).then(Commands.m_82127_((String)"phone").then(Commands.m_82129_((String)"phone", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).executes(LoginCommand::phoneLogin)))));
    }

    private static int qrLogin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        AuthService authService = NeteaseCloudMusicAPI.getAuthService();
        AsyncHttpClientUtil.executeOnMainThread(() -> player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6b63\u5728\u751f\u6210\u767b\u5f55\u4e8c\u7ef4\u7801...")));
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return authService.qrCodeLogin();
            }
            catch (IOException e) {
                throw new RuntimeException("\u83b7\u53d6\u4e8c\u7ef4\u7801\u5931\u8d25: " + e.getMessage(), e);
            }
        }).thenAccept(qrResult -> {
            try {
                if (qrResult.has("code") && qrResult.get("code").getAsInt() == 200 && qrResult.has("data")) {
                    JsonObject data = qrResult.getAsJsonObject("data");
                    if (data.has("key") && data.has("qrimg")) {
                        String qrKey = data.get("key").getAsString();
                        String qrBase64 = data.get("qrimg").getAsString();
                        qrCodeKeys.put(player.m_20149_(), qrKey);
                        AsyncHttpClientUtil.executeOnMainThread(() -> {
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u4e8c\u7ef4\u7801\u751f\u6210\u6210\u529f\uff01\u8bf7\u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50APP\u626b\u63cf\u4ee5\u4e0b\u4e8c\u7ef4\u7801\uff1a"));
                            LoginCommand.sendQrCodeToChat(player, qrBase64);
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u4e8c\u7ef4\u7801\u6709\u6548\u65f6\u95f4\uff1a5\u5206\u949f"));
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u4f7f\u7528 \u00a76/nclogin status \u00a77\u68c0\u67e5\u767b\u5f55\u72b6\u6001"));
                        });
                        LoginCommand.startQrCodeStatusCheck(player, qrKey);
                    } else {
                        AsyncHttpClientUtil.executeOnMainThread(() -> {
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u4e8c\u7ef4\u7801\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u751f\u6210\u5931\u8d25\uff01"));
                            System.out.println("QR code data missing fields: " + qrResult);
                        });
                    }
                } else {
                    AsyncHttpClientUtil.executeOnMainThread(() -> {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25\uff01"));
                        if (qrResult.has("message")) {
                            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u9519\u8bef\u4fe1\u606f: " + qrResult.get("message").getAsString())));
                        }
                        System.out.println("QR code API error: " + qrResult);
                    });
                }
            }
            catch (Exception e) {
                AsyncHttpClientUtil.executeOnMainThread(() -> {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u5904\u7406\u4e8c\u7ef4\u7801\u54cd\u5e94\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage())));
                    System.out.println("Error processing QR response: " + e.getMessage());
                    e.printStackTrace();
                });
            }
        })).exceptionally(e -> {
            AsyncHttpClientUtil.executeOnMainThread(() -> player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u83b7\u53d6\u4e8c\u7ef4\u7801\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()))));
            return null;
        });
        return 1;
    }

    private static void sendQrCodeToChat(ServerPlayer player, String qrBase64) {
        try {
            String qrKey = qrCodeKeys.get(player.m_20149_());
            if (qrKey == null) {
                throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u4e8c\u7ef4\u7801key");
            }
            QrCodeWebDisplay.displayQrCodeInBrowser(player, qrBase64, qrKey);
        }
        catch (Exception e) {
            LoginCommand.fallbackQrCodeDisplay(player, qrBase64, e);
        }
    }

    private static void fallbackQrCodeDisplay(ServerPlayer player, String qrBase64, Exception originalError) {
        try {
            block19: {
                block18: {
                    if (qrBase64.contains("qrurl") && qrBase64.contains("code") && qrBase64.contains("data")) {
                        try {
                            JsonObject json = new JsonParser().parse(qrBase64).getAsJsonObject();
                            if (!json.has("data") || !json.getAsJsonObject("data").has("qrurl")) break block18;
                            String qrUrl = json.getAsJsonObject("data").get("qrurl").getAsString();
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2705 \u4e8c\u7ef4\u7801\u5df2\u751f\u6210\uff01"));
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7b\u8bf7\u8bbf\u95ee\u4ee5\u4e0b\u94fe\u63a5\u626b\u63cf\u4e8c\u7ef4\u7801\uff1a"));
                            MutableComponent clickableLink = Component.m_237113_((String)("\u00a7b\u00a7n" + qrUrl)).m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, qrUrl)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u70b9\u51fb\u6253\u5f00\u4e8c\u7ef4\u7801\u9875\u9762"))));
                            player.m_213846_((Component)clickableLink);
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a771. \u70b9\u51fb\u4e0a\u65b9\u94fe\u63a5\u6216\u590d\u5236\u5230\u6d4f\u89c8\u5668"));
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a772. \u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50APP\u626b\u63cf\u9875\u9762\u4e8c\u7ef4\u7801"));
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a773. \u5728APP\u4e2d\u786e\u8ba4\u767b\u5f55"));
                            try {
                                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                                    Desktop.getDesktop().browse(new URI(qrUrl));
                                }
                            }
                            catch (Exception browserError) {
                                System.out.println("\u81ea\u52a8\u6253\u5f00\u6d4f\u89c8\u5668\u5931\u8d25: " + browserError.getMessage());
                            }
                            return;
                        }
                        catch (Exception e) {
                            System.out.println("JSON\u89e3\u6790\u5931\u8d25: " + e.getMessage());
                        }
                    }
                }
                try {
                    String decodedUrl;
                    String pureBase64 = qrBase64;
                    if (qrBase64.contains(",")) {
                        pureBase64 = qrBase64.substring(qrBase64.indexOf(",") + 1);
                    }
                    if (!(decodedUrl = new String(Base64.getDecoder().decode(pureBase64))).startsWith("http")) break block19;
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2705 \u4e8c\u7ef4\u7801\u94fe\u63a5\u5df2\u751f\u6210\uff01"));
                    MutableComponent clickableLink = Component.m_237113_((String)("\u00a7b\u00a7n" + decodedUrl)).m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, decodedUrl)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u70b9\u51fb\u6253\u5f00\u4e8c\u7ef4\u7801\u9875\u9762"))));
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7b\u8bf7\u8bbf\u95ee\uff1a"));
                    player.m_213846_((Component)clickableLink);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50APP\u626b\u63cf\u9875\u9762\u4e8c\u7ef4\u7801"));
                    try {
                        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                            Desktop.getDesktop().browse(new URI(decodedUrl));
                        }
                    }
                    catch (Exception browserError) {
                        System.out.println("\u81ea\u52a8\u6253\u5f00\u6d4f\u89c8\u5668\u5931\u8d25: " + browserError.getMessage());
                    }
                    return;
                }
                catch (Exception e) {
                    System.out.println("Base64\u89e3\u7801\u5931\u8d25: " + e.getMessage());
                }
            }
            try {
                String fileName = "qrcode_" + player.m_20149_() + "_" + System.currentTimeMillis() + ".png";
                Path qrDir = Paths.get("qrcodes", new String[0]);
                if (!Files.exists(qrDir, new LinkOption[0])) {
                    Files.createDirectories(qrDir, new FileAttribute[0]);
                }
                Path qrFile = qrDir.resolve(fileName);
                String pureBase64 = qrBase64;
                if (qrBase64.contains(",")) {
                    pureBase64 = qrBase64.substring(qrBase64.indexOf(",") + 1);
                }
                byte[] imageData = Base64.getDecoder().decode(pureBase64);
                Files.write(qrFile, imageData, new OpenOption[0]);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2705 \u4e8c\u7ef4\u7801\u5df2\u4fdd\u5b58\uff01"));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u6587\u4ef6\u5df2\u4fdd\u5b58\u5230\uff1a\u00a7e" + qrFile.toAbsolutePath())));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u8bf7\u4e0b\u8f7d\u6587\u4ef6\u540e\u7528APP\u626b\u63cf\u4e8c\u7ef4\u7801"));
            }
            catch (Exception fileError) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u4e8c\u7ef4\u7801\u663e\u793a\u5931\u8d25\uff01"));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u9519\u8bef: " + originalError.getMessage())));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u670d\u52a1\u5668\u65e5\u5fd7"));
            }
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u4e8c\u7ef4\u7801\u5904\u7406\u5931\u8d25: " + e.getMessage())));
        }
    }

    private static void startQrCodeStatusCheck(ServerPlayer player, String qrKey) {
        AuthService authService = NeteaseCloudMusicAPI.getAuthService();
        CompletableFuture.runAsync(() -> {
            int maxChecks = 30;
            for (int checkCount = 0; checkCount < maxChecks; ++checkCount) {
                try {
                    Thread.sleep(10000L);
                    JsonObject statusResult = authService.checkQrCodeStatus(qrKey);
                    if (statusResult.has("code") && statusResult.get("code").getAsInt() == 803) {
                        JsonObject data = statusResult.getAsJsonObject("data");
                        if (!data.has("cookie")) {
                            AsyncHttpClientUtil.executeOnMainThread(() -> player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u767b\u5f55\u6210\u529f\u4f46\u65e0\u6cd5\u83b7\u53d6cookie\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55")));
                            qrCodeKeys.remove(player.m_20149_());
                            return;
                        }
                        String cookie = data.get("cookie").getAsString();
                        Map<String, String> cookieMap = LoginCommand.parseCookieString(cookie);
                        long expiryTime = System.currentTimeMillis() + 2592000000L;
                        CookieManager.saveCookies((Player)player, cookieMap, expiryTime);
                        AsyncHttpClientUtil.executeOnMainThread(() -> {
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2705 \u767b\u5f55\u6210\u529f\uff01"));
                            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6b22\u8fce\u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50\u670d\u52a1\uff01"));
                        });
                        qrCodeKeys.remove(player.m_20149_());
                        return;
                    }
                    if (!statusResult.has("code") || statusResult.get("code").getAsInt() != 800) continue;
                    AsyncHttpClientUtil.executeOnMainThread(() -> player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u4e8c\u7ef4\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6")));
                    qrCodeKeys.remove(player.m_20149_());
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (IOException e) {
                    AsyncHttpClientUtil.executeOnMainThread(() -> player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u68c0\u67e5\u767b\u5f55\u72b6\u6001\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()))));
                    break;
                }
            }
            qrCodeKeys.remove(player.m_20149_());
            AsyncHttpClientUtil.executeOnMainThread(() -> player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u4e8c\u7ef4\u7801\u9a8c\u8bc1\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6")));
        });
    }

    private static Map<String, String> parseCookieString(String cookieString) {
        String[] cookies;
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        for (String cookie : cookies = cookieString.split("; *")) {
            String[] parts = cookie.split("=", 2);
            if (parts.length != 2) continue;
            cookieMap.put(parts[0].trim(), parts[1].trim());
        }
        return cookieMap;
    }

    private static int loginStatus(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        JsonObject status = CookieManager.getLoginStatus((Player)player);
        if (status.get("loggedIn").getAsBoolean()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2705 \u5df2\u767b\u5f55\u7f51\u6613\u4e91\u97f3\u4e50"));
            player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u8d26\u53f7: " + status.get("playerName").getAsString())));
            player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u5269\u4f59\u65f6\u95f4: " + status.get("remainingHours").getAsInt() + "\u5c0f\u65f6" + status.get("remainingMinutes").getAsInt() + "\u5206\u949f")));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u274c \u672a\u767b\u5f55\u7f51\u6613\u4e91\u97f3\u4e50"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u4f7f\u7528 \u00a76/nclogin qr \u00a77\u8fdb\u884c\u4e8c\u7ef4\u7801\u767b\u5f55"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u4f7f\u7528 \u00a76/nclogin phone <\u624b\u673a\u53f7> <\u5bc6\u7801> \u00a77\u8fdb\u884c\u624b\u673a\u767b\u5f55"));
        }
        return 1;
    }

    private static int logout(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        CookieManager.clearCookies((Player)player);
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2705 \u5df2\u9000\u51fa\u7f51\u6613\u4e91\u97f3\u4e50\u767b\u5f55"));
        return 1;
    }

    private static int phoneLogin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String phone = StringArgumentType.getString(context, (String)"phone");
        String password = StringArgumentType.getString(context, (String)"password");
        AuthService authService = NeteaseCloudMusicAPI.getAuthService();
        AsyncHttpClientUtil.executeOnMainThread(() -> player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6b63\u5728\u5c1d\u8bd5\u624b\u673a\u767b\u5f55...")));
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return authService.phoneLogin(phone, password);
            }
            catch (IOException e) {
                throw new RuntimeException("\u624b\u673a\u767b\u5f55\u5931\u8d25: " + e.getMessage(), e);
            }
        }).thenAccept(loginResult -> {
            if (loginResult.has("code") && loginResult.get("code").getAsInt() == 200) {
                JsonObject data = loginResult.getAsJsonObject("data");
                if (data.has("cookie")) {
                    String cookie = data.get("cookie").getAsString();
                    Map<String, String> cookieMap = LoginCommand.parseCookieString(cookie);
                    long expiryTime = System.currentTimeMillis() + 2592000000L;
                    CookieManager.saveCookies((Player)player, cookieMap, expiryTime);
                    AsyncHttpClientUtil.executeOnMainThread(() -> {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2705 \u624b\u673a\u767b\u5f55\u6210\u529f\uff01"));
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u6b22\u8fce\u4f7f\u7528\u7f51\u6613\u4e91\u97f3\u4e50\u670d\u52a1\uff01"));
                    });
                }
            } else {
                AsyncHttpClientUtil.executeOnMainThread(() -> {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u624b\u673a\u767b\u5f55\u5931\u8d25\uff01"));
                    if (loginResult.has("message")) {
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u9519\u8bef\u4fe1\u606f: " + loginResult.get("message").getAsString())));
                    }
                });
            }
        })).exceptionally(e -> {
            AsyncHttpClientUtil.executeOnMainThread(() -> player.m_213846_((Component)Component.m_237113_((String)("\u00a7c\u624b\u673a\u767b\u5f55\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()))));
            return null;
        });
        return 1;
    }

    private static /* synthetic */ void lambda$startQrCodeStatusCheck$12(ServerPlayer player, int maxChecks, int finalCheckCount) {
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7e\u7b49\u5f85\u626b\u63cf\u4e2d... (" + (maxChecks - finalCheckCount) * 10 + "\u79d2\u5269\u4f59)")));
    }
}

