/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.util.AsyncHttpClientUtil;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AsyncMusicService {
    public CompletableFuture<JsonObject> searchAsync(String keywords, int limit, int offset, int type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keywords", keywords);
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        params.put("type", String.valueOf(type));
        return AsyncHttpClientUtil.getAsync("cloudsearch", params);
    }

    public void searchAsync(String keywords, int limit, int offset, int type, Consumer<JsonObject> callback, Consumer<Exception> errorCallback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keywords", keywords);
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        params.put("type", String.valueOf(type));
        AsyncHttpClientUtil.getAsync("cloudsearch", params, callback, errorCallback);
    }

    public CompletableFuture<JsonObject> getSongDetailAsync(long id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ids", String.valueOf(id));
        return AsyncHttpClientUtil.getAsync("song/detail", params);
    }

    public CompletableFuture<JsonObject> getSongUrlAsync(long id, int br) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("br", String.valueOf(br));
        return AsyncHttpClientUtil.getAsync("song/url", params);
    }

    public CompletableFuture<JsonObject> checkMusicAvailableAsync(long id, int br) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("br", String.valueOf(br));
        return AsyncHttpClientUtil.getAsync("check/music", params);
    }

    public CompletableFuture<JsonObject> getLyricAsync(long id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return AsyncHttpClientUtil.getAsync("lyric", params);
    }

    public CompletableFuture<JsonObject> getAlbumAsync(long id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return AsyncHttpClientUtil.getAsync("album", params);
    }

    public CompletableFuture<JsonObject> getArtistAsync(long id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return AsyncHttpClientUtil.getAsync("artist", params);
    }

    public CompletableFuture<JsonObject> getSimilarSongsAsync(long id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        return AsyncHttpClientUtil.getAsync("simi/song", params);
    }

    public CompletableFuture<JsonObject> getDailyRecommendSongsAsync() {
        return AsyncHttpClientUtil.getAsync("recommend/songs", null);
    }

    public CompletableFuture<JsonObject> getNewSongsAsync(int type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", String.valueOf(type));
        return AsyncHttpClientUtil.getAsync("top/song", params);
    }

    public CompletableFuture<JsonObject> getSongCommentsAsync(long id, int limit, int offset) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        params.put("limit", String.valueOf(limit));
        params.put("offset", String.valueOf(offset));
        return AsyncHttpClientUtil.getAsync("comment/music", params);
    }
}

