/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.NeteaseCloudMusicAPI;
import celia.adwadg.ncm.service.AudioService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BossBarService {
    private static final Map<UUID, CustomBossEvent> activeBossBars = new HashMap<UUID, CustomBossEvent>();
    private static String currentSongName = "";
    private static String currentArtists = "";
    private static int currentPosition = 0;
    private static int totalDuration = 0;
    private static boolean isPlaying = false;
    private static String lastSongId = "";
    private static boolean isLoading = false;
    private static long animationTick = 0L;
    private static int addPos = 0;
    private static boolean autoUpdateMode = true;

    public static void updateSongInfo(String songName, String artists, int position, int duration, boolean playing) {
        currentSongName = songName != null ? songName : "";
        currentArtists = artists != null ? artists : "";
        currentPosition = Math.max(0, position);
        totalDuration = Math.max(1, duration);
        isPlaying = playing;
        lastSongId = "";
        BossBarService.updateAllBossBars();
    }

    public static void setLoadingState(boolean loading) {
        isLoading = loading;
        BossBarService.updateAllBossBars();
    }

    public static void showBossBar(ServerPlayer player) {
        BossBarService.hideBossBar(player);
        String title = BossBarService.createBossBarTitle();
        float progress = BossBarService.calculateProgress();
        CustomBossEvent bossEvent = player.m_20194_().m_129901_().m_136299_(ResourceLocation.fromNamespaceAndPath((String)"neteasecloudmusic", (String)"song_info"), (Component)Component.m_237113_((String)title));
        bossEvent.m_142711_(progress);
        bossEvent.m_6451_(isPlaying ? BossEvent.BossBarColor.PINK : BossEvent.BossBarColor.RED);
        bossEvent.m_5648_(BossEvent.BossBarOverlay.PROGRESS);
        player.m_20194_().execute(() -> bossEvent.m_6543_(player));
        activeBossBars.put(player.m_20148_(), bossEvent);
    }

    public static void hideBossBar(ServerPlayer player) {
        CustomBossEvent bossEvent = activeBossBars.remove(player.m_20148_());
        if (bossEvent != null) {
            player.m_20194_().execute(() -> bossEvent.m_6539_(player));
        }
    }

    public static void updateAllBossBars() {
        if (activeBossBars.isEmpty()) {
            return;
        }
        String title = BossBarService.createBossBarTitle();
        float progress = BossBarService.calculateProgress();
        for (Map.Entry<UUID, CustomBossEvent> entry : activeBossBars.entrySet()) {
            CustomBossEvent bossEvent = entry.getValue();
            bossEvent.m_6456_((Component)Component.m_237113_((String)title));
            bossEvent.m_142711_(progress);
            BossEvent.BossBarColor color = isPlaying ? BossEvent.BossBarColor.GREEN : BossEvent.BossBarColor.RED;
            bossEvent.m_6451_(color);
        }
    }

    public static void clearAllBossBars() {
        for (CustomBossEvent bossEvent : activeBossBars.values()) {
            bossEvent.m_7706_();
        }
        activeBossBars.clear();
    }

    public static void resetSongInfo() {
        currentSongName = "";
        currentArtists = "";
        currentPosition = 0;
        totalDuration = 0;
        isPlaying = false;
        lastSongId = "";
        BossBarService.clearAllBossBars();
    }

    private static String createBossBarTitle() {
        Object statusIcon;
        if (currentSongName.isEmpty()) {
            return "\u00a7a\u7f51\u6613\u4e91\u97f3\u4e50\u64ad\u653e\u5668 \u00a77- \u00a7c\u65e0\u6b4c\u66f2\u64ad\u653e";
        }
        if (isLoading) {
            String[] spinner = new String[]{"\u280b", "\u2819", "\u2839", "\u2838", "\u283c", "\u2834", "\u2826", "\u2827", "\u2807", "\u280f"};
            int spinnerIndex = (int)(animationTick % (long)spinner.length);
            statusIcon = "\u00a7e" + spinner[spinnerIndex];
        } else {
            statusIcon = isPlaying ? "\u00a7a\u25b6" : "\u00a7c\u23f8";
        }
        Object timeInfo = isLoading ? "\u00a77\u52a0\u8f7d\u4e2d..." : "\u00a76" + BossBarService.formatTime(currentPosition) + " \u00a77/ \u00a7f" + BossBarService.formatTime(totalDuration);
        String animatedSongName = currentSongName;
        Object animatedArtists = currentArtists.isEmpty() ? "" : "\u00a76" + currentArtists;
        return String.format("%s \u00a7b%s \u00a77- %s \u00a78(%s)", statusIcon, animatedSongName, animatedArtists, timeInfo);
    }

    private static float calculateProgress() {
        if (totalDuration <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)currentPosition / (float)totalDuration);
    }

    private static String formatTime(int milliseconds) {
        int seconds = milliseconds / 1000;
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !activeBossBars.isEmpty()) {
            ++animationTick;
            if (event.getServer().m_129921_() % 20 == 0 && (isPlaying || isLoading)) {
                BossBarService.autoUpdateFromAudioService();
            }
            BossBarService.updateAllBossBars();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            BossBarService.hideBossBar(player2);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        BossBarService.clearAllBossBars();
    }

    private static boolean isGamePaused() {
        return false;
    }

    public static void syncWithAudioService(int position, boolean playing) {
        if (autoUpdateMode) {
            return;
        }
        currentPosition = position;
        isPlaying = playing;
        BossBarService.updateAllBossBars();
    }

    public static void autoUpdateFromAudioService() {
        block14: {
            if (!autoUpdateMode) {
                return;
            }
            try {
                boolean songChanged;
                AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
                JsonObject status = audioService.getPlaybackStatus();
                if (!status.has("data") || status.get("code").getAsInt() != 200) break block14;
                JsonObject data = status.getAsJsonObject("data");
                boolean playing = data.get("isPlaying").getAsBoolean();
                String songId = data.get("currentSongId").getAsString();
                int position = data.get("currentPosition").getAsInt() + addPos;
                boolean bl = songChanged = !songId.equals(lastSongId) && !songId.equals("\u65e0") && !songId.equals("null");
                if (songChanged) {
                    try {
                        JsonArray songs;
                        JsonObject songDetail = audioService.getSongDetail(Long.parseLong(songId));
                        if (songDetail.has("songs") && (songs = songDetail.getAsJsonArray("songs")).size() > 0) {
                            JsonObject song = songs.get(0).getAsJsonObject();
                            String songName = song.has("name") ? song.get("name").getAsString() : "\u672a\u77e5\u6b4c\u66f2";
                            String artists = "\u672a\u77e5\u827a\u4eba";
                            if (song.has("ar")) {
                                JsonArray artistsArray = song.getAsJsonArray("ar");
                                StringBuilder artistsBuilder = new StringBuilder();
                                for (JsonElement artist : artistsArray) {
                                    if (artistsBuilder.length() > 0) {
                                        artistsBuilder.append(", ");
                                    }
                                    artistsBuilder.append(artist.getAsJsonObject().get("name").getAsString());
                                }
                                artists = artistsBuilder.toString();
                            }
                            int duration = song.has("dt") ? song.get("dt").getAsInt() : 180000;
                            boolean currentLoadingState = isLoading;
                            BossBarService.updateSongInfo(songName, artists, position, duration, playing);
                            isLoading = currentLoadingState;
                            lastSongId = songId;
                            return;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("\u83b7\u53d6\u6b4c\u66f2\u8be6\u60c5\u5931\u8d25: " + e.getMessage());
                        lastSongId = songId;
                    }
                }
                if (!songId.equals("\u65e0") && !songId.equals("null")) {
                    if (!isLoading) {
                        currentPosition = position;
                        isPlaying = playing;
                        BossBarService.updateAllBossBars();
                    }
                } else if (!isLoading) {
                    BossBarService.updateSongInfo(null, null, 0, 0, false);
                }
            }
            catch (Exception e) {
                System.err.println("\u81ea\u52a8\u66f4\u65b0BossBar\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    public static String getCurrentStatus() {
        if (currentSongName.isEmpty()) {
            return "\u65e0\u6b4c\u66f2\u64ad\u653e";
        }
        return String.format("%s - %s (%s/%s) [%s]", currentSongName, currentArtists, BossBarService.formatTime(currentPosition), BossBarService.formatTime(totalDuration), isPlaying ? "\u64ad\u653e\u4e2d" : "\u5df2\u6682\u505c");
    }

    public static int getDuration() {
        return totalDuration;
    }

    public static void setAddpos(int addpos) {
        addPos = addpos;
    }

    public static int getAddpos() {
        return addPos;
    }

    public static void setAutoUpdateMode(boolean enabled) {
        autoUpdateMode = enabled;
    }

    public static void setIsPlaying(boolean isplaying) {
        isPlaying = isplaying;
    }

    public static boolean isAutoUpdateMode() {
        return autoUpdateMode;
    }

    public static boolean isIsLoading() {
        return isLoading;
    }
}

