/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.service;

import celia.adwadg.ncm.NeteaseCloudMusicAPI;
import celia.adwadg.ncm.service.AudioService;
import celia.adwadg.ncm.service.BossBarService;
import celia.adwadg.ncm.service.MusicService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;

public class PlaylistPlayerService {
    private static final Map<UUID, PlaylistState> playerPlaylists = new ConcurrentHashMap<UUID, PlaylistState>();
    private static final Map<Long, SongInfoCache> songInfoCache = new ConcurrentHashMap<Long, SongInfoCache>();

    public static JsonObject loadPlaylist(ServerPlayer player, long playlistId) throws IOException {
        JsonObject playlist;
        MusicService musicService = NeteaseCloudMusicAPI.getMusicService();
        JsonObject playlistDetail = musicService.getPlaylistDetail(playlistId);
        if (playlistDetail.has("code") && playlistDetail.get("code").getAsInt() == 200 && playlistDetail.has("playlist") && (playlist = playlistDetail.getAsJsonObject("playlist")).has("trackIds")) {
            AudioService audioService;
            JsonObject playResult;
            JsonArray trackIds = playlist.getAsJsonArray("trackIds");
            ArrayList<Long> songIds = new ArrayList<Long>();
            for (JsonElement track : trackIds) {
                JsonObject trackObj;
                if (!track.isJsonObject() || !(trackObj = track.getAsJsonObject()).has("id")) continue;
                songIds.add(trackObj.get("id").getAsLong());
            }
            PlaylistState state = new PlaylistState(playlistId, songIds);
            playerPlaylists.put(player.m_20148_(), state);
            if (!songIds.isEmpty() && (playResult = (audioService = NeteaseCloudMusicAPI.getAudioService()).playSong((Long)songIds.get(0), 128000, player)).get("code").getAsInt() == 200) {
                state.setPlaying(true);
                JsonObject result = new JsonObject();
                result.addProperty("code", (Number)200);
                result.addProperty("message", "\u6b4c\u5355\u52a0\u8f7d\u6210\u529f\uff0c\u6b63\u5728\u64ad\u653e\u7b2c\u4e00\u9996\u6b4c\u66f2");
                result.addProperty("playlistName", playlist.has("name") ? playlist.get("name").getAsString() : "\u672a\u77e5\u6b4c\u5355");
                result.addProperty("totalSongs", (Number)songIds.size());
                result.addProperty("currentSongId", (Number)songIds.get(0));
                return result;
            }
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)200);
            result.addProperty("message", "\u6b4c\u5355\u52a0\u8f7d\u6210\u529f\uff0c\u5171 " + songIds.size() + " \u9996\u6b4c\u66f2");
            result.addProperty("playlistName", playlist.has("name") ? playlist.get("name").getAsString() : "\u672a\u77e5\u6b4c\u5355");
            result.addProperty("totalSongs", (Number)songIds.size());
            return result;
        }
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)500);
        result.addProperty("error", "\u65e0\u6cd5\u52a0\u8f7d\u6b4c\u5355\u6216\u6b4c\u5355\u4e3a\u7a7a");
        return result;
    }

    public static PlaylistState getPlayerPlaylist(ServerPlayer player) {
        return playerPlaylists.get(player.m_20148_());
    }

    public static void clearPlaylist(ServerPlayer player) {
        playerPlaylists.remove(player.m_20148_());
    }

    public static JsonObject playSongFromPlaylist(ServerPlayer player, long songId) {
        PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
        if (state == null) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u8bf7\u5148\u52a0\u8f7d\u6b4c\u5355");
            return result;
        }
        if (!state.songIds.contains(songId)) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u6b4c\u66f2\u4e0d\u5728\u5f53\u524d\u6b4c\u5355\u4e2d");
            return result;
        }
        state.setCurrentSong(songId);
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        try {
            JsonObject playResult = audioService.playSong(songId, 128000, player);
            if (playResult.get("code").getAsInt() == 200) {
                state.setPlaying(true);
                JsonObject result = new JsonObject();
                result.addProperty("code", (Number)200);
                result.addProperty("message", "\u6b63\u5728\u64ad\u653e\u6b4c\u66f2: " + songId);
                result.addProperty("songId", (Number)songId);
                result.addProperty("position", (Number)state.getCurrentPosition());
                result.addProperty("total", (Number)state.getTotalSongs());
                return result;
            }
            return playResult;
        }
        catch (IOException e) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u64ad\u653e\u5931\u8d25: " + e.getMessage());
            return result;
        }
    }

    public static JsonObject playNext(ServerPlayer player) {
        PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
        if (state == null || !state.hasNext()) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u6ca1\u6709\u4e0b\u4e00\u9996\u6b4c\u66f2\u6216\u6b4c\u5355\u672a\u52a0\u8f7d");
            return result;
        }
        long nextSongId = state.getNextSong();
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        try {
            JsonObject playResult = audioService.playSong(nextSongId, 128000, player);
            if (playResult.get("code").getAsInt() == 200) {
                state.setPlaying(true);
                JsonObject result = new JsonObject();
                result.addProperty("code", (Number)200);
                result.addProperty("message", "\u6b63\u5728\u64ad\u653e\u4e0b\u4e00\u9996\u6b4c\u66f2: " + nextSongId);
                result.addProperty("songId", (Number)nextSongId);
                result.addProperty("position", (Number)state.getCurrentPosition());
                result.addProperty("total", (Number)state.getTotalSongs());
                return result;
            }
            return playResult;
        }
        catch (IOException e) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u64ad\u653e\u5931\u8d25: " + e.getMessage());
            return result;
        }
    }

    public static JsonObject playPrevious(ServerPlayer player) {
        PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
        if (state == null || !state.hasPrevious()) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u6ca1\u6709\u4e0a\u4e00\u9996\u6b4c\u66f2\u6216\u6b4c\u5355\u672a\u52a0\u8f7d");
            return result;
        }
        long prevSongId = state.getPreviousSong();
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        try {
            JsonObject playResult = audioService.playSong(prevSongId, 128000, player);
            if (playResult.get("code").getAsInt() == 200) {
                state.setPlaying(true);
                JsonObject result = new JsonObject();
                result.addProperty("code", (Number)200);
                result.addProperty("message", "\u6b63\u5728\u64ad\u653e\u4e0a\u4e00\u9996\u6b4c\u66f2: " + prevSongId);
                result.addProperty("songId", (Number)prevSongId);
                result.addProperty("position", (Number)state.getCurrentPosition());
                result.addProperty("total", (Number)state.getTotalSongs());
                return result;
            }
            return playResult;
        }
        catch (IOException e) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u64ad\u653e\u5931\u8d25: " + e.getMessage());
            return result;
        }
    }

    public static JsonObject setPlayOrder(ServerPlayer player, PlayOrder order) {
        PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
        if (state == null) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u8bf7\u5148\u52a0\u8f7d\u6b4c\u5355");
            return result;
        }
        state.setPlayOrder(order);
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.addProperty("message", "\u64ad\u653e\u987a\u5e8f\u5df2\u8bbe\u7f6e\u4e3a: " + PlaylistPlayerService.getOrderName(order));
        return result;
    }

    public static JsonObject shufflePlaylist(ServerPlayer player) {
        PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
        if (state == null) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u8bf7\u5148\u52a0\u8f7d\u6b4c\u5355");
            return result;
        }
        state.shuffle();
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.addProperty("message", "\u6b4c\u5355\u5df2\u968f\u673a\u6392\u5e8f");
        result.addProperty("currentPosition", (Number)state.getCurrentPosition());
        return result;
    }

    public static JsonObject sortPlaylist(ServerPlayer player) {
        PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
        if (state == null) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u8bf7\u5148\u52a0\u8f7d\u6b4c\u5355");
            return result;
        }
        state.sortById();
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.addProperty("message", "\u6b4c\u5355\u5df2\u6309ID\u6392\u5e8f");
        result.addProperty("currentPosition", (Number)state.getCurrentPosition());
        return result;
    }

    public static JsonObject getPlaylistStatus(ServerPlayer player) {
        PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
        if (state == null) {
            JsonObject result = new JsonObject();
            result.addProperty("code", (Number)500);
            result.addProperty("error", "\u6ca1\u6709\u52a0\u8f7d\u7684\u6b4c\u5355");
            return result;
        }
        JsonObject result = new JsonObject();
        result.addProperty("code", (Number)200);
        result.addProperty("playlistId", (Number)state.playlistId);
        result.addProperty("currentSongId", (Number)state.getCurrentSongId());
        result.addProperty("currentPosition", (Number)state.getCurrentPosition());
        result.addProperty("totalSongs", (Number)state.getTotalSongs());
        result.addProperty("playOrder", PlaylistPlayerService.getOrderName(state.getPlayOrder()));
        result.addProperty("isPlaying", Boolean.valueOf(state.isPlaying()));
        return result;
    }

    private static String getOrderName(PlayOrder order) {
        switch (order) {
            case SEQUENTIAL: {
                return "\u987a\u5e8f\u64ad\u653e";
            }
            case SHUFFLE: {
                return "\u968f\u673a\u64ad\u653e";
            }
            case REPEAT_ONE: {
                return "\u5355\u66f2\u5faa\u73af";
            }
            case REPEAT_ALL: {
                return "\u5217\u8868\u5faa\u73af";
            }
        }
        return "\u672a\u77e5";
    }

    private static SongInfoCache getSongInfo(long songId) throws IOException {
        JsonArray songs;
        SongInfoCache cached = songInfoCache.get(songId);
        if (cached != null && !cached.isExpired()) {
            return cached;
        }
        AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
        JsonObject songDetail = audioService.getSongDetail(songId);
        if (songDetail.has("songs") && (songs = songDetail.getAsJsonArray("songs")).size() > 0) {
            JsonObject song = songs.get(0).getAsJsonObject();
            String songName = song.has("name") ? song.get("name").getAsString() : "\u672a\u77e5\u6b4c\u66f2";
            String artists = "\u672a\u77e5\u827a\u4eba";
            int duration = 180000;
            if (song.has("ar")) {
                JsonArray artistsArray = song.getAsJsonArray("ar");
                StringBuilder artistsBuilder = new StringBuilder();
                for (JsonElement artist : artistsArray) {
                    if (artistsBuilder.length() > 0) {
                        artistsBuilder.append(", ");
                    }
                    artistsBuilder.append(artist.getAsJsonObject().get("name").getAsString());
                }
                artists = artistsBuilder.toString();
            }
            if (song.has("dt")) {
                duration = song.get("dt").getAsInt();
            }
            SongInfoCache newCache = new SongInfoCache(songName, artists, duration);
            songInfoCache.put(songId, newCache);
            return newCache;
        }
        return null;
    }

    public static void autoPlayNext(ServerPlayer player) {
        PlaylistState state = PlaylistPlayerService.getPlayerPlaylist(player);
        if (state != null && state.isPlaying() && state.hasNext()) {
            long nextSongId = state.getNextSong();
            AudioService audioService = NeteaseCloudMusicAPI.getAudioService();
            try {
                SongInfoCache songInfo = PlaylistPlayerService.getSongInfo(nextSongId);
                JsonObject playResult = audioService.playSong(nextSongId, 128000, player);
                if (playResult.get("code").getAsInt() == 200) {
                    state.setPlaying(true);
                    System.out.println("\u81ea\u52a8\u64ad\u653e\u4e0b\u4e00\u9996\u6b4c\u66f2: " + nextSongId + ", \u4f4d\u7f6e: " + state.getCurrentPosition() + "/" + state.getTotalSongs());
                    if (songInfo != null) {
                        NeteaseCloudMusicAPI.getBossBarService();
                        BossBarService.updateSongInfo(songInfo.songName, songInfo.artists, 0, songInfo.duration, true);
                    }
                }
            }
            catch (IOException e) {
                System.err.println("\u81ea\u52a8\u64ad\u653e\u4e0b\u4e00\u9996\u5931\u8d25: " + e.getMessage());
            }
        }
    }

    public static class PlaylistState {
        public long playlistId;
        public List<Long> songIds;
        private int currentIndex;
        private PlayOrder playOrder;
        private boolean isPlaying;

        public PlaylistState(long playlistId, List<Long> songIds) {
            this.playlistId = playlistId;
            this.songIds = new ArrayList<Long>(songIds);
            this.currentIndex = 0;
            this.playOrder = PlayOrder.SEQUENTIAL;
            this.isPlaying = false;
        }

        public long getCurrentSongId() {
            if (this.songIds.isEmpty() || this.currentIndex < 0 || this.currentIndex >= this.songIds.size()) {
                return -1L;
            }
            return this.songIds.get(this.currentIndex);
        }

        public boolean hasNext() {
            if (this.songIds.isEmpty()) {
                return false;
            }
            switch (this.playOrder) {
                case REPEAT_ONE: {
                    return true;
                }
                case SEQUENTIAL: 
                case REPEAT_ALL: {
                    return this.currentIndex < this.songIds.size() - 1 || this.playOrder == PlayOrder.REPEAT_ALL;
                }
                case SHUFFLE: {
                    return this.songIds.size() > 1;
                }
            }
            return false;
        }

        public boolean hasPrevious() {
            if (this.songIds.isEmpty()) {
                return false;
            }
            switch (this.playOrder) {
                case REPEAT_ONE: {
                    return true;
                }
                case SEQUENTIAL: 
                case REPEAT_ALL: {
                    return this.currentIndex > 0 || this.playOrder == PlayOrder.REPEAT_ALL;
                }
                case SHUFFLE: {
                    return this.songIds.size() > 1;
                }
            }
            return false;
        }

        public long getNextSong() {
            if (this.songIds.isEmpty()) {
                return -1L;
            }
            switch (this.playOrder) {
                case REPEAT_ONE: {
                    return this.getCurrentSongId();
                }
                case SEQUENTIAL: {
                    ++this.currentIndex;
                    if (this.currentIndex < this.songIds.size()) break;
                    this.currentIndex = 0;
                    break;
                }
                case REPEAT_ALL: {
                    this.currentIndex = (this.currentIndex + 1) % this.songIds.size();
                    break;
                }
                case SHUFFLE: {
                    int newIndex;
                    if (this.songIds.size() <= 1) break;
                    while ((newIndex = new Random().nextInt(this.songIds.size())) == this.currentIndex) {
                    }
                    this.currentIndex = newIndex;
                }
            }
            return this.getCurrentSongId();
        }

        public long getPreviousSong() {
            if (this.songIds.isEmpty()) {
                return -1L;
            }
            switch (this.playOrder) {
                case REPEAT_ONE: {
                    return this.getCurrentSongId();
                }
                case SEQUENTIAL: {
                    --this.currentIndex;
                    if (this.currentIndex >= 0) break;
                    this.currentIndex = this.songIds.size() - 1;
                    break;
                }
                case REPEAT_ALL: {
                    this.currentIndex = (this.currentIndex - 1 + this.songIds.size()) % this.songIds.size();
                    break;
                }
                case SHUFFLE: {
                    int newIndex;
                    if (this.songIds.size() <= 1) break;
                    while ((newIndex = new Random().nextInt(this.songIds.size())) == this.currentIndex) {
                    }
                    this.currentIndex = newIndex;
                }
            }
            return this.getCurrentSongId();
        }

        public void setPlayOrder(PlayOrder order) {
            this.playOrder = order;
        }

        public PlayOrder getPlayOrder() {
            return this.playOrder;
        }

        public void shuffle() {
            if (this.songIds.size() > 1) {
                int newIndex;
                Collections.shuffle(this.songIds);
                long currentSong = this.getCurrentSongId();
                if (currentSong != -1L && (newIndex = this.songIds.indexOf(currentSong)) != -1) {
                    this.currentIndex = newIndex;
                }
            }
        }

        public void sortById() {
            Collections.sort(this.songIds);
            long currentSong = this.getCurrentSongId();
            if (currentSong != -1L) {
                this.currentIndex = this.songIds.indexOf(currentSong);
            }
        }

        public int getTotalSongs() {
            return this.songIds.size();
        }

        public int getCurrentPosition() {
            return this.currentIndex + 1;
        }

        public boolean isPlaying() {
            return this.isPlaying;
        }

        public void setPlaying(boolean playing) {
            this.isPlaying = playing;
        }

        public void setCurrentSong(long songId) {
            int index = this.songIds.indexOf(songId);
            if (index != -1) {
                this.currentIndex = index;
            }
        }
    }

    public static enum PlayOrder {
        SEQUENTIAL,
        SHUFFLE,
        REPEAT_ONE,
        REPEAT_ALL;

    }

    private static class SongInfoCache {
        public final String songName;
        public final String artists;
        public final int duration;
        public final long timestamp;

        public SongInfoCache(String songName, String artists, int duration) {
            this.songName = songName;
            this.artists = artists;
            this.duration = duration;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 300000L;
        }
    }
}

