/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.util;

import celia.adwadg.ncm.config.ModConfig;
import celia.adwadg.ncm.util.HttpClientUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class AsyncHttpClientUtil {
    private static final Gson GSON = new Gson();
    private static CloseableHttpClient httpClient;
    private static ExecutorService executorService;

    public static void getAsync(String path, Map<String, String> params, Consumer<JsonObject> callback, Consumer<Exception> errorCallback) {
        AsyncHttpClientUtil.submitTask(() -> {
            block2: {
                try {
                    JsonObject result = HttpClientUtil.get(path, params);
                    callback.accept(result);
                }
                catch (IOException e) {
                    if (errorCallback == null) break block2;
                    errorCallback.accept(e);
                }
            }
        });
    }

    public static void postAsync(String path, Map<String, String> params, Object data, Consumer<JsonObject> callback, Consumer<Exception> errorCallback) {
        AsyncHttpClientUtil.submitTask(() -> {
            block2: {
                try {
                    JsonObject result = HttpClientUtil.post(path, params, data);
                    callback.accept(result);
                }
                catch (IOException e) {
                    if (errorCallback == null) break block2;
                    errorCallback.accept(e);
                }
            }
        });
    }

    public static CompletableFuture<JsonObject> getAsync(String path, Map<String, String> params) {
        CompletableFuture<JsonObject> future = new CompletableFuture<JsonObject>();
        AsyncHttpClientUtil.submitTask(() -> {
            try {
                JsonObject result = HttpClientUtil.get(path, params);
                future.complete(result);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static CompletableFuture<JsonObject> postAsync(String path, Map<String, String> params, Object data) {
        CompletableFuture<JsonObject> future = new CompletableFuture<JsonObject>();
        AsyncHttpClientUtil.submitTask(() -> {
            try {
                JsonObject result = HttpClientUtil.post(path, params, data);
                future.complete(result);
            }
            catch (IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static void executeOnMainThread(Runnable task) {
        if (Minecraft.m_91087_() != null) {
            Minecraft.m_91087_().execute(task);
        } else {
            task.run();
        }
    }

    private static void submitTask(Runnable task) {
        if (executorService != null && !executorService.isShutdown()) {
            executorService.submit(task);
        } else {
            AsyncHttpClientUtil.initExecutorService();
            executorService.submit(task);
        }
    }

    private static void initHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(((Integer)ModConfig.CONNECT_TIMEOUT.get()).intValue()).setSocketTimeout(((Integer)ModConfig.READ_TIMEOUT.get()).intValue()).build();
        httpClient = HttpClients.custom().setDefaultRequestConfig(config).build();
    }

    private static void initExecutorService() {
        if (executorService != null) {
            AsyncHttpClientUtil.shutdownExecutor();
        }
        executorService = Executors.newFixedThreadPool((Integer)ModConfig.MAX_NETWORK_THREADS.get(), new ThreadFactory(){
            private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.defaultFactory.newThread(r);
                thread.setName("ncm-network-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public static void shutdownExecutor() {
        if (executorService != null) {
            try {
                executorService.shutdown();
                if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void shutdown() {
        AsyncHttpClientUtil.shutdownExecutor();
        try {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        catch (IOException e) {
            System.err.println("\u5173\u95edHTTP\u5ba2\u6237\u7aef\u65f6\u51fa\u9519: " + e.getMessage());
        }
    }

    public static void reinit() {
        AsyncHttpClientUtil.shutdown();
        AsyncHttpClientUtil.initHttpClient();
        AsyncHttpClientUtil.initExecutorService();
    }

    static {
        AsyncHttpClientUtil.initHttpClient();
        AsyncHttpClientUtil.initExecutorService();
    }
}

