/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.player.Player;

public class CookieManager {
    private static final Gson GSON = new Gson();
    private static final String COOKIE_DIR = "config/ncm/cookies/";
    private static final Map<UUID, Map<String, String>> cookieCache = new ConcurrentHashMap<UUID, Map<String, String>>();
    private static final Map<UUID, Long> cookieExpiryCache = new ConcurrentHashMap<UUID, Long>();

    private CookieManager() {
    }

    public static void saveCookies(Player player, Map<String, String> cookies, long expiryTime) {
        if (player == null || cookies == null || cookies.isEmpty()) {
            System.out.println("Cannot save cookies: player or cookies are null/empty");
            return;
        }
        UUID playerId = player.m_20148_();
        cookieCache.put(playerId, new HashMap<String, String>(cookies));
        cookieExpiryCache.put(playerId, expiryTime);
        try {
            Path dirPath = Paths.get(COOKIE_DIR, new String[0]);
            if (!Files.exists(dirPath, new LinkOption[0])) {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            File cookieFile = CookieManager.getCookieFile(playerId);
            JsonObject cookieData = new JsonObject();
            cookieData.addProperty("expiryTime", (Number)expiryTime);
            cookieData.addProperty("playerName", player.m_7755_().getString());
            cookieData.addProperty("saveTime", (Number)System.currentTimeMillis());
            JsonObject cookiesJson = new JsonObject();
            cookies.forEach((arg_0, arg_1) -> ((JsonObject)cookiesJson).addProperty(arg_0, arg_1));
            cookieData.add("cookies", (JsonElement)cookiesJson);
            try (FileWriter writer = new FileWriter(cookieFile);){
                GSON.toJson((JsonElement)cookieData, (Appendable)writer);
            }
            System.out.println("Cookies saved for player: " + player.m_7755_().getString() + " (" + playerId + "), expiry: " + expiryTime);
        }
        catch (IOException e) {
            System.err.println("Failed to save cookies for player " + player.m_7755_().getString() + " (" + playerId + "): " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> loadCookies(Player player) {
        if (player == null) {
            System.out.println("Cannot load cookies: player is null");
            return new HashMap<String, String>();
        }
        UUID playerId = player.m_20148_();
        if (cookieCache.containsKey(playerId)) {
            Map<String, String> cachedCookies = cookieCache.get(playerId);
            Long expiryTime = cookieExpiryCache.get(playerId);
            if (expiryTime != null && expiryTime > System.currentTimeMillis()) {
                System.out.println("Using cached cookies for player: " + playerId);
                return new HashMap<String, String>(cachedCookies);
            }
            cookieCache.remove(playerId);
            cookieExpiryCache.remove(playerId);
            System.out.println("Cached cookies expired for player: " + playerId);
        }
        try {
            File cookieFile = CookieManager.getCookieFile(playerId);
            if (!cookieFile.exists()) {
                System.out.println("No cookie file found for player: " + playerId);
                return new HashMap<String, String>();
            }
            try (FileReader reader = new FileReader(cookieFile);){
                JsonObject cookieData = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (cookieData == null) {
                    System.out.println("Cookie file is empty for player: " + playerId);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    return hashMap;
                }
                long expiryTime = cookieData.get("expiryTime").getAsLong();
                if (expiryTime <= System.currentTimeMillis()) {
                    System.out.println("Cookies expired for player: " + playerId);
                    CookieManager.clearCookies(player);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    return hashMap;
                }
                JsonObject cookiesJson = cookieData.getAsJsonObject("cookies");
                HashMap<String, String> cookies = new HashMap<String, String>();
                cookiesJson.entrySet().forEach(entry -> cookies.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
                cookieCache.put(playerId, new HashMap(cookies));
                cookieExpiryCache.put(playerId, expiryTime);
                System.out.println("Cookies loaded for player: " + playerId);
                HashMap<String, String> hashMap = cookies;
                return hashMap;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load cookies for player " + playerId + ": " + e.getMessage());
            return new HashMap<String, String>();
        }
    }

    public static void clearCookies(Player player) {
        if (player == null) {
            System.out.println("Cannot clear cookies: player is null");
            return;
        }
        UUID playerId = player.m_20148_();
        cookieCache.remove(playerId);
        cookieExpiryCache.remove(playerId);
        try {
            File cookieFile = CookieManager.getCookieFile(playerId);
            if (cookieFile.exists()) {
                if (cookieFile.delete()) {
                    System.out.println("Cookies cleared for player: " + playerId);
                } else {
                    System.err.println("Failed to delete cookie file for player: " + playerId);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to clear cookies for player " + playerId + ": " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasValidCookies(Player player) {
        if (player == null) {
            return false;
        }
        UUID playerId = player.m_20148_();
        if (cookieCache.containsKey(playerId)) {
            Long expiryTime = cookieExpiryCache.get(playerId);
            if (expiryTime == null) return false;
            if (expiryTime <= System.currentTimeMillis()) return false;
            return true;
        }
        try {
            File cookieFile = CookieManager.getCookieFile(playerId);
            if (!cookieFile.exists()) {
                return false;
            }
            try (FileReader reader = new FileReader(cookieFile);){
                JsonObject cookieData = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (cookieData == null) return false;
                if (!cookieData.has("expiryTime")) return false;
                long expiryTime = cookieData.get("expiryTime").getAsLong();
                boolean bl = expiryTime > System.currentTimeMillis();
                return bl;
            }
        }
        catch (IOException e) {
            System.err.println("Error checking cookie validity for player " + playerId + ": " + e.getMessage());
        }
        return false;
    }

    public static String getCookieString(Player player) {
        Map<String, String> cookies = CookieManager.loadCookies(player);
        if (cookies.isEmpty()) {
            return "";
        }
        StringBuilder cookieBuilder = new StringBuilder();
        cookies.forEach((key, value) -> {
            if (cookieBuilder.length() > 0) {
                cookieBuilder.append("; ");
            }
            cookieBuilder.append((String)key).append("=").append((String)value);
        });
        return cookieBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getCookieExpiryTime(Player player) {
        if (player == null) {
            return 0L;
        }
        UUID playerId = player.m_20148_();
        if (cookieExpiryCache.containsKey(playerId)) {
            return cookieExpiryCache.get(playerId);
        }
        try {
            File cookieFile = CookieManager.getCookieFile(playerId);
            if (!cookieFile.exists()) return 0L;
            try (FileReader reader = new FileReader(cookieFile);){
                JsonObject cookieData = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (cookieData == null) return 0L;
                if (!cookieData.has("expiryTime")) return 0L;
                long l = cookieData.get("expiryTime").getAsLong();
                return l;
            }
        }
        catch (IOException e) {
            System.err.println("Error getting cookie expiry time for player " + playerId + ": " + e.getMessage());
        }
        return 0L;
    }

    private static File getCookieFile(UUID playerId) {
        return new File(COOKIE_DIR + playerId.toString() + ".json");
    }

    public static void cleanupExpiredCookies() {
        try {
            Path dirPath = Paths.get(COOKIE_DIR, new String[0]);
            if (!Files.exists(dirPath, new LinkOption[0])) {
                return;
            }
            Files.list(dirPath).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                try (FileReader reader = new FileReader(path.toFile());){
                    long expiryTime;
                    JsonObject cookieData = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (cookieData != null && cookieData.has("expiryTime") && (expiryTime = cookieData.get("expiryTime").getAsLong()) <= System.currentTimeMillis()) {
                        Files.delete(path);
                        String playerName = cookieData.has("playerName") ? cookieData.get("playerName").getAsString() : "unknown";
                        System.out.println("Deleted expired cookie file for " + playerName + ": " + path.getFileName());
                    }
                }
                catch (Exception e) {
                    System.err.println("Error processing cookie file " + path + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            System.err.println("Error cleaning up expired cookies: " + e.getMessage());
        }
    }

    public static JsonObject getCookieInfo(Player player) {
        JsonObject info;
        block12: {
            if (player == null) {
                return new JsonObject();
            }
            UUID playerId = player.m_20148_();
            info = new JsonObject();
            info.addProperty("hasCookies", Boolean.valueOf(CookieManager.hasValidCookies(player)));
            info.addProperty("expiryTime", (Number)CookieManager.getCookieExpiryTime(player));
            try {
                File cookieFile = CookieManager.getCookieFile(playerId);
                if (!cookieFile.exists()) break block12;
                try (FileReader reader = new FileReader(cookieFile);){
                    JsonObject cookieData = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (cookieData != null) {
                        if (cookieData.has("playerName")) {
                            info.addProperty("playerName", cookieData.get("playerName").getAsString());
                        }
                        if (cookieData.has("saveTime")) {
                            info.addProperty("saveTime", (Number)cookieData.get("saveTime").getAsLong());
                        }
                        if (cookieData.has("cookies")) {
                            JsonObject cookies = cookieData.getAsJsonObject("cookies");
                            info.addProperty("cookieCount", (Number)cookies.size());
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error getting cookie info for player " + playerId + ": " + e.getMessage());
            }
        }
        return info;
    }

    public static void validateCookies(Player player) {
        if (player == null || !CookieManager.hasValidCookies(player)) {
            return;
        }
        UUID playerId = player.m_20148_();
        long expiryTime = CookieManager.getCookieExpiryTime(player);
        if (expiryTime > 0L && expiryTime - System.currentTimeMillis() < 86400000L) {
            System.out.println("Warning: Cookies for player " + player.m_7755_().getString() + " will expire in " + (expiryTime - System.currentTimeMillis()) / 3600000L + " hours");
        }
    }

    public static JsonObject getLoginStatus(Player player) {
        JsonObject status = new JsonObject();
        status.addProperty("loggedIn", Boolean.valueOf(CookieManager.hasValidCookies(player)));
        status.addProperty("expiryTime", (Number)CookieManager.getCookieExpiryTime(player));
        status.addProperty("playerId", player.m_20148_().toString());
        status.addProperty("playerName", player.m_7755_().getString());
        if (CookieManager.hasValidCookies(player)) {
            long remainingTime = CookieManager.getCookieExpiryTime(player) - System.currentTimeMillis();
            status.addProperty("remainingHours", (Number)(remainingTime / 3600000L));
            status.addProperty("remainingMinutes", (Number)(remainingTime % 3600000L / 60000L));
        }
        return status;
    }

    public static boolean checkAndCleanCookies(Player player) {
        if (player == null) {
            return false;
        }
        if (!CookieManager.hasValidCookies(player)) {
            CookieManager.clearCookies(player);
            return false;
        }
        return true;
    }
}

