/*
 * Decompiled with CFR 0.152.
 */
package celia.adwadg.ncm.util;

import celia.adwadg.ncm.config.ModConfig;
import celia.adwadg.ncm.util.CookieManager;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final Gson GSON = new Gson();
    private static CloseableHttpClient httpClient;

    public static JsonObject get(String path, Map<String, String> params) throws IOException {
        return HttpClientUtil.get(path, params, null);
    }

    public static JsonObject get(String path, Map<String, String> params, Player player) throws IOException {
        String url = HttpClientUtil.buildUrl(path, params);
        HttpGet request = new HttpGet(url);
        HttpClientUtil.addCookieHeader((HttpRequestBase)request, player);
        return HttpClientUtil.executeRequest((HttpRequestBase)request);
    }

    public static JsonObject post(String path, Map<String, String> params, Object data) throws IOException {
        return HttpClientUtil.post(path, params, data, null);
    }

    public static JsonObject post(String path, Map<String, String> params, Object data, Player player) throws IOException {
        String url = HttpClientUtil.buildUrl(path, params);
        HttpPost request = new HttpPost(url);
        HttpClientUtil.addCookieHeader((HttpRequestBase)request, player);
        if (data != null) {
            String json = GSON.toJson(data);
            request.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
            request.setHeader("Content-Type", "application/json; charset=UTF-8");
        }
        return HttpClientUtil.executeRequest((HttpRequestBase)request);
    }

    private static void addCookieHeader(HttpRequestBase request, Player player) {
        String cookieString;
        if (player != null && CookieManager.hasValidCookies(player) && !(cookieString = CookieManager.getCookieString(player)).isEmpty()) {
            request.setHeader("Cookie", cookieString);
        }
    }

    private static String buildUrl(String path, Map<String, String> params) {
        StringBuilder urlBuilder = new StringBuilder((String)ModConfig.API_ENDPOINT.get());
        if (!((String)ModConfig.API_ENDPOINT.get()).endsWith("/") && !path.startsWith("/")) {
            urlBuilder.append("/");
        }
        urlBuilder.append(path);
        if (params != null && !params.isEmpty()) {
            urlBuilder.append("?");
            params.forEach((key, value) -> urlBuilder.append((String)key).append("=").append((String)value).append("&"));
            urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        }
        return urlBuilder.toString();
    }

    private static JsonObject executeRequest(HttpRequestBase request) throws IOException {
        int retries = 0;
        int maxRetries = (Boolean)ModConfig.ENABLE_RETRY.get() != false ? (Integer)ModConfig.MAX_RETRIES.get() : 0;
        while (true) {
            try {
                if (httpClient == null) {
                    HttpClientUtil.init();
                }
                System.out.println("Making API request to: " + request.getURI());
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    System.out.println("API response: " + result);
                    String uri = request.getURI().toString();
                    if (uri.contains("login/qr") || uri.contains("login/status")) {
                        System.out.println("DEBUG - Login API response: " + result);
                    }
                    return (JsonObject)GSON.fromJson(result, JsonObject.class);
                }
                return new JsonObject();
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("Connection pool shut down")) {
                    System.out.println("HTTP\u8fde\u63a5\u6c60\u5df2\u5173\u95ed\uff0c\u91cd\u65b0\u521d\u59cb\u5316...");
                    HttpClientUtil.init();
                    if (++retries <= maxRetries) continue;
                    throw new IOException("HTTP\u8bf7\u6c42\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\u8d85\u8fc7\u9650\u5236", e);
                }
                throw new IOException("HTTP\u8bf7\u6c42\u5931\u8d25", e);
            }
            catch (IOException e) {
                if (retries >= maxRetries) {
                    throw e;
                }
                ++retries;
                try {
                    Thread.sleep(1000 * retries);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Request interrupted", e);
                }
            }
        }
    }

    public static void close() throws IOException {
        if (httpClient != null) {
            httpClient.close();
        }
    }

    public static void init() {
        try {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (Exception e) {
                    System.out.println("\u5173\u95ed\u65e7HTTP\u5ba2\u6237\u7aef\u65f6\u51fa\u9519: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u6e05\u7406\u65e7HTTP\u5ba2\u6237\u7aef\u65f6\u51fa\u9519: " + e.getMessage());
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(((Integer)ModConfig.CONNECT_TIMEOUT.get()).intValue()).setSocketTimeout(((Integer)ModConfig.READ_TIMEOUT.get()).intValue()).build();
        httpClient = HttpClients.custom().setDefaultRequestConfig(config).build();
        System.out.println("HTTP\u5ba2\u6237\u7aef\u5df2\u91cd\u65b0\u521d\u59cb\u5316");
    }

    static {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(((Integer)ModConfig.CONNECT_TIMEOUT.get()).intValue()).setSocketTimeout(((Integer)ModConfig.READ_TIMEOUT.get()).intValue()).build();
        httpClient = HttpClients.custom().setDefaultRequestConfig(config).build();
    }
}

